/*************************************************

gui.h
used by tw686x

**************************************************/

#ifndef GUI_H
#define GUI_H

#define VIDEO_NONE                   0
#define VIDEO_RGB15_LE               1	/* 15 bpp little endian */
#define VIDEO_RGB16_LE               2	/* 16 bpp little endian */
#define VIDEO_RGB15_BE               3	/* 15 bpp big endian */
#define VIDEO_RGB16_BE               4	/* 16 bpp big endian */
#define VIDEO_YUYV                   5	/* 4:2:2 */
#define VIDEO_YUV422P                6	/* YUV 4:2:2 (planar) */
#define VIDEO_YUV420P                7	/* YUV 4:2:0 (planar) */
#define VIDEO_UYVY                   8	/* 4:2:2 */
#define VIDEO_FMT_COUNT              9

#define FMT_VIDEO_YUYV               0x32595559
#define FMT_VIDEO_UYVY               0x59565955
#define FMT_VIDEO_YUV420P            0x30323449
#define UNSET                        (-1U)
#define GUI_BUTTON_COUNT             21
#define GUI_TAB_COUNT                4

typedef struct
{
    unsigned int adaptors;
    int formats;
    XvImageFormatValues *fo;
    XvAdaptorInfo *ai;
    GC gc;
    Window win;
    Display *dpy;
    unsigned int im_adaptor;
    unsigned int im_port;
    unsigned int im_formats[VIDEO_FMT_COUNT];
    int show_curr;
    int show_begin;
    int show_end;
    int show_single;
    int show_fullscreen;
    GtkWidget *wdt;

    int video_count;
    channel_t channel[MAX_CHANNEL_NUM];

    pthread_t aud_capture_thread;
    pthread_t aud_play_thread;
    int       aud_play_fd;
    unsigned char* aud_play_data;
    int       aud_play_len;

    int b_quit;
    int (* on_start)(void * ctx);
    int (* on_quit)(void * ctx);
} gui_t;

int gui_start (gui_t * gui);
int get_select (int x, int y, int left, int top,
        int width, int height, int count);


#endif /* GUI_H */
