// NetBroadcasterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetBroadcaster.h"
#include "NetBroadcasterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = 0;
	
	pNetBroadcasterDlg->m_nVideoHeight = 0;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = FALSE;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = 0.0;
	
	pNetBroadcasterDlg->m_nAudioChannels = 0; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = 0;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = 0;

	pNetBroadcasterDlg->m_statFormat.SetWindowText( "INFO: ..." );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = 0;
	
	pNetBroadcasterDlg->m_nVideoHeight = 0;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = FALSE;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = 0.0;
	
	pNetBroadcasterDlg->m_nAudioChannels = 0; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = 0;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = 0;

	pNetBroadcasterDlg->m_statFormat.SetWindowText( "INFO: ..." );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = nVideoWidth;
	
	pNetBroadcasterDlg->m_nVideoHeight = nVideoHeight;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = bVideoIsInterleaved;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = dVideoFrameRate;
	
	pNetBroadcasterDlg->m_nAudioChannels = nAudioChannels; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = nAudioBitsPerSample;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = nAudioSampleFrequency;

	CHAR psz[ MAX_PATH ];

	if( bVideoIsInterleaved == TRUE ) {

		sprintf( psz, "INFO: %dx%dI@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

		pNetBroadcasterDlg->m_statFormat.SetWindowText( psz );
	}
	else {

		sprintf( psz, "INFO: %dx%dP@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

		pNetBroadcasterDlg->m_statFormat.SetWindowText( psz );
	}
	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

    return QCAP_RT_OK;
}

QRETURN on_video_hardware_encoder_callback( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);
	
	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

	if( pNetBroadcasterDlg->m_nNetworkServerState > 0x00000000 ) {

		QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, iRecNum, pFrameBuffer, nFrameBufferLen, bIsKeyFrame, dSampleTime );
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

	if( pNetBroadcasterDlg->m_nNetworkServerState > 0x00000000 ) {

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen, dSampleTime );

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 1, pFrameBuffer, nFrameBufferLen, dSampleTime );
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

    return QCAP_RT_OK;
}

extern CNetBroadcasterApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg dialog

CNetBroadcasterDlg::CNetBroadcasterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetBroadcasterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetBroadcasterDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetBroadcasterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetBroadcasterDlg)
	DDX_Control(pDX, IDC_EDIT_SUB_FOLDER, m_editSubFolder);
	DDX_Control(pDX, IDC_EDIT_WEB_SERVER_ROOT_FOLDER, m_editWebServerRootFolder);
	DDX_Control(pDX, IDC_STATIC_FORMAT, m_statFormat);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW, m_statDisplayWindow);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNetBroadcasterDlg, CDialog)
	//{{AFX_MSG_MAP(CNetBroadcasterDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg message handlers

BOOL CNetBroadcasterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_pDevice = NULL;

	m_hNetworkServer = NULL;

	m_nNetworkServerState = 0x00000000;

	m_nVideoWidth = 0;
	
	m_nVideoHeight = 0;
	
	m_bVideoIsInterleaved = FALSE;
	
	m_dVideoFrameRate = 0.0;
	
	m_nAudioChannels = 0; 
	
	m_nAudioBitsPerSample = 0;
	
	m_nAudioSampleFrequency = 0;

	m_editWebServerRootFolder.SetWindowText( theApp.GetProfileString( "DEFAULT", "ROOT.FOLDER", "C:\\AppServ\\www\\" ) );	

	m_editSubFolder.SetWindowText( theApp.GetProfileString( "DEFAULT", "SUB.FOLDER", "hls\\" ) );	

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	UpdateData( FALSE );

	// INITIALIZE DEVICE RESOURCE
	//
	QCAP_CREATE( "FH8735 PCI", 0, m_statDisplayWindow.m_hWnd, &m_pDevice, TRUE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_format_changed_callback, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_no_signal_detected_callback, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_no_signal_removed_callback, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

    QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_pDevice, 0, on_video_hardware_encoder_callback, this );

    QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_pDevice, 1, on_video_hardware_encoder_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_SET_VIDEO_INPUT( m_pDevice, QCAP_INPUT_TYPE_AUTO );

	QCAP_SET_AUDIO_INPUT( m_pDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	QCAP_SET_AUDIO_VOLUME( m_pDevice, 0 );

	QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( m_pDevice, 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_PROFILE_MAIN, QCAP_RECORD_LEVEL_41, QCAP_RECORD_ENTROPY_CABAC, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );

	QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( m_pDevice, 1, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_PROFILE_MAIN, QCAP_RECORD_LEVEL_41, QCAP_RECORD_ENTROPY_CABAC, QCAP_RECORD_MODE_CBR, 8000, 3 * 1024 * 1024, 30, 0, FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ); 

	QCAP_RUN( m_pDevice );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetBroadcasterDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	// UNINITIALIZE DEVICE RESOURCE
	//
	OnButtonStop();

	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}

	// UNINITIALIZE MEMBER VARIABLES
	//
	UpdateData( TRUE );

	CString strWebServerRootFolder;

	CString strSubFolder;

	m_editWebServerRootFolder.GetWindowText( strWebServerRootFolder );

	m_editSubFolder.GetWindowText( strSubFolder );

	theApp.WriteProfileString( "DEFAULT", "ROOT.FOLDER", (LPCTSTR)(strWebServerRootFolder) );

	theApp.WriteProfileString( "DEFAULT", "SUB.FOLDER", (LPCTSTR)(strSubFolder) );

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CNetBroadcasterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetBroadcasterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetBroadcasterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNetBroadcasterDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CNetBroadcasterDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CNetBroadcasterDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	CString strWebServerRootFolder;

	CString strSubFolder;

	m_editWebServerRootFolder.GetWindowText( strWebServerRootFolder );

	m_editSubFolder.GetWindowText( strSubFolder );

	OnButtonStop();

	if( m_nVideoWidth == 0 ) { return ; }

	if( m_nVideoHeight == 0 ) { return ; }

	double fps = m_dVideoFrameRate;

	if( m_bVideoIsInterleaved ) {

		fps /= 2;
	}
	QCAP_CREATE_BROADCAST_HLS_SERVER( 0, 2 /*2 CHANNELS*/, &m_hNetworkServer, (CHAR *)(LPCSTR)(strWebServerRootFolder), (CHAR *)(LPCSTR)(strSubFolder) );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth >> 0, m_nVideoHeight >> 0, fps, QCAP_RECORD_MODE_CBR, 8000, 6000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth >> 1, m_nVideoHeight >> 1, fps, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, 0 );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, 0 );

	QCAP_START_BROADCAST_SERVER( m_hNetworkServer );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );
}

void CNetBroadcasterDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	if ( m_hNetworkServer != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer );

		m_hNetworkServer = NULL;
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );
}
