#ifndef CHANNELWINDOW_H
#define CHANNELWINDOW_H

#include <QWidget>
#include <QtGui>
#include <QtCore>
#include "setupdlg.h"

namespace Ui {
class ChannelWindow;
}

class ChannelWindow : public QWidget
{
    Q_OBJECT

public:
    explicit ChannelWindow(QWidget *parent = 0);
    ~ChannelWindow();

    void mousePressEvent(QMouseEvent *event);

    void mouseMoveEvent(QMouseEvent *event);

    void mouseDoubleClickEvent(QMouseEvent *event);

    void HwInitialize();

    void HwUninitialize();

private:
    Ui::ChannelWindow *ui;

    QPoint dragPosition;

public slots:
    void SetUpDialogSlot_VideoInput();

    void SetUpDialogSlot_AudioInput();

    void SetUpDialogSlot_Snapshot_BMP();

    void SetUpDialogSlot_Snapshot_JPG();

    void SetUpDialogSlot_VideoQuality();

    void SetUpDialogSlot_DEINTERLACE( int flag );

    void SetUpDialogSlot_CLONE( int flag );

    void SetUpDialogSlot_DestroyAP();

    void SetUpDialogSlot_FileRecord();

    void SetUpDialogSlot_ShareRecord();

    void SetUpDialogSlot_DisplayWindow();

public:
    static ChannelWindow*	s_psc510Dlg;

    SetUpDlg        *m_setupdlg;

    PVOID           m_hVideoDevice[ 4 ];

    PVOID			m_hCloneCapDev[ 4 ];

    QString         path;

    ulong           m_nVideoInput[ 4 ];

    ulong           m_nAudioInput[ 4 ];

    ulong           m_nVideoWidth[ 4 ];

    ulong           m_nVideoHeight[ 4 ];

    bool            m_bVideoIsInterleaved[ 4 ];

    double          m_dVideoFrameRate[ 4 ];

    ulong           m_nAudioChannels[ 4 ];

    ulong           m_nAudioBitsPerSample[ 4 ];

    ulong           m_nAudioSampleFrequency[ 4 ];

    BOOL            m_bFullScreen;

    BOOL            m_bIsShareRecord;

    BOOL            m_bShareRecordCH[4];

    ulong           m_nChannelWindow; //0:ch1, 1:ch2, 2:ch3, 3:ch4, 4:split

};

#endif // CHANNELWINDOW_H
