#ifndef CHANNELWINDOW_H
#define CHANNELWINDOW_H

#include <QWidget>
#include <QtGui>
#include <QtCore>
#include "setupdlg.h"

namespace Ui {
class ChannelWindow;
}

class ChannelWindow : public QWidget
{
    Q_OBJECT

public:
    explicit ChannelWindow(QWidget *parent = 0);
    ~ChannelWindow();

    void mousePressEvent(QMouseEvent *event);

    void mouseMoveEvent(QMouseEvent *event);

    void mouseDoubleClickEvent(QMouseEvent *event);

    void HwInitialize();

    void HwUninitialize();

private:
    Ui::ChannelWindow *ui;

    QPoint dragPosition;

public slots:
    void SetUpDialogSlot_VideoInput();

    void SetUpDialogSlot_AudioInput();

    void SetUpDialogSlot_Snapshot_BMP();

    void SetUpDialogSlot_Snapshot_JPG();

    void SetUpDialogSlot_startrecord11();

    void SetUpDialogSlot_stoprecord11();

    void SetUpDialogSlot_startrecord12();

    void SetUpDialogSlot_stoprecord12();

    void SetUpDialogSlot_startrecord13();

    void SetUpDialogSlot_stoprecord13();

    void SetUpDialogSlot_VideoQuality();

    void SetUpDialogSlot_DEINTERLACE( int flag );

    void SetUpDialogSlot_CLONE( int flag );

    void SetUpDialogSlot_DestroyAP();

public:
    SetUpDlg        *m_setupdlg;

    PVOID           m_hVideoDevice;

    PVOID			m_hCloneCapDev;

    QString         str_info;

    QString         path;

    ulong           m_nVideoInput;

    ulong           m_nAudioInput;

    ulong           m_nVideoWidth;

    ulong           m_nVideoHeight;

    bool            m_bVideoIsInterleaved;

    double          m_dVideoFrameRate;

    ulong           m_nAudioChannels;

    ulong           m_nAudioBitsPerSample;

    ulong           m_nAudioSampleFrequency;

    BOOL			m_bSupportGPU1;

    BOOL			m_bSupportGPU2;

    BOOL			m_bSupportGPU3;

    BOOL			m_bMP4_11;

    BOOL			m_bMP4_12;

    BOOL			m_bMP4_13;

    BOOL			m_bFullScreen;

};

#endif // CHANNELWINDOW_H
