#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include "audioinputdlg.h"
#include "ui_audioinputdlg.h"
#include "channelwindow.h"
#include "QCAP.H"

AudioInputDlg::AudioInputDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AudioInputDlg)
{
    ui->setupUi(this);

    this->setMinimumSize(272,237);

    this->setMaximumSize(272,237);

    this->setWindowTitle("AUDIO INPUT");

    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    switch (SC510dlg->m_nAudioInput) {
    case 0:
        ui->radioEMBEDDED_AUDIO->setChecked(true);
        break;
    case 1:
        ui->radioLINE_IN->setChecked(true);
        break;
    case 2:
        ui->radioSOUNDCARD_MIC->setChecked(true);
        break;
    case 3:
        ui->radioSOUNDCARD_LINE_IN->setChecked(true);
        break;
    default:
        break;
    }
}

AudioInputDlg::~AudioInputDlg()
{
    delete ui;
}

void AudioInputDlg::on_buttonBox_accepted()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( SC510dlg->m_hVideoDevice != 0 )
    {
        if( ui->radioEMBEDDED_AUDIO->isChecked() )
        {
            QCAP_SET_AUDIO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO);
        }
        if( ui->radioLINE_IN->isChecked() )
        {
            QCAP_SET_AUDIO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_LINE_IN);
        }
        if( ui->radioSOUNDCARD_MIC->isChecked() )
        {
            QCAP_SET_AUDIO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE);
        }
        if( ui->radioSOUNDCARD_LINE_IN->isChecked() )
        {
            QCAP_SET_AUDIO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN);
        }
    }

    qDebug("set audio input -> accepted");
}

void AudioInputDlg::on_buttonBox_rejected()
{
    qDebug("set audio input -> rejected");
}
