#ifndef CAP_UI_H
#define CAP_UI_H

#ifdef CAP_UI_VB_EXPORT

#define CAP_UI_EXPORT __stdcall

#else 

#define CAP_UI_EXPORT __cdecl

#endif 

#ifdef CAP_UI_EXPORT

#define CAP_UI_API __declspec(dllexport)

#else

#define CAP_UI_API __declspec(dllimport)

#endif

#ifdef __cplusplus

#define EXTERN_C extern "C"

#endif

typedef struct _SETUP_RECORD_PROPERTY_EX
{
	int			nResult;
	ULONG		nEncoderType;
	ULONG		nEncoderFormat;
	ULONG		nRecordProfile;
	ULONG		nRecordLevel;
	ULONG		nRecordEntropy;
	ULONG		nRecordComplexity;
	ULONG		nRecordMode;
	ULONG		nQuality;
	ULONG		nBitRate;
	ULONG		nGOP;
	ULONG		nBFrames;
	BOOL		bIsInterleaved;
	ULONG		nAspectRatioX;
	ULONG		nAspectRatioY;
	ULONG		nCropX;
	ULONG		nCropY;
	ULONG		nCropW;
	ULONG		nCropH;
	ULONG		nDstW;
	ULONG		nDstH;
	CHAR 		pszRecordFilePathName[ MAX_PATH ];
	
	_SETUP_RECORD_PROPERTY_EX()
	{
		nResult						= IDOK;
		nEncoderType				= 2;				// (0)QCAP_ENCODER_TYPE_SOFTWARE(1)QCAP_ENCODER_TYPE_HARDWARE(2)QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK(3)QCAP_ENCODER_TYPE_AMD_STREAM(4)QCAP_ENCODER_TYPE_NVIDIA_CUDA(5)QCAP_ENCODER_TYPE_NVIDIA_NVENC
		nEncoderFormat				= 0;				// (0)QCAP_ENCODER_FORMAT_H264(1)QCAP_ENCODER_FORMAT_MPEG2(2)QCAP_ENCODER_FORMAT_H264_3D
		nRecordProfile				= 0;				// (0)QCAP_RECORD_PROFILE_BASELINE(1)QCAP_RECORD_PROFILE_MAIN(2)QCAP_RECORD_PROFILE_HIGH
		nRecordLevel				= 41;				// (0)QCAP_RECORD_LEVEL_1(41)QCAP_RECORD_LEVEL_41,...(52)QCAP_RECORD_LEVEL_52...
		nRecordEntropy				= 0;				// (0)QCAP_RECORD_ENTROPY_CAVLC(1)QCAP_RECORD_ENTROPY_CABAC
		nRecordComplexity			= 0;				// (0)QCAP_RECORD_COMPLEXITY_0~(6)QCAP_RECORD_COMPLEXITY_6
		nRecordMode					= 1;				// (0)QCAP_RECORD_MODE_VBR(1)QCAP_RECORD_MODE_CBR(2)QCAP_RECORD_MODE_ABR
		nQuality					= 8000;
		nBitRate					= 5000000;
		nGOP						= 30;
		nBFrames					= 0;
		bIsInterleaved				= 0;
		nAspectRatioX				= 0;
		nAspectRatioY				= 0;
		nCropX						= 0;
		nCropY						= 0;
		nCropW						= 0;
		nCropH						= 0;
		nDstW						= 0;
		nDstH						= 0;
		lstrcpy(pszRecordFilePathName, "C:\\DEMO.MP4" );
	}
	
} SETUP_RECORD_PROPERTY_EX;

//
// EXPORT FUNCTION
//
EXTERN_C CAP_UI_API VOID CAP_UI_EXPORT SetRecordEx( SETUP_RECORD_PROPERTY_EX *pScmRecordProtypeEx );
//
//	ChannelWindow2
//
EXTERN_C CAP_UI_API BOOL CAP_UI_EXPORT Create_ChannelWindow2( VOID *&pObj );

EXTERN_C CAP_UI_API BOOL CAP_UI_EXPORT SetCustomDraw_ChannelWindow2( VOID *&pObj, VOID *&pDev, BOOL bNoSignal );

EXTERN_C CAP_UI_API BOOL CAP_UI_EXPORT Destroy_ChannelWindow2( VOID *&pObj );

#endif