// ShowInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "security_demo.h"
#include "ShowInfoDlg.h"
#include "Security_DemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShowInfoDlg dialog


CShowInfoDlg::CShowInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CShowInfoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CShowInfoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT	
}


void CShowInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShowInfoDlg)
	DDX_Control(pDX, IDC_PROGRESS_TIME1, m_progTimeBar1);
	DDX_Control(pDX, IDC_PROGRESS_TIME2, m_progTimeBar2);
	DDX_Control(pDX, IDC_PROGRESS_TIME3, m_progTimeBar3);
	DDX_Control(pDX, IDC_PROGRESS_TIME4, m_progTimeBar4);
	DDX_Control(pDX, IDC_PROGRESS_TIME5, m_progTimeBar5);
	DDX_Control(pDX, IDC_PROGRESS_TIME6, m_progTimeBar6);
	DDX_Control(pDX, IDC_PROGRESS_TIME7, m_progTimeBar7);
	DDX_Control(pDX, IDC_PROGRESS_TIME8, m_progTimeBar8);
	DDX_Control(pDX, IDC_PROGRESS_TIME9, m_progTimeBar9);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH1, m_editFilePath1);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH2, m_editFilePath2);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH3, m_editFilePath3);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH4, m_editFilePath4);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH5, m_editFilePath5);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH6, m_editFilePath6);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH7, m_editFilePath7);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH8, m_editFilePath8);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH9, m_editFilePath9);
	DDX_Control(pDX, IDC_DATETIMEPICKER1, m_timeCtrlSelectedDate);	
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CShowInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CShowInfoDlg)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_WM_ERASEBKGND()
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT, OnButtonSnapshot)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_PLUS, OnButtonSpeedPlus)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_MINUS, OnButtonSpeedMinus)
	//}}AFX_MSG_MAP		
	ON_BN_CLICKED(IDC_BTN_RUN, &CShowInfoDlg::OnBnClickedBtnRun)
	ON_BN_CLICKED(IDC_BTN_PAUSE, &CShowInfoDlg::OnBnClickedBtnPause)
	ON_BN_CLICKED(IDC_BTN_STOP, &CShowInfoDlg::OnBnClickedBtnStop)
	ON_BN_CLICKED(IDC_BTN_ENUM, &CShowInfoDlg::OnBnClickedBtnEnum)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShowInfoDlg message handlers

BOOL CShowInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here	
	
	m_progTimeBar1.m_pParentDlg = this;
	m_progTimeBar1.m_nCH = 0;

	m_progTimeBar2.m_pParentDlg = this;
	m_progTimeBar2.m_nCH = 1;

	m_progTimeBar3.m_pParentDlg = this;
	m_progTimeBar3.m_nCH = 2;

	m_progTimeBar4.m_pParentDlg = this;
	m_progTimeBar4.m_nCH = 3;

	m_progTimeBar5.m_pParentDlg = this;
	m_progTimeBar5.m_nCH = 4;

	m_progTimeBar6.m_pParentDlg = this;
	m_progTimeBar6.m_nCH = 5;

	m_progTimeBar7.m_pParentDlg = this;
	m_progTimeBar7.m_nCH = 6;

	m_progTimeBar8.m_pParentDlg = this;
	m_progTimeBar8.m_nCH = 7;

	m_progTimeBar9.m_pParentDlg = this;
	m_progTimeBar9.m_nCH = 8;

	CenterWindow( GetDesktopWindow() );

	m_editFilePath1.SetWindowText( "" );	
	m_editFilePath2.SetWindowText( "" );	
	m_editFilePath3.SetWindowText( "" );	
	m_editFilePath4.SetWindowText( "" );	
	m_editFilePath5.SetWindowText( "" );	
	m_editFilePath6.SetWindowText( "" );	
	m_editFilePath7.SetWindowText( "" );	
	m_editFilePath8.SetWindowText( "" );	
	m_editFilePath9.SetWindowText( "" );	
	
	m_progTimeBar1.SetRange( 0, 100 );
	m_progTimeBar2.SetRange( 0, 100 );
	m_progTimeBar3.SetRange( 0, 100 );
	m_progTimeBar4.SetRange( 0, 100 );
	m_progTimeBar5.SetRange( 0, 100 );
	m_progTimeBar6.SetRange( 0, 100 );
	m_progTimeBar7.SetRange( 0, 100 );
	m_progTimeBar8.SetRange( 0, 100 );
	m_progTimeBar9.SetRange( 0, 100 );
	
	m_progTimeBar1.SetStep( 1 );
	m_progTimeBar2.SetStep( 1 );
	m_progTimeBar3.SetStep( 1 );
	m_progTimeBar4.SetStep( 1 );
	m_progTimeBar5.SetStep( 1 );
	m_progTimeBar6.SetStep( 1 );
	m_progTimeBar7.SetStep( 1 );
	m_progTimeBar8.SetStep( 1 );
	m_progTimeBar9.SetStep( 1 );

	for (ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		m_dFileTotalDuationTimes[ i ] = 0.0;

		m_nTotalVideoFrames[ i ] = 0;

		m_nTotalAudioFrames[ i ] = 0;

		m_nVideoStartTime[ i ] = 0;

		m_nTotalSection[ i ] = 0;

		m_nCurSection[ i ] = 0;
	}	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CShowInfoDlg::OnClose() 
{
	CDialog::OnClose();

	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

	::SendMessage( pParent->GetSafeHwnd(), WM_CLOSE, 0, 0 );	
}

BOOL CShowInfoDlg::OnEraseBkgnd(CDC* pDC) 
{

	return CDialog::OnEraseBkgnd(pDC);
}

void CShowInfoDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	KillTimer( 0x00000000 );

	KillTimer( 0x00000001 );
}

void CShowInfoDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default	
	
	if( nIDEvent == 0x00000000 ) 
	{
		CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());		

		for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )		
		{
			if( pParent->m_pScfFile[ i ] != NULL ) 
			{
				double dSampleTime = 0;

				QCAP_GET_FILE_POSITION( pParent->m_pScfFile[ i ], &dSampleTime );

				SYSTEMTIME s_system_times;

				ULONGLONG nTime = (ULONGLONG)(dSampleTime * 10000000);

				FileTimeToSystemTime( (FILETIME *)( &( nTime ) ), &s_system_times);

				//if ( dSampleTime > 0 ) { SetPlayPos( i, dSampleTime ); }
			}
		}	
	}
	
	if( nIDEvent == 0x00000001 ) 
	{
		CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());		

		for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )		
		{
			if( pParent->m_pScfFile[ i ] != NULL ) 
			{
				SetPos( i );
			}
		}
	}

	CDialog::OnTimer(nIDEvent);
}

void CShowInfoDlg::SetPlayPos( ULONG nCH, double dSampleTime )
{
	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

	if ( pParent->m_vs_file_info[ nCH ].size() == 0 ) { return; }

	if ( m_nCurSection[ nCH ] < m_nTotalSection[ nCH ] )
	{
		MY_SCF_FILE_INFO  dsFileInfo;

		dsFileInfo = pParent->m_vs_file_info[ nCH ][ m_nCurSection[ nCH ] ];

		m_nVideoStartTime[ nCH ] = (ULONGLONG)(dsFileInfo.dVideoStartTime * 10000000);	

		SYSTEMTIME s_start_system_times, s_cur_system_times;

		FileTimeToSystemTime( (FILETIME *)(&m_nVideoStartTime[ nCH ]), &s_start_system_times);

		ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

		FileTimeToSystemTime( (FILETIME *)(&nSampleTime), &s_cur_system_times);

		CTime timeStart( s_start_system_times );

		CTime timeCur( s_cur_system_times );

		CTimeSpan timeDiff = timeCur - timeStart;

		LONGLONG nTimeDiffSec = timeDiff.GetTotalSeconds();

		int nCurPos = (int)(100.0 * (nTimeDiffSec / m_dFileTotalDuationTimes[ nCH ]));		

		if ( nCurPos < 0 ) { nCurPos = 0; }		

		if ( nCH == 0 ) { m_progTimeBar1.SetPos( nCurPos ); }
		if ( nCH == 1 ) { m_progTimeBar2.SetPos( nCurPos ); }
		if ( nCH == 2 ) { m_progTimeBar3.SetPos( nCurPos ); }
		if ( nCH == 3 ) { m_progTimeBar4.SetPos( nCurPos ); }
		if ( nCH == 4 ) { m_progTimeBar5.SetPos( nCurPos ); }
		if ( nCH == 5 ) { m_progTimeBar6.SetPos( nCurPos ); }
		if ( nCH == 6 ) { m_progTimeBar7.SetPos( nCurPos ); }
		if ( nCH == 7 ) { m_progTimeBar8.SetPos( nCurPos ); }
		if ( nCH == 8 ) { m_progTimeBar9.SetPos( nCurPos ); }

		//CString str; str.Format( "nCurPos : %d\n", nCurPos ); OutputDebugString( str );
	}

	if ( m_nCurSection[ nCH ] >= m_nTotalSection[ nCH ] ) { m_nCurSection[ nCH ] = 0; }	
}

void CShowInfoDlg::SetPos( ULONG nCH )
{
	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

	if ( m_dFileTotalDuationTimes[ nCH ] > 0 )
	{
		int nPos = 0;

		if ( nCH == 0 ) { nPos = m_progTimeBar1.GetPos(); if ( nPos >= (int)m_dFileTotalDuationTimes[ nCH ] ) { return; } m_progTimeBar1.StepIt(); }
		if ( nCH == 1 ) { nPos = m_progTimeBar2.GetPos(); if ( nPos >= (int)m_dFileTotalDuationTimes[ nCH ] ) { return; } m_progTimeBar2.StepIt(); }
		if ( nCH == 2 ) { nPos = m_progTimeBar3.GetPos(); if ( nPos >= (int)m_dFileTotalDuationTimes[ nCH ] ) { return; } m_progTimeBar3.StepIt(); }
		if ( nCH == 3 ) { nPos = m_progTimeBar4.GetPos(); if ( nPos >= (int)m_dFileTotalDuationTimes[ nCH ] ) { return; } m_progTimeBar4.StepIt(); }
		if ( nCH == 4 ) { nPos = m_progTimeBar5.GetPos(); if ( nPos >= (int)m_dFileTotalDuationTimes[ nCH ] ) { return; } m_progTimeBar5.StepIt(); }
		if ( nCH == 5 ) { nPos = m_progTimeBar6.GetPos(); if ( nPos >= (int)m_dFileTotalDuationTimes[ nCH ] ) { return; } m_progTimeBar6.StepIt(); }
		if ( nCH == 6 ) { nPos = m_progTimeBar7.GetPos(); if ( nPos >= (int)m_dFileTotalDuationTimes[ nCH ] ) { return; } m_progTimeBar7.StepIt(); }
		if ( nCH == 7 ) { nPos = m_progTimeBar8.GetPos(); if ( nPos >= (int)m_dFileTotalDuationTimes[ nCH ] ) { return; } m_progTimeBar8.StepIt(); }		
	}
}

void CShowInfoDlg::OnBnClickedBtnRun()
{
	// TODO: Add your control notification handler code here

	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

#ifdef GLOBAL_TIMER	

	QCAP_PLAY_GLOBAL_SCF_FILE();	

#else	

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ ) {

		if ( pParent->m_pScfFile[ i ] != NULL ) { QCAP_PLAY_FILE( pParent->m_pScfFile[ i ] ); }
	}	
#endif

	if ( m_progTimeBar1.GetPos() >= (int)m_dFileTotalDuationTimes[ 0 ] ) { m_progTimeBar1.SetPos(0); }
	if ( m_progTimeBar2.GetPos() >= (int)m_dFileTotalDuationTimes[ 1 ] ) { m_progTimeBar2.SetPos(0); }
	if ( m_progTimeBar3.GetPos() >= (int)m_dFileTotalDuationTimes[ 2 ] ) { m_progTimeBar3.SetPos(0); }
	if ( m_progTimeBar4.GetPos() >= (int)m_dFileTotalDuationTimes[ 3 ] ) { m_progTimeBar4.SetPos(0); }
	if ( m_progTimeBar5.GetPos() >= (int)m_dFileTotalDuationTimes[ 4 ] ) { m_progTimeBar5.SetPos(0); }
	if ( m_progTimeBar6.GetPos() >= (int)m_dFileTotalDuationTimes[ 5 ] ) { m_progTimeBar6.SetPos(0); }
	if ( m_progTimeBar7.GetPos() >= (int)m_dFileTotalDuationTimes[ 6 ] ) { m_progTimeBar7.SetPos(0); }
	if ( m_progTimeBar8.GetPos() >= (int)m_dFileTotalDuationTimes[ 7 ] ) { m_progTimeBar8.SetPos(0); }

	SetTimer( 0x00000000, 1000, NULL );

	SetTimer( 0x00000001, 1000, NULL );
}

void CShowInfoDlg::OnBnClickedBtnPause()
{
	// TODO: Add your control notification handler code here

	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());	

#ifdef GLOBAL_TIMER

	QCAP_PAUSE_GLOBAL_SCF_FILE();
	
#else

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ ) {

		if ( pParent->m_pScfFile[ i ] != NULL ) { QCAP_PAUSE_FILE( pParent->m_pScfFile[ i ] ); }
	}
#endif

	KillTimer( 0x00000000 );

	KillTimer( 0x00000001 );
}

void CShowInfoDlg::OnBnClickedBtnStop()
{
	// TODO: Add your control notification handler code here

	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

#ifdef GLOBAL_TIMER

	QCAP_STOP_GLOBAL_SCF_FILE();
		
#else

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ ) {

		if ( pParent->m_pScfFile[ i ] != NULL ) { QCAP_STOP_FILE( pParent->m_pScfFile[ i ] ); }

		m_nCurSection[ i ] = 0;
	}
#endif

	KillTimer( 0x00000000 );

	KillTimer( 0x00000001 );

	m_progTimeBar1.SetPos(0);
	m_progTimeBar2.SetPos(0);
	m_progTimeBar3.SetPos(0);
	m_progTimeBar4.SetPos(0);
	m_progTimeBar5.SetPos(0);
	m_progTimeBar6.SetPos(0);
	m_progTimeBar7.SetPos(0);
	m_progTimeBar8.SetPos(0);
	m_progTimeBar9.SetPos(0);
}

void CShowInfoDlg::ShowFileInfo( ULONG nCH )
{
	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

	double speed = 0;

	QCAP_GET_FILE_PLAYBACK_SPEED( pParent->m_pScfFile[ nCH ], &speed );	

	CHAR psz_info[ 512 ] = {0};

	CString vfmt;

	CString afmt;

	if ( pParent->m_nRecordCout[ nCH ] > 0 )
	{
		MY_SCF_FILE_INFO  dsFileInfo = {0};

		dsFileInfo = pParent->m_vs_file_info[ nCH ][ m_nCurSection[ nCH ] ];	

		if( dsFileInfo.m_nVideoEncoderFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

		if( dsFileInfo.m_nAudioEncoderFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

		if( dsFileInfo.m_nAudioEncoderFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

		if( dsFileInfo.m_nAudioEncoderFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

		sprintf( psz_info, "%02d\r\nTotal Times = %f sec\r\nTotal Video Frames = %d\r\nTotal Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", nCH,m_dFileTotalDuationTimes[ nCH ], m_nTotalVideoFrames[ nCH ], m_nTotalAudioFrames[ nCH ], vfmt, dsFileInfo.m_nVideoWidth, dsFileInfo.m_nVideoHeight, dsFileInfo.m_dVideoFrameRate, afmt, dsFileInfo.m_nAudioChannels, dsFileInfo.m_nAudioBitsPerSample, dsFileInfo.m_nAudioSampleFrequency, speed );		
	}	

	if ( nCH == 0 ) { m_editFilePath1.SetWindowText( psz_info ); }
	if ( nCH == 1 ) { m_editFilePath2.SetWindowText( psz_info ); }
	if ( nCH == 2 ) { m_editFilePath3.SetWindowText( psz_info ); }
	if ( nCH == 3 ) { m_editFilePath4.SetWindowText( psz_info ); }
	if ( nCH == 4 ) { m_editFilePath5.SetWindowText( psz_info ); }
	if ( nCH == 5 ) { m_editFilePath6.SetWindowText( psz_info ); }
	if ( nCH == 6 ) { m_editFilePath7.SetWindowText( psz_info ); }
	if ( nCH == 7 ) { m_editFilePath8.SetWindowText( psz_info ); }
	if ( nCH == 8 ) { m_editFilePath9.SetWindowText( psz_info ); }		
}

void CShowInfoDlg::OnBnClickedBtnEnum()
{
	// TODO: Add your control notification handler code here

	KillTimer( 0x00000000 );

	KillTimer( 0x00000001 );

	m_progTimeBar1.SetPos(0);
	m_progTimeBar2.SetPos(0);
	m_progTimeBar3.SetPos(0);
	m_progTimeBar4.SetPos(0);
	m_progTimeBar5.SetPos(0);
	m_progTimeBar6.SetPos(0);
	m_progTimeBar7.SetPos(0);
	m_progTimeBar8.SetPos(0);
	m_progTimeBar9.SetPos(0);

	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

	SYSTEMTIME sysGetTime;

	m_timeCtrlSelectedDate.GetTime( &sysGetTime );

	SYSTEMTIME sysStartTime, sysEndTime;

	sysStartTime.wYear			= sysGetTime.wYear;
	sysStartTime.wMonth			= sysGetTime.wMonth;
	sysStartTime.wDay			= sysGetTime.wDay;
	sysStartTime.wHour			= 0;
	sysStartTime.wMinute		= 0;
	sysStartTime.wSecond		= 0;
	sysStartTime.wMilliseconds	= 0;

	sysEndTime.wYear			= sysGetTime.wYear;
	sysEndTime.wMonth			= sysGetTime.wMonth;
	sysEndTime.wDay				= sysGetTime.wDay;
	sysEndTime.wHour			= 23;
	sysEndTime.wMinute			= 59;
	sysEndTime.wSecond			= 59;
	sysEndTime.wMilliseconds	= 999;

	ULONG nRecordCount = 0;

	ULONGLONG nStartPlayTime = 0, nStopPlayTime = 0;

	SystemTimeToFileTime(&sysStartTime, (FILETIME *)&nStartPlayTime);

	SystemTimeToFileTime(&sysEndTime, (FILETIME *)&nStopPlayTime);

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		pParent->GetFileInfoList( i, (double)(nStartPlayTime / 10000000), (double)(nStopPlayTime / 10000000) );
	}

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		pParent->OpenScfFile( i );		
	}

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		ShowFileInfo( i );
	}	
}

void CShowInfoDlg::OnButtonSnapshot() 
{
	// TODO: Add your control notification handler code here

	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

	CHAR psz[ MAX_PATH ];

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		sprintf( psz, "D:\\TEST%02d.BMP", i);

		QCAP_SNAPSHOT_FILE_BMP( pParent->m_pScfFile[ i ], psz  );
	}
}

void CShowInfoDlg::OnButtonSpeedPlus() 
{
	// TODO: Add your control notification handler code here
	
	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		if ( pParent->m_nRecordCout[ i ] > 0 )
		{
			double speed = 0;

			QCAP_GET_FILE_PLAYBACK_SPEED( pParent->m_pScfFile[ i ], &speed );
	
			speed += 0.25;

			QCAP_SET_FILE_PLAYBACK_SPEED( pParent->m_pScfFile[ i ],  speed );

			QCAP_GET_FILE_PLAYBACK_SPEED( pParent->m_pScfFile[ i ], &speed );			
		}
	}	
}

void CShowInfoDlg::OnButtonSpeedMinus() 
{
	// TODO: Add your control notification handler code here
	CSecurity_DemoDlg * pParent = (CSecurity_DemoDlg *)(GetParent());

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		if ( pParent->m_nRecordCout[ i ] > 0 )
		{
			double speed = 0;

			QCAP_GET_FILE_PLAYBACK_SPEED( pParent->m_pScfFile[ i ], &speed );
	
			speed -= 0.25;

			QCAP_SET_FILE_PLAYBACK_SPEED( pParent->m_pScfFile[ i ],  speed );

			QCAP_GET_FILE_PLAYBACK_SPEED( pParent->m_pScfFile[ i ], &speed );			
		}
	}	
}