// AduioInputDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC510.h"
#include "SC510Dlg.h"
#include "AduioInputDlg.h"
#include "afxdialogex.h"


// CAduioInputDlg dialog

IMPLEMENT_DYNAMIC(CAduioInputDlg, CDialog)

CAduioInputDlg::CAduioInputDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAduioInputDlg::IDD, pParent)
{

}

CAduioInputDlg::~CAduioInputDlg()
{
}

void CAduioInputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CAduioInputDlg, CDialog)
	//{{AFX_MSG_MAP(CAduioInputDlg)
	ON_BN_CLICKED(IDC_RADIO_INPUT_EMBEDDED_AUDIO, OnRadioInputEmbeddedAudio)
	ON_BN_CLICKED(IDC_RADIO_INPUT_LINEIN, OnRadioInputLinein)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// CAduioInputDlg message handlers

BOOL CAduioInputDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	ULONG inputs = 0;

	QCAP_GET_AUDIO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], &inputs );

	if ( inputs == 0 ) { CheckDlgButton( IDC_RADIO_INPUT_EMBEDDED_AUDIO, BST_CHECKED ); }

	if ( inputs == 1 ) { CheckDlgButton( IDC_RADIO_INPUT_LINEIN, BST_CHECKED ); }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAduioInputDlg::OnRadioInputEmbeddedAudio() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_AUDIO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000000 );

	CDialog::OnOK();
}

void CAduioInputDlg::OnRadioInputLinein() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_AUDIO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000001 );

	CDialog::OnOK();
}
