#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include <QDebug>
#include <QDesktopWidget>

#include "displaywindow.h"
#include "ui_displaywindow.h"
#include "setupdlg.h"
#include "ui_setupdlg.h"

#include "QCAP.H"

DisplayWindow*	m_pDisplayWindow = NULL;

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    qDebug("signal removed \n");

    if( i == 0 )
    {
        m_pDisplayWindow->m_setupdlg->ui->m_ch1Info->setText(QString("info...(signal removed)"));
    }
    else
    {
        m_pDisplayWindow->m_setupdlg->ui->m_ch2Info->setText(QString("info...(signal removed)"));
    }

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    qDebug("no signal Detected  \n");

    if( i == 0 )
    {
        m_pDisplayWindow->m_setupdlg->ui->m_ch1Info->setText(QString("info...(no signal detected)"));
    }
    else
    {
        m_pDisplayWindow->m_setupdlg->ui->m_ch2Info->setText(QString("info...(no signal detected)"));
    }

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    qDebug("format changed Detected  \n");

    CHAR strVideoInput[ MAX_PATH ] = { 0 };

    CHAR strAudioInput[ MAX_PATH ] = { 0 };

    CHAR strFrameType[ MAX_PATH ] = { 0 };

    m_pDisplayWindow->m_nVideoWidth[ i ] = nVideoWidth;

    m_pDisplayWindow->m_nVideoHeight[ i ] = nVideoHeight;

    m_pDisplayWindow->m_bVideoIsInterleaved[ i ] = bVideoIsInterleaved;

    m_pDisplayWindow->m_dVideoFrameRate[ i ] = dVideoFrameRate;

    m_pDisplayWindow->m_nAudioChannels[ i ] = nAudioChannels;

    m_pDisplayWindow->m_nAudioBitsPerSample[ i ] = nAudioBitsPerSample;

    m_pDisplayWindow->m_nAudioSampleFrequency[ i ] = nAudioSampleFrequency;

    UINT nVH = 0;

    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    QString str_info;

    str_info.sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s"

                                                            , nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample

                                                            , nAudioSampleFrequency, strVideoInput, strAudioInput);

    if( i == 0 )
    {
        m_pDisplayWindow->m_setupdlg->ui->m_ch1Info->setText(str_info);
    }
    else
    {
        m_pDisplayWindow->m_setupdlg->ui->m_ch2Info->setText(str_info);
    }

    return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (ULONG)(pUserData);

    UINT   iFrameNum = 0;

    BYTE * pClipFrameBuffer = NULL;

    ULONG  nClipFrameBufferLen = 0;

    EnterCriticalSection( &m_pDisplayWindow->m_hShareRecordAccessCriticalSection_video );

    if( m_pDisplayWindow->m_nShareRecordState_video > 0x00000000 )
    {
        if( i == 0 ) {

            QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( m_pDisplayWindow->m_pClips[i], 1, QCAP_COLORSPACE_TYEP_YUY2, m_pDisplayWindow->m_nVideoWidth[i], m_pDisplayWindow->m_nVideoHeight[ i ], pFrameBuffer, nFrameBufferLen);

            //QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX( m_pDisplayWindow->m_pClips[i], 1, QCAP_COLORSPACE_TYEP_YUY2, m_pDisplayWindow->m_nVideoWidth[i], m_pDisplayWindow->m_nVideoHeight[ i ], pFrameBuffer, nFrameBufferLen, 0 + m_pDisplayWindow->m_nShiftCh1, 0, (m_pDisplayWindow->m_nVideoWidth[i])-(m_pDisplayWindow->m_nShiftCh1), m_pDisplayWindow->m_nVideoHeight[ i ]);

            QCAP_STEP_ANIMATION_CLIP( m_pDisplayWindow->m_pClips[i], &iFrameNum, &pClipFrameBuffer, &nClipFrameBufferLen );

            QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2, m_pDisplayWindow->m_nVideoWidth[ i ], m_pDisplayWindow->m_nVideoHeight[ i ], pClipFrameBuffer, nClipFrameBufferLen);
        }
        if( i == 1 ) {

            //QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( m_pDisplayWindow->m_pClips[i], 1, QCAP_COLORSPACE_TYEP_YUY2, m_pDisplayWindow->m_nVideoWidth[i], m_pDisplayWindow->m_nVideoHeight[ i ], pFrameBuffer, nFrameBufferLen);

            QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX( m_pDisplayWindow->m_pClips[i], 1, QCAP_COLORSPACE_TYEP_YUY2, m_pDisplayWindow->m_nVideoWidth[i], m_pDisplayWindow->m_nVideoHeight[ i ], pFrameBuffer, nFrameBufferLen, 0 + m_pDisplayWindow->m_nShiftCh2, 0, (m_pDisplayWindow->m_nVideoWidth[i])-(m_pDisplayWindow->m_nShiftCh2), m_pDisplayWindow->m_nVideoHeight[ i ]);

            QCAP_STEP_ANIMATION_CLIP( m_pDisplayWindow->m_pClips[i], &iFrameNum, &pClipFrameBuffer, &nClipFrameBufferLen );

            QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2, m_pDisplayWindow->m_nVideoWidth[ i ], m_pDisplayWindow->m_nVideoHeight[ i ], pClipFrameBuffer, nClipFrameBufferLen);
        }
        if( i == 0 ) {

            QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0 );//ch1 even
        }
    }

    LeaveCriticalSection( &m_pDisplayWindow->m_hShareRecordAccessCriticalSection_video );

    return QCAP_RT_OK;
}

QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (ULONG)(pUserData);

    if( i == 0 && pFrameBuffer )
    {
        EnterCriticalSection( &m_pDisplayWindow->m_hShareRecordAccessCriticalSection_audio );

        if( m_pDisplayWindow->m_nShareRecordState_audio > 0x00000000 )
        {
            QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
        }

        LeaveCriticalSection( &m_pDisplayWindow->m_hShareRecordAccessCriticalSection_audio );
    }

    return QCAP_RT_OK;
}

DisplayWindow::DisplayWindow(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::DisplayWindow)
{
    ui->setupUi(this);

    m_pDisplayWindow = this;

    this->setWindowFlags(Qt::FramelessWindowHint);

    this->resize(960,540);

    ui->m_DisplayWindow->move(0,0);

    ui->m_DisplayWindow->resize(960,540);

    ui->m_DisplayWindow->setLineWidth(0);

    CoInitialize( NULL );

    //CONNET SIGNAL & SLOT
    m_setupdlg = new SetUpDlg(this);

    m_setupdlg->show();

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_DestroyAP()), this, SLOT(SetUpDialogSlot_DestroyAP()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_Ch1Shift(int)), this, SLOT(SetUpDialogSlot_Ch1Shift(int)));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_Ch2Shift(int)), this, SLOT(SetUpDialogSlot_Ch2Shift(int)));

    //INITIALIZE MEMBER VARIABLES
    for(ULONG i = 0 ; i < 2 ; i++)
    {
        m_hVideoDevice[ i ] = NULL;

        m_nVideoWidth[ i ] = 0;

        m_nVideoHeight[ i ] = 0;

        m_bVideoIsInterleaved[ i ] = 0;

        m_dVideoFrameRate[ i ] = 0;

        m_nAudioChannels[ i ] = 0;

        m_nAudioBitsPerSample[ i ] = 0;

        m_nAudioSampleFrequency[ i ] = 0;

        m_pClips[i] = NULL;

        m_nClipFrames[i] = 0;

        m_nClipSprites[i] = 0;

        m_nClipColorSpaceTypes[i] = 0;

        m_nClipWidths[i] = 0;

        m_nClipHeights[i] = 0;
    }

    m_nShiftCh1 = 0;

    m_nShiftCh2 = 0;

    m_bFullScreen = FALSE;

    m_nShareRecordState_audio = 0x00000000;

    m_nShareRecordState_video = 0x00000000;

    InitializeCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

    InitializeCriticalSection( &m_hShareRecordAccessCriticalSection_video );

    HwInitialize();
}

DisplayWindow::~DisplayWindow()
{
    delete ui;
}

void DisplayWindow::HwInitialize()
{
    //CREATE CAPTURE DEVICE

    QCAP_CREATE( "SA7160 PCI", 0, (HWND)m_setupdlg->ui->m_ch1window->winId(), &m_hVideoDevice[ 0 ], TRUE);

    QCAP_CREATE( "SA7160 PCI", 1, (HWND)m_setupdlg->ui->m_ch2window->winId(), &m_hVideoDevice[ 1 ], TRUE);

    for( ULONG i = 0 ; i < 2 ; i++)
    {
        QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], on_process_no_signal_detected, (PVOID)i );

        QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], on_process_signal_removed, (PVOID)i );

        QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], on_process_format_changed, (PVOID)i );

        QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_video_preview_callback, (PVOID)i );

        QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_process_preview_audio_buffer, (PVOID)i );

        QCAP_SET_VIDEO_INPUT( m_hVideoDevice[ i ], QCAP_INPUT_TYPE_AUTO );

        QCAP_SET_AUDIO_INPUT( m_hVideoDevice[ i ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

        QCAP_RUN( m_hVideoDevice[ i ] );
    }

    //clip

    for(ULONG i = 0 ; i < 2 ; i++ )
    {
        QCAP_CREATE_ANIMATION_CLIP( "EXAMPLE.XML", &m_pClips[i], &m_nClipFrames[i], &m_nClipSprites[i], &m_nClipColorSpaceTypes[i], &m_nClipWidths[i], &m_nClipHeights[i] );

        QCAP_START_ANIMATION_CLIP( m_pClips[i] );
    }

    //SHARE RECORD 3D

    Sleep(100);

    if( m_hVideoDevice[0] && m_hVideoDevice[1] )
    {
        QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264_3D, QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth[ 0 ], m_nVideoHeight[ 0 ], m_dVideoFrameRate[ 0 ], QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, (HWND)ui->m_DisplayWindow->winId(), TRUE, FALSE);

        //QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264_3D, QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth[ 0 ], m_nVideoHeight[ 0 ], m_dVideoFrameRate[ 0 ], QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, NULL, TRUE, FALSE);

        QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels[ 0 ], m_nAudioBitsPerSample[ 0 ], m_nAudioSampleFrequency[ 0 ], 100 );

        //QCAP_START_SHARE_RECORD( 0, "3D.TS", QCAP_RECORD_FLAG_ENCODE | QCAP_RECORD_FLAG_FILE );

        QCAP_START_SHARE_RECORD( 0, "", QCAP_RECORD_FLAG_DISPLAY );

        EnterCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

        m_nShareRecordState_audio = 0x00000001;

        LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

        EnterCriticalSection( &m_hShareRecordAccessCriticalSection_video );

        m_nShareRecordState_video = 0x00000001;

        LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_video );
    }
}

void DisplayWindow::HwUninitialize()
{
    //CREATE CAPTURE DEVICE

    EnterCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

    m_nShareRecordState_audio = 0x00000000;

    LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

    EnterCriticalSection( &m_hShareRecordAccessCriticalSection_video );

    m_nShareRecordState_video = 0x00000000;

    LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_video );

    QCAP_STOP_SHARE_RECORD( 0 );

    for(ULONG i = 0 ; i < 2 ; i++ )
    {
        if( m_pClips[i] )
        {
            QCAP_STOP_ANIMATION_CLIP( m_pClips[i]  );

            QCAP_DESTROY_ANIMATION_CLIP( m_pClips[i]  );
        }
    }

    for( ULONG i = 0 ; i < 2 ; i++ )
    {
        if( m_hVideoDevice[ i ] ) {

            QCAP_STOP( m_hVideoDevice[ i ] );

            QCAP_DESTROY( m_hVideoDevice[ i ] );

            m_hVideoDevice[ i ] = NULL;
        }
    }

    DeleteCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

    DeleteCriticalSection( &m_hShareRecordAccessCriticalSection_video );

    CoUninitialize();
}

void DisplayWindow::mouseMoveEvent(QMouseEvent *event)
{
    if(event->buttons()&Qt::LeftButton)
    {
        move(event->globalPos()- dragPosition);

        event->accept();
    }
}

void DisplayWindow::mousePressEvent(QMouseEvent *event)
{
    if(event->button()==Qt::LeftButton)
    {
        dragPosition=event->globalPos()-frameGeometry().topLeft();

        event->accept();
    }
}

void DisplayWindow::SetUpDialogSlot_DestroyAP()
{
    HwUninitialize();

    exit(0);
}

void DisplayWindow::SetUpDialogSlot_Ch1Shift( int value )
{
    EnterCriticalSection( &m_hShareRecordAccessCriticalSection_video );

    //m_nShiftCh1 = value;

    QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( m_pClips[0],1,0, value, 0, 1920, 1080);

    //QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( m_pClips[0],1,0, 0, 0, 1920-value, 1080);

    LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_video );
}

void DisplayWindow::SetUpDialogSlot_Ch2Shift( int value )
{
    EnterCriticalSection( &m_hShareRecordAccessCriticalSection_video );

    m_nShiftCh2 = value;

    //QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( m_pClips[1],1,0, value, 0, 1920, 1080);

    QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( m_pClips[1],1,0, 0, 0, 1920-value, 1080);

    LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_video );
}

void DisplayWindow::mouseDoubleClickEvent( QMouseEvent * event )
{
    if( event->button()==Qt::LeftButton )
    {
        QDesktopWidget *desktop = QApplication::desktop();

        QRect screen = desktop->screenGeometry();

        if( m_bFullScreen == FALSE)
        {
            this->move(0,0);

            this->resize(screen.width(),screen.height());

            ui->m_DisplayWindow->resize(screen.width(),screen.height());

            m_bFullScreen = TRUE;
        }
        else
        {
            this->move((screen.width()-960)/2,(screen.height()-540)/2);

            this->resize(960,540);

            ui->m_DisplayWindow->resize(960,540);

            m_bFullScreen = FALSE;
        }

        event->accept();
    }
}
