// AnalogDeviceVideoEncoderGraph.h: interface for the CAnalogDeviceVideoEncoderGraph class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANALOGDEVICEVIDEOENCODERGRAPH_H__BE58B199_2761_45CF_8CCA_DA138F018291__INCLUDED_)
#define AFX_ANALOGDEVICEVIDEOENCODERGRAPH_H__BE58B199_2761_45CF_8CCA_DA138F018291__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Graph.h"

class CAnalogDeviceVideoEncoderGraph  : public CGraph  
{
public:

	CAnalogDeviceVideoEncoderGraph();

	virtual ~CAnalogDeviceVideoEncoderGraph();

public:

	// DEBUGGING FUNCTIONS
	//
	VOID					  SC_DEBUG( CHAR * fmt, ... );

	// MEMBER FUNCTIONS
	//
	BOOL					  Close( BOOL bDumpDebugMessage = TRUE );

	BOOL					  Create( PWSTR pwszDevName, UINT iDevNum, PF_BUFFER_CALLBACK pBufferCB, PVOID pUserData );

	BOOL					  GetFormat( ULONG * pColorSpaceType, ULONG * pWidth, ULONG * pHeight, ULONG * pBitCount, double * pFrameRate );

	BOOL					  SetFormat( ULONG nColorSpaceType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, double dFrameRate );

	BOOL					  GetStandard( ULONG * pStandard );

	BOOL					  SetStandard( ULONG nStandard );

	BOOL					  GetLock( ULONG * pLock );

	BOOL					  GetVideoCompressionProperty( ULONG nProperty, ULONG * pValue );

	BOOL					  SetVideoCompressionProperty( ULONG nProperty, ULONG nValue );

	BOOL					  GetCustomPropertyEx( ULONG nProperty, BYTE * pValue, ULONG nBytes );

	BOOL					  SetCustomPropertyEx( ULONG nProperty, BYTE * pValue, ULONG nBytes );

	BOOL					  GetCustomProperty( ULONG nProperty, ULONG * pValue );
	
	BOOL					  SetCustomProperty( ULONG nProperty, ULONG nValue );

	// MEMBER VARIABLES
	// 
	IBaseFilter *             m_pCaptureSourceBaseFilter;

	IBaseFilter *             m_pSampleGrabberBaseFilter;

	IKsPropertySet *          m_pKsPropertySet;

	GUID					  m_sKsPropertySetGUID;

	IAMAnalogVideoDecoder *   m_pAMAnalogVideoDecoder;

	IAMStreamConfig *		  m_pAMStreamConfig;

	IAMVideoCompression *     m_pAMVideoCompression;

	CSampleGrabber			  m_oSampleGrabber;
	
	ISampleGrabber * 		  m_pSampleGrabber;

	ULONG					  m_nColorSpaceType;

	ULONG					  m_nWidth;

	ULONG					  m_nHeight;

	ULONG					  m_nBitCount;

	double					  m_dFrameRate;
};

#endif // !defined(AFX_ANALOGDEVICEVIDEOENCODERGRAPH_H__BE58B199_2761_45CF_8CCA_DA138F018291__INCLUDED_)
