// SC580Dlg.h : header file
//

#if !defined(AFX_SC580DLG_H__48E38544_EDE8_4F29_9E96_2738B971FA59__INCLUDED_)
#define AFX_SC580DLG_H__48E38544_EDE8_4F29_9E96_2738B971FA59__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CSC580Dlg dialog

#include "ChannelWindow.h"

#include "SetupDialog.h"

#include "TabCtrlEx.h"

class CSC580Dlg : public CDialog
{
// Construction
public:
	CSC580Dlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSC580Dlg)
	enum { IDD = IDD_SC580_DIALOG };
	CTabCtrlEx	m_tabDisplayExchange;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSC580Dlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSC580Dlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnDestroy();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSelChangeTabDisplay(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	// USER INTERFACE FUNCTION [2009.07.20] [HUENGPEI@YUAN.COM.TW]
	//
	BOOL				OnLButtonDown_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point );

	BOOL				OnLButtonUp_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point );

	BOOL				OnApply_SetupDialog();

	BOOL				OnSnapshot_SetupDialog();

	BOOL				OnSync_SetupDialog();

	BOOL				OnFileSourceDestroy_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceCreate_FileManagerWindow( ULONG nChannelNumber, AMESDK_FILE_INFO * pFileInfo );

	BOOL				OnFileSourceRun_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourcePause_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceStop_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceStep_FileManagerWindow( ULONG nChannelNumber, ULONG nSteps );

	BOOL				OnFileSourceGetVideoStreamBuffer_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, BYTE * pStreamBuffer, ULONG * pStreamBufferSize );

	BOOL				OnFileSourceGetAudioStreamBuffer_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, BYTE * pStreamBuffer, ULONG * pStreamBufferSize );

	BOOL				OnFileSourceGetVideoStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp, BOOL * pIsKeyFrame );

	BOOL				OnFileSourceGetAudioStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp );
	
	LONGLONG			OnFileSourceGetMediaLength_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits );

	LONGLONG			OnFileSourceGetMediaPosition_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits );

	BOOL				OnFileSourceSetMediaPosition_FileManagerWindow( ULONG nChannelNumber, LONGLONG nPosition, DWORD dwTimeUnits );

	double				OnFileSourceGetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceSetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber, double dRate );

	// DEVICE FUNCTION [2009.07.20] [HUENGPEI@YUAN.COM.TW]
	// 
	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	// USER INTERFACE PROPERTY [2009.07.20] [HUENGPEI@YUAN.COM.TW]
	// 
	CChannelWindow		m_oChannelWindow_LIVE[ 4 ];						//  LIVE STREAM DISPLAY WINDOW

	CChannelWindow		m_oChannelWindow_FILE[ 4 ];						//  FILE STREAM DISPLAY WINDOW (RECORD PLAYBACK)

	CChannelWindow		m_oChannelWindow_H264_MAIN[ 4 ];				//  H.264 MAIN.STREAM DISPLAY WINDOW (REALTIME PLAYBACK)

	CChannelWindow		m_oChannelWindow_H264_SUB[ 4 ];					//  H.264 SUB.STREAM DISPLAY WINDOW (REALTIME PLAYBACK)

	CSetupDialog		m_oSetupDialog;									//  PARAMETER SETUP DIALOG

	ULONG				m_nDisplayModeNumber;							//  DISPLAY MODE EXCHANGE (0 = LIVE / 1 = RCPB / 2 = RTPB / 3 = RTPB)

	// DEVICE PROPERTY [2009.07.20] [HUENGPEI@YUAN.COM.TW]
	// 
	DEVICE_HANDLE		m_hVideoDev[ 4 ];								// VIDEO STREAM CAPTURE DEVICE

	DEVICE_HANDLE		m_hVideoMainEncoderDev[ 4 ];					// H.264 MAIN.STREAM CAPTURE DEVICE

	DEVICE_HANDLE		m_hVideoSubEncoderDev[ 4 ];						// H.264 SUB.STREAM CAPTURE DEVICE

	DEVICE_HANDLE		m_hAudioDev[ 4 ];								// AUDIO STREAM CAPTURE DEVICE 

	DEVICE_HANDLE		m_hAudioAACEncoderDev[ 4 ];						// AUDIO AAC SOFTWARE ENCODER DEVICE 

	// FILE PROPERTY [2009.07.20] [HUENGPEI@YUAN.COM.TW]
	// 
	DEVICE_HANDLE		m_hFileRendererDev[ 4 ];						// FILE RENDERER DEVICE

	ULONG				m_nFileRendererRecordState[ 4 ];				// FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	DEVICE_HANDLE		m_hFileSourceDev[ 4 ];							// FILE SOURCE DEVICE

	// NETWORK PROPERTY [2009.07.20] [HUENGPEI@YUAN.COM.TW]
	// 
	DEVICE_HANDLE		m_hNetworkRendererDev;							// NETWORK RENDERER DEVICE

	ULONG				m_nNetworkRendererStreamingState[ 4 ];			// NETWORK RENDERER STREAMING STATE (0 = STOP / 1 = ACQUIRE / 2 = START)
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SC580DLG_H__48E38544_EDE8_4F29_9E96_2738B971FA59__INCLUDED_)
