// MySwEncodeAV.h: interface for the MySwEncodeAV class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYENCODEAV_H__DFA2FA49_FBBD_4A31_BBF0_77B1A92040B5__INCLUDED_)
#define AFX_MYENCODEAV_H__DFA2FA49_FBBD_4A31_BBF0_77B1A92040B5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MyAV.h"

class MyRecordAV;

class MySwEncodeAV : public MyAV  
{

public:

	MySwEncodeAV();

	virtual ~MySwEncodeAV();

	virtual BOOL IsConnected() { return m_bConnect; }

	virtual BOOL Connect();

	virtual BOOL Disconnect();	

	void SetChannelID( UINT nChannelID ) { m_nChannelID = nChannelID; }

	UINT GetChannelID() { return m_nChannelID; }

	void SetRecordAV( MyRecordAV * pRecordAV ) { m_pRecordAV = pRecordAV; }

	MyRecordAV * GetRecordAV() { return m_pRecordAV; }

	BOOL SetEncodeVideoFormat( ULONG nColorSpaceType, ULONG nCameraType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, DOUBLE dFrameRate);

	BOOL SetEncodeCBR( ULONG iBitRateKB, ULONG iQPStep, ULONG iGOP );

	BOOL SetEncodeVBR( ULONG iQuality, ULONG iGOP );

	BOOL SetEncodeHBR( ULONG iQuality, ULONG iBitRateKB, ULONG iQPStep, ULONG iGOP, ULONG iThroughQuality, ULONG iPeakBitRate );

	BOOL SetEncodeRun();	

	BOOL SetEncodeStop();

	BOOL SetEncodePause();	

public:

	DEVICE_HANDLE	    m_hVideoEncoderDev;						// H.264 STREAM CAPTURE DEVICE

	ULONG				m_nColorSpaceType;

	ULONG				m_nFrameWidth;
	
	ULONG				m_nFrameHeight;

	BOOL				m_bUseIntel;

private:

	MyRecordAV		  * m_pRecordAV;

	UINT				m_nChannelID;

	ULONG				m_nCameraType;

	ULONG				m_nBitCount;

	DOUBLE				m_dFrameRate;

	ULONG				m_nRecordMode;

	ULONG				m_nQuality_VBR;

	ULONG				m_nBitRateKB_CBR;

	ULONG				m_nQPStep_CBR;

	ULONG				m_nQuality_HBR;

	ULONG				m_nBitRateKB_HBR;

	ULONG				m_nQPStep_HBR;	

	ULONG				m_nThroughQualityHBR;

	ULONG				m_nPeakBitRateHBR;

	ULONG				m_nGOP;
};

#endif // !defined(AFX_MYSWENCODEAV_H__DFA2FA49_FBBD_4A31_BBF0_77B1A92040B5__INCLUDED_)
