// MyLiveAV.h: interface for the MyLiveAV class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYLIVEAV_H__F3270E5E_3368_41F5_9A5E_1E86D0DAE260__INCLUDED_)
#define AFX_MYLIVEAV_H__F3270E5E_3368_41F5_9A5E_1E86D0DAE260__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MyAV.h"

#include "MySwEncodeAV.h"

#include "MyHwEncodeAV.h"

#include "MyRecordAV.h"

class MyLiveAV : public MyAV  
{

public:

	MyLiveAV();

	virtual ~MyLiveAV();

	virtual BOOL IsConnected() { return m_bConnect; }
	
	virtual BOOL Connect();	

	virtual BOOL Disconnect();

	void SetChipName(CString strChipName) { m_strChipName = strChipName; }

	void SetChannelID( UINT nChannelID ) { m_nChannelID = nChannelID; }

	UINT GetChannelID() { return m_nChannelID; }

	void SetSwEncodeAV( MySwEncodeAV * pMySwEncodeAV ) { m_pMySwEncodeAV = pMySwEncodeAV; }

	MySwEncodeAV * GetSwEncodeAV() { return m_pMySwEncodeAV; }

	void SetHwEncodeAV( MyHwEncodeAV * pMyHwEncodeAV ) { m_pMyHwEncodeAV = pMyHwEncodeAV; }

	MyHwEncodeAV * GetHwEncodeAV() { return m_pMyHwEncodeAV; }

	void SetRecordAV( MyRecordAV * pMyRecordAV ) { m_pRecordAV = pMyRecordAV; }

	MyRecordAV * GetRecordAV() { return m_pRecordAV; }

	void SetPreviewHwnd( HWND hWnd ) { m_hWnd = hWnd; }

	// CVRSDK : SET CHANNEL WINDOW POINTER
	//
	void SetCustomChannelWindow( PVOID pCustomChannelWindow ) { m_pCustomChannelWindow = pCustomChannelWindow; }	

	BOOL SetVideoStandard(ULONG nStandard);

	BOOL SetVideoInput(ULONG nInput);

	BOOL SetVideoFormat(ULONG nColorSpaceType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, DOUBLE dFrameRate);	

	BOOL GetVideoFormat(ULONG * pnColorSpaceType, ULONG * pnWidth, ULONG * pnHeight, ULONG * pnBitCount, DOUBLE * pdFrameRate);

	BOOL SetDIDeinterlace( BYTE * pFrameBuffer, ULONG nFrameBufferSize );

	BOOL SetVideoDeinterlace(ULONG nDeinterlace, ULONG nSubChannelNumber = 0);

	BOOL SetVideoProperty(ULONG nProperty, ULONG nValue, ULONG nSubChannelNumber = 0);

	BOOL SetCustomProperty(ULONG nProperty, ULONG nValue);

	BOOL LiveRun();

	BOOL LiveStop();

	BOOL RefreshDisplay();	

	BOOL SnapshotBMP(CHAR *pszFilePathName);

	BOOL SnapshotJPG(CHAR *pszFilePathName, ULONG nQuality);

public:

	CString			m_strChipName;

	ULONG			m_nDropFrame;

	ULONG			m_nWidth;
	
	ULONG			m_nHeight;

	double		   m_dLiveFrameRate;

	PVOID			m_pCustomChannelWindow;	  // CVRSDK : CHANNEL WINDOW POINTER	

private:	

	MySwEncodeAV  * m_pMySwEncodeAV;

	MyHwEncodeAV  * m_pMyHwEncodeAV;

	MyRecordAV    * m_pRecordAV;

	UINT			m_nChannelID;

	DEVICE_HANDLE	m_hVideoDev;

	DEVICE_HANDLE   m_hAudioDev;

	DEVICE_HANDLE  m_hDeinterlaceVideoDev;

	HWND			m_hWnd;

};

#endif // !defined(AFX_MYLIVEAV_H__F3270E5E_3368_41F5_9A5E_1E86D0DAE260__INCLUDED_)
