// MyHwEncodeAV.cpp: implementation of the MyHwEncodeAV class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MyHwEncodeAV.h"
#include "MyRecordAV.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern BOOL g_bSaveAVIFile;

extern ULONG g_nRecVideoFrameNumber[ 32 ];

// CALLBACK FUNCTION
//
BOOL on_video_compress_frame_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = nChannelNumber - 1;

	MyHwEncodeAV * pEncodeAV = (MyHwEncodeAV *)(pUserData);

	if ( pEncodeAV != NULL && pEncodeAV->GetChannelID() == nChannelNumber )
	{
		// RECORDING VIDEO
		//
		MyRecordAV * pRecordAV = pEncodeAV->GetRecordAV();

		if ( pRecordAV != NULL )
		{
			DEVICE_HANDLE hFileDev = pRecordAV->m_hFileRendererDev;
		
			BOOL bIsRecord = (pRecordAV->m_nFileRendererRecordState == 0x00000002) ? TRUE : FALSE;		
		  
			if( bIsKeyFrame )
			{
				// WAITING KEY FRAME
				//
				if( pRecordAV->m_nFileRendererRecordState == 0x00000001 ) 
				{
					pRecordAV->m_nFileRendererRecordState = 0x00000002; // TO GOTO START STATE

					bIsRecord = TRUE;
				}
			}			

			DEVICE_HANDLE hFileDev2 = pRecordAV->m_hFileRendererDev;		
			
			if( bIsRecord && ( hFileDev2 != 0xFFFFFFFF ) )
			{
				g_nRecVideoFrameNumber[ i ] += 1;

				// SAVE DATA
				//
				if ( g_bSaveAVIFile )
				{
					AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( hFileDev2, pBuffer, nBufferLen, bIsKeyFrame );
				}
			}				
		}
	}

	return FALSE;
}

BOOL on_video_compress_frame_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 1, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 2, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 3, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 4, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 5, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 6, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 7, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 8, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_video_compress_frame_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer(  9, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 10, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 11, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 12, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 13, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 14, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 15, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 16, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_video_compress_frame_buffer_CH17( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 17, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH18( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 18, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH19( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 19, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH20( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 20, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH21( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 21, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH22( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 22, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH23( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 23, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH24( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 24, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_video_compress_frame_buffer_CH25( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 25, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH26( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 26, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH27( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 27, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH28( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 28, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH29( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 29, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH30( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 30, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH31( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 31, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_video_compress_frame_buffer_CH32( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_video_compress_frame_buffer( 32, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

PF_BUFFER_CALLBACK g_on_video_compress_callback[ 32 ] = 
{  
	on_video_compress_frame_buffer_CH01, 
	on_video_compress_frame_buffer_CH02, 
	on_video_compress_frame_buffer_CH03, 
	on_video_compress_frame_buffer_CH04, 
	on_video_compress_frame_buffer_CH05, 
	on_video_compress_frame_buffer_CH06, 
	on_video_compress_frame_buffer_CH07, 
	on_video_compress_frame_buffer_CH08,
	on_video_compress_frame_buffer_CH09, 
	on_video_compress_frame_buffer_CH10, 
	on_video_compress_frame_buffer_CH11, 
	on_video_compress_frame_buffer_CH12, 
	on_video_compress_frame_buffer_CH13, 
	on_video_compress_frame_buffer_CH14, 
	on_video_compress_frame_buffer_CH15, 
	on_video_compress_frame_buffer_CH16,
	on_video_compress_frame_buffer_CH17, 
	on_video_compress_frame_buffer_CH18, 
	on_video_compress_frame_buffer_CH19, 
	on_video_compress_frame_buffer_CH20, 
	on_video_compress_frame_buffer_CH21, 
	on_video_compress_frame_buffer_CH22, 
	on_video_compress_frame_buffer_CH23, 
	on_video_compress_frame_buffer_CH24,
	on_video_compress_frame_buffer_CH25, 
	on_video_compress_frame_buffer_CH26, 
	on_video_compress_frame_buffer_CH27, 
	on_video_compress_frame_buffer_CH28, 
	on_video_compress_frame_buffer_CH29, 
	on_video_compress_frame_buffer_CH30, 
	on_video_compress_frame_buffer_CH31, 
	on_video_compress_frame_buffer_CH32
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MyHwEncodeAV::MyHwEncodeAV()
{
	m_hVideoEncoderDev				= 0xFFFFFFFF;

	m_pRecordAV						= NULL;

	m_nChannelID					= 0;	

	m_nFrameWidth					= 352;

	m_nFrameHeight					= 240;

	m_nCameraType					= 0x00000001;

	m_nColorSpaceType				= MAKEFOURCC('H', '2', '6', '4');

	m_nBitCount						= 16;

	m_dFrameRate					= 29.97;

	m_nRecordMode					= 0;

	m_nQuality_VBR					= 6000;

	m_nQuality_HBR					= 6000;

	m_nBitRateKB_CBR				= 4194304;

	m_nBitRateKB_HBR				= 4194304;

	m_nQPStep_CBR					= 1;

	m_nQPStep_HBR					= 1;

	m_nThroughQualityHBR			= 5000;

	m_nPeakBitRateHBR				= 6291456;

	m_nGOP							= 30;
}

MyHwEncodeAV::~MyHwEncodeAV()
{
	Disconnect();
}

BOOL MyHwEncodeAV::Connect()
{
	if (IsConnected() == TRUE) { return TRUE; }		

	USES_CONVERSION;

	m_hVideoEncoderDev = 0xFFFFFFFF;

	if ( m_strChipName == "AH8400 PCI" || m_strChipName == "FH8735 PCI" || m_strChipName == "TW5864 PCI" || m_strChipName == "TW2809 PCI" )
	{
		m_strChipName += ", Analog Encoder";

		// OPEN AN ANALOG VIDEO CAPTURE DEVICE
		//
		m_hVideoEncoderDev = AMESDK_CREATE( m_strChipName.GetBuffer( 256 ), (m_nChannelID - 1), 0, NULL, g_on_video_compress_callback[ m_nChannelID - 1 ], this );

		m_strChipName.ReleaseBuffer();
	}	

	if( m_hVideoEncoderDev & 0x80000000 ) 
	{ 
		m_hVideoEncoderDev = 0xFFFFFFFF;
	
		m_bConnect = FALSE;
	
		return m_bConnect;
	}
	
	CString strOSDFile;

	strOSDFile = GetWorkingPath( "OSD.TXT" );

	CHAR *pszOSDFile = strOSDFile.GetBuffer( 256 );			

    AMESDK_SET_CUSTOM_PROPERTY_EX( m_hVideoEncoderDev, 921, (BYTE *)(pszOSDFile), sizeof(pszOSDFile) );    

	strOSDFile.ReleaseBuffer();

	m_bConnect = TRUE;

	return m_bConnect;
}

BOOL MyHwEncodeAV::Disconnect()
{
    if (IsConnected() == FALSE)  {  return FALSE;  }	

	if( m_hVideoEncoderDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoEncoderDev ); m_hVideoEncoderDev = 0xFFFFFFFF; }

	m_bConnect = FALSE;

	return m_bConnect;
}

BOOL MyHwEncodeAV::SetEncodeVideoFormat( ULONG nColorSpaceType, ULONG nCameraType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, DOUBLE dFrameRate)
{
	m_nColorSpaceType = nColorSpaceType;

	m_nCameraType	  = nCameraType;

	m_nFrameWidth	  = nWidth;

	m_nFrameHeight    = nHeight;

	m_nBitCount		  = nBitCount;

	m_dFrameRate      = dFrameRate;

	return TRUE;
}

BOOL MyHwEncodeAV::SetEncodeCBR( ULONG iBitRateKB, ULONG iQPStep, ULONG iGOP )
{
	m_nRecordMode	 = 0;

	m_nBitRateKB_CBR = iBitRateKB * 1024;

	m_nQPStep_CBR	 = iQPStep;

	m_nGOP			 = iGOP;

	return TRUE;
}

BOOL MyHwEncodeAV::SetEncodeVBR( ULONG iQuality, ULONG iGOP )
{
	m_nRecordMode  = 1;

	m_nQuality_VBR = iQuality;

	m_nGOP		   = iGOP;

	return TRUE;
}

BOOL MyHwEncodeAV::SetEncodeHBR( ULONG iQuality, ULONG iBitRateKB, ULONG iQPStep, ULONG iGOP, ULONG iThroughQuality, ULONG iPeakBitRate )
{
	m_nRecordMode			= 3;

	m_nQuality_HBR			= iQuality;

	m_nBitRateKB_HBR		= iBitRateKB * 1024;

	m_nQPStep_HBR			= iQPStep;

	m_nGOP					= iGOP;

	m_nThroughQualityHBR	= iThroughQuality;

	m_nPeakBitRateHBR		= iPeakBitRate;

	return TRUE;
}

BOOL MyHwEncodeAV::SetEncodeRun()
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_SET_STANDARD( m_hVideoEncoderDev, m_nCameraType );

	m_nColorSpaceType = MAKEFOURCC('H', '2', '6', '4');

	bSet = AMESDK_SET_FORMAT( m_hVideoEncoderDev, m_nColorSpaceType, m_nFrameWidth, m_nFrameHeight, m_nBitCount, m_dFrameRate );

	if ( !bSet ) { return FALSE; }	

	if ( m_nRecordMode == 1 )
	{
		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000003, 0 );				   // RECORD MODE

		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000001, m_nQuality_VBR );     // QUALITY (VBR)
	}

	if ( m_nRecordMode == 0 )
	{
		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000003, 1 );				    // RECORD MODE
		
		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000004, m_nBitRateKB_CBR );    // BITRATE (CBR)

		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000005, m_nQPStep_CBR );       // QPSTEP	
	}

	if ( m_nRecordMode == 3 )
	{
		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000003, 2 );				     // RECORD MODE

		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000001, m_nQuality_HBR );       // QUALITY (HBR)
				
		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000004, m_nBitRateKB_HBR );     // BITRATE (HBR)	

		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000005, m_nQPStep_HBR );        // QPSTEP	

		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000006, m_nPeakBitRateHBR );    // PEAK BITRATE

		bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000007, m_nThroughQualityHBR ); // TROUGH QUALITY
	}

	bSet = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoEncoderDev, 0x00000000, m_nGOP );					 // GOP

	bSet = AMESDK_RUN( m_hVideoEncoderDev );	
	
	return bSet;
}

BOOL MyHwEncodeAV::SetEncodeStop()
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_STOP( m_hVideoEncoderDev );

	return bSet;
}

BOOL MyHwEncodeAV::SetEncodePause()
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_PAUSE( m_hVideoEncoderDev );	

	return bSet;
}

CString MyHwEncodeAV::GetWorkingPath(CString strWorkFile)
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	strCurPath += strWorkFile;

	return strCurPath;
}