// SC210Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC210.h"
#include "SC210Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC210_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[SC210] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC210Dlg dialog

CSC210Dlg::CSC210Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC210Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSC210Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev[ 0 ] = 0xFFFFFFFF;

	m_hVideoDev[ 1 ] = 0xFFFFFFFF;

	m_hVideoDev[ 2 ] = 0xFFFFFFFF;

	m_hVideoDev[ 3 ] = 0xFFFFFFFF;

	m_hAudioDev[ 0 ] = 0xFFFFFFFF;

	m_hAudioDev[ 1 ] = 0xFFFFFFFF;

	m_hAudioDev[ 2 ] = 0xFFFFFFFF;

	m_hAudioDev[ 3 ] = 0xFFFFFFFF;

	m_hVideoEncoderDev[ 0 ] = 0xFFFFFFFF;

	m_hVideoEncoderDev[ 1 ] = 0xFFFFFFFF;

	m_hVideoEncoderDev[ 2 ] = 0xFFFFFFFF;

	m_hVideoEncoderDev[ 3 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 0 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 1 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 2 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 3 ] = 0xFFFFFFFF;

	m_nFileRendererRecordState[ 0 ] = 0x00000000;

	m_nFileRendererRecordState[ 1 ] = 0x00000000;

	m_nFileRendererRecordState[ 2 ] = 0x00000000;

	m_nFileRendererRecordState[ 3 ] = 0x00000000;

	m_bFileRendererChangeNotify[ 0 ] = FALSE;

	m_bFileRendererChangeNotify[ 1 ] = FALSE;

	m_bFileRendererChangeNotify[ 2 ] = FALSE;

	m_bFileRendererChangeNotify[ 3 ] = FALSE;

	m_hFileSourceDev[ 0 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 1 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 2 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 3 ] = 0xFFFFFFFF;
}

void CSC210Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSC210Dlg)
	DDX_Control(pDX, IDC_TAB_DISPLAY, m_tabDisplayExchange);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSC210Dlg, CDialog)
	//{{AFX_MSG_MAP(CSC210Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_ERASEBKGND()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_DISPLAY, OnSelChangeTabDisplay)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC210Dlg message handlers

CRect g_rect_channel_window_topology_01_704[ 1 ] = { CRect(       0,       0,       704,       480 )  // FULLSCREEN
};
CRect g_rect_channel_window_topology_04_704[ 4 ] = { CRect(       0,       0,       352,       240 ), // QUAD

													 CRect(     352,       0,       704,       240 ), // QUAD

													 CRect(       0,     240,       352,       480 ), // QUAD

													 CRect(     352,     240,       704,       480 )  // QUAD
};

BOOL on_process_audio_buffer( ULONG nDeviceNumber, ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC210Dlg *      pMainDialog = (CSC210Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_LIVE[ i ]);

	DEVICE_HANDLE    hAudioDev = pMainDialog->m_hAudioDev[ nDeviceNumber ];

	{	EnterCriticalSection( &pMainDialog->m_hFileRendererChangeCriticalSection[ i ] );

		BOOL bIsRecord = (pMainDialog->m_nFileRendererRecordState[ i ] >= 0x00000002) ? TRUE : FALSE;

		if( bIsRecord ) {

			AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( pMainDialog->m_hFileRendererDev[ i ], pBuffer, nBufferLen );
		}
		LeaveCriticalSection( &pMainDialog->m_hFileRendererChangeCriticalSection[ i ] );
	}
	return TRUE;
}

BOOL on_process_video_buffer( ULONG nDeviceNumber, ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC210Dlg *      pMainDialog = (CSC210Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_LIVE[ i ]);

	DEVICE_HANDLE    hVideoDev = pMainDialog->m_hVideoDev[ nDeviceNumber ];

	DEVICE_HANDLE    hVideoEncoderDev = pMainDialog->m_hVideoEncoderDev[ i ];

	DEVICE_HANDLE    hFileDev = pMainDialog->m_hFileRendererDev[ i ];

	ULONG            cxo = pMainDialog->m_nVideoFrameWidth[ nDeviceNumber ];

	ULONG            cyo = pMainDialog->m_nVideoFrameHeight[ nDeviceNumber ];

	ULONG            cxe = pMainDialog->m_nVideoEncoderFrameWidth[ i ];

	ULONG            cye = pMainDialog->m_nVideoEncoderFrameHeight[ i ];

	ULONG            fps = pMainDialog->m_nVideoEncoderFrameRate[ i ];

	BOOL             bIsVisible = (pMainDialog->m_nDisplayModeNumber == 0x00000000) ? TRUE : FALSE;

	BOOL             bIsRecord = (pMainDialog->m_nFileRendererRecordState[ i ] >= 0x00000002) ? TRUE : FALSE;

	if( fps == 29970000 / 1 ) { if( (pMainDialog->m_nVideoEncoderFrameNumber[ i ]++ % 1) != 0 ) { return (bIsVisible) ? TRUE : FALSE; } }

	if( fps == 25000000 / 1 ) { if( (pMainDialog->m_nVideoEncoderFrameNumber[ i ]++ % 1) != 0 ) { return (bIsVisible) ? TRUE : FALSE; } }

	if( fps == 29970000 / 2 ) { if( (pMainDialog->m_nVideoEncoderFrameNumber[ i ]++ % 2) != 0 ) { return (bIsVisible) ? TRUE : FALSE; } }

	if( fps == 25000000 / 2 ) { if( (pMainDialog->m_nVideoEncoderFrameNumber[ i ]++ % 2) != 0 ) { return (bIsVisible) ? TRUE : FALSE; } }

	if( fps == 29970000 / 4 ) { if( (pMainDialog->m_nVideoEncoderFrameNumber[ i ]++ % 4) != 0 ) { return (bIsVisible) ? TRUE : FALSE; } }

	if( fps == 25000000 / 4 ) { if( (pMainDialog->m_nVideoEncoderFrameNumber[ i ]++ % 4) != 0 ) { return (bIsVisible) ? TRUE : FALSE; } }

	if( fps == 29970000 / 8 ) { if( (pMainDialog->m_nVideoEncoderFrameNumber[ i ]++ % 8) != 0 ) { return (bIsVisible) ? TRUE : FALSE; } }

	if( fps == 25000000 / 8 ) { if( (pMainDialog->m_nVideoEncoderFrameNumber[ i ]++ % 8) != 0 ) { return (bIsVisible) ? TRUE : FALSE; } }

	if( pMainDialog->m_nFileRendererRecordState[ i ] >= 0x00000001 ) {

		#if ( SC210_AUTO_FILE_SEGMENT == 1 )

		SYSTEMTIME system_times; GetLocalTime( &system_times );

		if( (pMainDialog->m_sFileRendererChangeSystemTime[ i ].wMinute <  30 && system_times.wMinute >= 30) || // ON TIMEOUT EVENT

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wMinute >= 30 && system_times.wMinute <  30) ||

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wHour != system_times.wHour) ||

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wDay != system_times.wDay) ||

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wMonth != system_times.wMonth) ||

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wYear != system_times.wYear) ) { 

			CHAR path[ MAX_PATH ];

			pMainDialog->m_oSetupDialog.GetRecordPathParameters( path );

			sprintf( pMainDialog->m_pFileRendererChangeDevName[ i ], "Common Analog File Renderer %sCH%02d\\%04d%02d%02d%02d%02d%02d.AVI", path, i + 1, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

			pMainDialog->m_sFileRendererChangeSystemTime[ i ] = system_times;

			pMainDialog->m_bFileRendererChangeNotify[ i ] = TRUE;
		}
		#endif

		if( pMainDialog->m_bFileRendererChangeNotify[ i ] == TRUE ) { // CHANGE CURRENT RECORD FILE [FILE.CHANGING.EVENT]

			ULONG  n_video_color_space_type = 0;

			ULONG  n_video_frame_width = 0;

			ULONG  n_video_frame_height = 0;

			ULONG  n_video_frame_bit_count = 0;

			double f_video_fps = 0.0;

			DWORD  dw_video_custom_flags = 0x00000000;

			ULONG  n_audio_channels = 0;

			ULONG  n_audio_bit_per_sample = 0;

			ULONG  n_audio_samples_per_sec = 0;

			EnterCriticalSection( &pMainDialog->m_hFileRendererChangeCriticalSection[ i ] );

			{	// CLOSE CURRENT RECORD FILE
				//
				if( pMainDialog->m_hFileRendererDev[ i ] != 0xFFFFFFFF ) { 
					
					AMESDK_FILE_GET_VIDEO_STREAM_FORMAT( pMainDialog->m_hFileRendererDev[ i ], &n_video_color_space_type, &n_video_frame_width, &n_video_frame_height, &n_video_frame_bit_count, &f_video_fps, &dw_video_custom_flags );

					AMESDK_FILE_GET_AUDIO_STREAM_FORMAT( pMainDialog->m_hFileRendererDev[ i ], &n_audio_channels, &n_audio_bit_per_sample, &n_audio_samples_per_sec );

					AMESDK_DESTROY( pMainDialog->m_hFileRendererDev[ i ] ); 

					pMainDialog->m_hFileRendererDev[ i ] = 0xFFFFFFFF;
				}
				// UPDATE CURRENT FILE INFO LIST
				//
				{	::PostMessage( pMainDialog->m_oSetupDialog.m_oFileManagerWindow.m_hWnd, WM_UPDATE_FILE_INFO_LIST, i, 0 );
				}
				// CREATE NEW RECORD FILE
				//
				{	pMainDialog->m_hFileRendererDev[ i ] = AMESDK_CREATE( pMainDialog->m_pFileRendererChangeDevName[ i ], i /*POOL*/, 3 /*FILE RENDERER*/, NULL, NULL, NULL );

					if( pMainDialog->m_hFileRendererDev[ i ] & 0x80000000 ) {

						pMainDialog->m_hFileRendererDev[ i ] = 0xFFFFFFFF;
					}
					AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( pMainDialog->m_hFileRendererDev[ i ], n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, f_video_fps, dw_video_custom_flags );

					AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( pMainDialog->m_hFileRendererDev[ i ], n_audio_channels, n_audio_bit_per_sample, n_audio_samples_per_sec );

					hFileDev = pMainDialog->m_hFileRendererDev[ i ];
				}
			}
			AMESDK_PAUSE( hVideoEncoderDev ); // PUT THE ENCODER INTO STOP STATE

			LeaveCriticalSection( &pMainDialog->m_hFileRendererChangeCriticalSection[ i ] );

			pMainDialog->m_bFileRendererChangeNotify[ i ] = FALSE;
		}

		{	BYTE * pStreamBuffer = NULL;

			ULONG  nStreamBufferLen = 0;

			BOOL   bIsKeyFrame = FALSE;

			AMESDK_RUN( hVideoEncoderDev ); // PUT THE ENCODER INTO RUNNING STATE

			AMESDK_CODEC_ENCODE( hVideoEncoderDev, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), cxo, cyo, &pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame );
			
			if( bIsKeyFrame ) { 

				pMainDialog->m_nFileRendererRecordState[ i ] = 0x00000002;

				bIsRecord = TRUE;
			}
			if( bIsRecord ) {

				AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( hFileDev, pStreamBuffer, nStreamBufferLen, bIsKeyFrame );
			}
		}
	}

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INTELLIGENT VISION ALGORITHM PRGRAMMING (EXTRA LICENSE)

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING (EXTRA LICENSE)

	return (bIsVisible) ? TRUE : FALSE; // RETURN FALSE TO REDUCE RENDERER'S CPU COST
}

BOOL on_process_video_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000000, 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000001, 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000002, 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000003, 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000000, 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000001, 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000002, 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000003, 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL CSC210Dlg::HwUnInitialize()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] STOP RECORDING
	//
	{	m_bFileRendererChangeNotify[ 0 ] = FALSE;

		m_bFileRendererChangeNotify[ 1 ] = FALSE;
	
		m_bFileRendererChangeNotify[ 2 ] = FALSE;

		m_bFileRendererChangeNotify[ 3 ] = FALSE;
	
		m_nFileRendererRecordState[ 0 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 1 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 2 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 3 ] = 0x00000000; // STOP STATE
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE DEVICE RESOURCE
	//
	{	if( m_hVideoDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 0 ] ); m_hVideoDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 1 ] ); m_hVideoDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 2 ] ); m_hVideoDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 3 ] ); m_hVideoDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 0 ] ); m_hAudioDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 1 ] ); m_hAudioDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 2 ] ); m_hAudioDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 3 ] ); m_hAudioDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hVideoEncoderDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoEncoderDev[ 0 ] ); m_hVideoEncoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoEncoderDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoEncoderDev[ 1 ] ); m_hVideoEncoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoEncoderDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoEncoderDev[ 2 ] ); m_hVideoEncoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoEncoderDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoEncoderDev[ 3 ] ); m_hVideoEncoderDev[ 3 ] = 0xFFFFFFFF; }
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE FILE RENDERER RESOURCE
	//
	{	if( m_hFileRendererDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 0 ] ); m_hFileRendererDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 1 ] ); m_hFileRendererDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 2 ] ); m_hFileRendererDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 3 ] ); m_hFileRendererDev[ 3 ] = 0xFFFFFFFF; }

		DeleteCriticalSection( &m_hFileRendererChangeCriticalSection[ 0 ] );

		DeleteCriticalSection( &m_hFileRendererChangeCriticalSection[ 1 ] );

		DeleteCriticalSection( &m_hFileRendererChangeCriticalSection[ 2 ] );

		DeleteCriticalSection( &m_hFileRendererChangeCriticalSection[ 3 ] );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE FILE SOURCE RESOURCE
	//
	{	if( m_hFileSourceDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 0 ] ); m_hFileSourceDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 1 ] ); m_hFileSourceDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 2 ] ); m_hFileSourceDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 3 ] ); m_hFileSourceDev[ 3 ] = 0xFFFFFFFF; }
	}
	return TRUE;
}

void CSC210Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUnInitialize();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindow_LIVE[ 0 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 1 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 2 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 3 ].DestroyWindow();

		m_oChannelWindow_FILE[ 0 ].DestroyWindow();

		m_oChannelWindow_FILE[ 1 ].DestroyWindow();

		m_oChannelWindow_FILE[ 2 ].DestroyWindow();

		m_oChannelWindow_FILE[ 3 ].DestroyWindow();

		m_oSetupDialog.DestroyWindow();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE AVI RESOURCE
	//
	{	AVIFileExit();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}
}

BOOL CSC210Dlg::HwInitialize()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GET DEVICE PARAMETERS FROM SETUP DIALOG
	//
	ULONG standard = { 0 };

	ULONG cxo[ 4 ] = { 0, 0, 0, 0 };

	ULONG cyo[ 4 ] = { 0, 0, 0, 0 };

	ULONG cxe[ 4 ] = { 0, 0, 0, 0 };

	ULONG cye[ 4 ] = { 0, 0, 0, 0 };

	ULONG deinterlace[ 4 ] = { 0, 0, 0, 0 };

	double fps[ 4 ] = { 0, 0, 0, 0 };

	ULONG mode[ 4 ] = { 0, 0, 0, 0 };

	ULONG bitrate[ 4 ] = { 0, 0, 0, 0 };

	ULONG quality[ 4 ] = { 0, 0, 0, 0 };

	ULONG gop[ 4 ] = { 0, 0, 0, 0 };

	CHAR path[ MAX_PATH ];

	m_oSetupDialog.GetStandardParameters( &standard );

	m_oSetupDialog.GetResolutionParameters( cxo, cyo );

	m_oSetupDialog.GetResolutionParameters( cxe, cye );

	m_oSetupDialog.GetDeinterlaceParameters( deinterlace );

	m_oSetupDialog.GetFrameRateParameters( fps );

	m_oSetupDialog.GetRecordModeParameters( mode );

	m_oSetupDialog.GetBitRateParameters( bitrate );

	m_oSetupDialog.GetQualityParameters( quality );

	m_oSetupDialog.GetGOPParameters( gop );

	m_oSetupDialog.GetRecordPathParameters( path );

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE AVI RESOURCE
	//
	{	SYSTEMTIME system_times; 
	
		CHAR psz[ MAX_PATH ];

		GetLocalTime( &system_times );

		for( ULONG i = 0 ; i < 4 ; i++ ) {

			InitializeCriticalSection( &m_hFileRendererChangeCriticalSection[ i ] );

			m_sFileRendererChangeSystemTime[ i ] = system_times;

			sprintf( psz, "Common Analog File Renderer %sCH%02d\\%04d%02d%02d%02d%02d%02d.AVI", path, i + 1, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

			m_hFileRendererDev[ i ] = AMESDK_CREATE( psz, i, 3, NULL, NULL, NULL ); // CH#0X

			if( m_hFileRendererDev[ i ] & 0x80000000 ) {
				
				m_hFileRendererDev[ i ] = 0xFFFFFFFF;
			}
			if( SC210_DEFAULT_SOFTWARE_CODEC == 0 ) { AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hFileRendererDev[ i ], MAKEFOURCC('X', 'V', 'I', 'D'), cxe[ i ], cye[ i ], 24, fps[ i ], (cye[ i ] > 288) ? (AMESDK_FILE_CUSTOMFLAG_ISINTERLEAVED | AMESDK_FILE_CUSTOMFLAG_ISSYNCHRONIZATION) : (AMESDK_FILE_CUSTOMFLAG_ISSYNCHRONIZATION) ); } // RESOLUTION / FRAMERATE

			if( SC210_DEFAULT_SOFTWARE_CODEC == 1 ) { AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hFileRendererDev[ i ], MAKEFOURCC('H', '2', '6', '4'), cxe[ i ], cye[ i ], 24, fps[ i ], (cye[ i ] > 288) ? (AMESDK_FILE_CUSTOMFLAG_ISINTERLEAVED | AMESDK_FILE_CUSTOMFLAG_ISSYNCHRONIZATION) : (AMESDK_FILE_CUSTOMFLAG_ISSYNCHRONIZATION) ); } // RESOLUTION / FRAMERATE

			AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hFileRendererDev[ i ], 1, 8, 8000 ); // MONO / 8BITS / 8000HZ
		}
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE DEVICE RESOURCE
	//
	{	HWND wnd[ 8 ] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

		PF_BUFFER_CALLBACK bcb[ 8 ] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };
		
		PVOID params[ 8 ] = { this, this, this, this, this, this, this, this };

		///////////////////////////////////////////////////////////

		wnd[ 0 ] = m_oChannelWindow_LIVE[ 0 ].m_hWnd;

		wnd[ 1 ] = m_oChannelWindow_LIVE[ 1 ].m_hWnd;

		wnd[ 2 ] = m_oChannelWindow_LIVE[ 2 ].m_hWnd;

		wnd[ 3 ] = m_oChannelWindow_LIVE[ 3 ].m_hWnd;

		wnd[ 4 ] = m_oChannelWindow_LIVE[ 0 ].m_hWnd;

		wnd[ 5 ] = m_oChannelWindow_LIVE[ 1 ].m_hWnd;

		wnd[ 6 ] = m_oChannelWindow_LIVE[ 2 ].m_hWnd;

		wnd[ 7 ] = m_oChannelWindow_LIVE[ 3 ].m_hWnd;

		bcb[ 0 ] = on_process_video_buffer_CH01;

		bcb[ 1 ] = on_process_video_buffer_CH02;

		bcb[ 2 ] = on_process_video_buffer_CH03;

		bcb[ 3 ] = on_process_video_buffer_CH04;

		bcb[ 4 ] = on_process_audio_buffer_CH01;

		bcb[ 5 ] = on_process_audio_buffer_CH02;

		bcb[ 6 ] = on_process_audio_buffer_CH03;

		bcb[ 7 ] = on_process_audio_buffer_CH04;

		m_hVideoDev[ 0 ] = AMESDK_CREATE( "CX2581 PCI", 0, 0, wnd[ 0 ], bcb[ 0 ], params[ 0 ] ); // CH#01

		m_hVideoDev[ 1 ] = AMESDK_CREATE( "CX2581 PCI", 1, 0, wnd[ 1 ], bcb[ 1 ], params[ 1 ] ); // CH#02

		m_hVideoDev[ 2 ] = AMESDK_CREATE( "CX2581 PCI", 2, 0, wnd[ 2 ], bcb[ 2 ], params[ 2 ] ); // CH#03

		m_hVideoDev[ 3 ] = AMESDK_CREATE( "CX2581 PCI", 3, 0, wnd[ 3 ], bcb[ 3 ], params[ 3 ] ); // CH#04

		m_hAudioDev[ 0 ] = AMESDK_CREATE( "CX2581 PCI, Analog WaveIn", 0, 0, wnd[ 4 ], bcb[ 4 ], params[ 4 ] ); // CH#01

		m_hAudioDev[ 1 ] = AMESDK_CREATE( "CX2581 PCI, Analog WaveIn", 1, 0, wnd[ 5 ], bcb[ 5 ], params[ 5 ] ); // CH#02

		m_hAudioDev[ 2 ] = AMESDK_CREATE( "CX2581 PCI, Analog WaveIn", 2, 0, wnd[ 6 ], bcb[ 6 ], params[ 6 ] ); // CH#03

		m_hAudioDev[ 3 ] = AMESDK_CREATE( "CX2581 PCI, Analog WaveIn", 3, 0, wnd[ 7 ], bcb[ 7 ], params[ 7 ] ); // CH#04

		if( SC210_DEFAULT_SOFTWARE_CODEC == 0 ) { 

			m_hVideoEncoderDev[ 0 ] = AMESDK_CREATE( "Common Analog Encoder (MPEG4)", 0, 7, NULL, NULL, NULL ); // CH#01

			m_hVideoEncoderDev[ 1 ] = AMESDK_CREATE( "Common Analog Encoder (MPEG4)", 1, 7, NULL, NULL, NULL ); // CH#02

			m_hVideoEncoderDev[ 2 ] = AMESDK_CREATE( "Common Analog Encoder (MPEG4)", 2, 7, NULL, NULL, NULL ); // CH#03

			m_hVideoEncoderDev[ 3 ] = AMESDK_CREATE( "Common Analog Encoder (MPEG4)", 3, 7, NULL, NULL, NULL ); // CH#04
		}
		if( SC210_DEFAULT_SOFTWARE_CODEC == 1 ) { 

			m_hVideoEncoderDev[ 0 ] = AMESDK_CREATE( "Common Analog Encoder (H.264)", 0, 7, NULL, NULL, NULL ); // CH#01

			m_hVideoEncoderDev[ 1 ] = AMESDK_CREATE( "Common Analog Encoder (H.264)", 1, 7, NULL, NULL, NULL ); // CH#02

			m_hVideoEncoderDev[ 2 ] = AMESDK_CREATE( "Common Analog Encoder (H.264)", 2, 7, NULL, NULL, NULL ); // CH#03

			m_hVideoEncoderDev[ 3 ] = AMESDK_CREATE( "Common Analog Encoder (H.264)", 3, 7, NULL, NULL, NULL ); // CH#04
		}
		if( m_hVideoDev[ 0 ] & 0x80000000 ) { m_hVideoDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 1 ] & 0x80000000 ) { m_hVideoDev[ 1 ] = 0xFFFFFFFF; }
		
		if( m_hVideoDev[ 2 ] & 0x80000000 ) { m_hVideoDev[ 2 ] = 0xFFFFFFFF; }
		
		if( m_hVideoDev[ 3 ] & 0x80000000 ) { m_hVideoDev[ 3 ] = 0xFFFFFFFF; }
		
		if( m_hAudioDev[ 0 ] & 0x80000000 ) { m_hAudioDev[ 0 ] = 0xFFFFFFFF; }
		
		if( m_hAudioDev[ 1 ] & 0x80000000 ) { m_hAudioDev[ 1 ] = 0xFFFFFFFF; }
		
		if( m_hAudioDev[ 2 ] & 0x80000000 ) { m_hAudioDev[ 2 ] = 0xFFFFFFFF; }
		
		if( m_hAudioDev[ 3 ] & 0x80000000 ) { m_hAudioDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hVideoEncoderDev[ 0 ] & 0x80000000 ) { m_hVideoEncoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoEncoderDev[ 1 ] & 0x80000000 ) { m_hVideoEncoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoEncoderDev[ 2 ] & 0x80000000 ) { m_hVideoEncoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoEncoderDev[ 3 ] & 0x80000000 ) { m_hVideoEncoderDev[ 3 ] = 0xFFFFFFFF; }

		// SETUP VIDEO PATH (YUY2) PROPERTIES
		// 
		AMESDK_SET_STANDARD( m_hVideoDev[ 0 ], standard ); // STANDARD

		AMESDK_SET_STANDARD( m_hVideoDev[ 1 ], standard ); // STANDARD

		AMESDK_SET_STANDARD( m_hVideoDev[ 2 ], standard ); // STANDARD

		AMESDK_SET_STANDARD( m_hVideoDev[ 3 ], standard ); // STANDARD

		if( standard & 0x00000001 ) { AMESDK_SET_FORMAT( m_hVideoDev[ 0 ], MAKEFOURCC('Y', 'U', 'Y', '2'), cxo[ 0 ], cyo[ 0 ], 16, 29.97 ); } // RESOLUTION / FRAMERATE / NTSC

		if( standard & 0x00000001 ) { AMESDK_SET_FORMAT( m_hVideoDev[ 1 ], MAKEFOURCC('Y', 'U', 'Y', '2'), cxo[ 1 ], cyo[ 1 ], 16, 29.97 ); } // RESOLUTION / FRAMERATE / NTSC

		if( standard & 0x00000001 ) { AMESDK_SET_FORMAT( m_hVideoDev[ 2 ], MAKEFOURCC('Y', 'U', 'Y', '2'), cxo[ 2 ], cyo[ 2 ], 16, 29.97 ); } // RESOLUTION / FRAMERATE / NTSC

		if( standard & 0x00000001 ) { AMESDK_SET_FORMAT( m_hVideoDev[ 3 ], MAKEFOURCC('Y', 'U', 'Y', '2'), cxo[ 3 ], cyo[ 3 ], 16, 29.97 ); } // RESOLUTION / FRAMERATE / NTSC

		if( standard & 0x00000010 ) { AMESDK_SET_FORMAT( m_hVideoDev[ 0 ], MAKEFOURCC('Y', 'U', 'Y', '2'), cxo[ 0 ], cyo[ 0 ], 16, 25.00 ); } // RESOLUTION / FRAMERATE / PALB

		if( standard & 0x00000010 ) { AMESDK_SET_FORMAT( m_hVideoDev[ 1 ], MAKEFOURCC('Y', 'U', 'Y', '2'), cxo[ 1 ], cyo[ 1 ], 16, 25.00 ); } // RESOLUTION / FRAMERATE / PALB

		if( standard & 0x00000010 ) { AMESDK_SET_FORMAT( m_hVideoDev[ 2 ], MAKEFOURCC('Y', 'U', 'Y', '2'), cxo[ 2 ], cyo[ 2 ], 16, 25.00 ); } // RESOLUTION / FRAMERATE / PALB

		if( standard & 0x00000010 ) { AMESDK_SET_FORMAT( m_hVideoDev[ 3 ], MAKEFOURCC('Y', 'U', 'Y', '2'), cxo[ 3 ], cyo[ 3 ], 16, 25.00 ); } // RESOLUTION / FRAMERATE / PALB

		AMESDK_SET_DEINTERLACE( m_hVideoDev[ 0 ], (cyo[ 0 ] > 288) ? (deinterlace[ 0 ]) : (0x00000000) ); // DEINTERLACE

		AMESDK_SET_DEINTERLACE( m_hVideoDev[ 1 ], (cyo[ 1 ] > 288) ? (deinterlace[ 1 ]) : (0x00000000) ); // DEINTERLACE

		AMESDK_SET_DEINTERLACE( m_hVideoDev[ 2 ], (cyo[ 2 ] > 288) ? (deinterlace[ 2 ]) : (0x00000000) ); // DEINTERLACE

		AMESDK_SET_DEINTERLACE( m_hVideoDev[ 3 ], (cyo[ 3 ] > 288) ? (deinterlace[ 3 ]) : (0x00000000) ); // DEINTERLACE

		// SETUP AUDIO PATH (PCM) PROPERTIES
		//
		AMESDK_SET_FORMAT( m_hAudioDev[ 0 ], 1, 8, 8000 ); // MONO / 8BITS / 8000HZ

		AMESDK_SET_FORMAT( m_hAudioDev[ 1 ], 1, 8, 8000 ); // MONO / 8BITS / 8000HZ

		AMESDK_SET_FORMAT( m_hAudioDev[ 2 ], 1, 8, 8000 ); // MONO / 8BITS / 8000HZ

		AMESDK_SET_FORMAT( m_hAudioDev[ 3 ], 1, 8, 8000 ); // MONO / 8BITS / 8000HZ
		
		// SETUP SOFTWARE (MPEG4/H.264) ENCODER PROPERTIES
		//
		if( SC210_DEFAULT_SOFTWARE_CODEC == 0 ) { 

			AMESDK_SET_FORMAT( m_hVideoEncoderDev[ 0 ], MAKEFOURCC('X', 'V', 'I', 'D'), cxe[ 0 ], cye[ 0 ], 24, fps[ 0 ], mode[ 0 ], bitrate[ 0 ], quality[ 0 ], gop[ 0 ], (cye[ 0 ] > 288) ? 1 : 0, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

			AMESDK_SET_FORMAT( m_hVideoEncoderDev[ 1 ], MAKEFOURCC('X', 'V', 'I', 'D'), cxe[ 1 ], cye[ 1 ], 24, fps[ 1 ], mode[ 1 ], bitrate[ 1 ], quality[ 1 ], gop[ 1 ], (cye[ 1 ] > 288) ? 1 : 0, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

			AMESDK_SET_FORMAT( m_hVideoEncoderDev[ 2 ], MAKEFOURCC('X', 'V', 'I', 'D'), cxe[ 2 ], cye[ 2 ], 24, fps[ 2 ], mode[ 2 ], bitrate[ 2 ], quality[ 2 ], gop[ 2 ], (cye[ 2 ] > 288) ? 1 : 0, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

			AMESDK_SET_FORMAT( m_hVideoEncoderDev[ 3 ], MAKEFOURCC('X', 'V', 'I', 'D'), cxe[ 3 ], cye[ 3 ], 24, fps[ 3 ], mode[ 3 ], bitrate[ 3 ], quality[ 3 ], gop[ 3 ], (cye[ 3 ] > 288) ? 1 : 0, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE
		}
		if( SC210_DEFAULT_SOFTWARE_CODEC == 1 ) { 

			AMESDK_SET_FORMAT( m_hVideoEncoderDev[ 0 ], MAKEFOURCC('H', '2', '6', '4'), cxe[ 0 ], cye[ 0 ], 24, fps[ 0 ], mode[ 0 ], bitrate[ 0 ], quality[ 0 ], gop[ 0 ], (cye[ 0 ] > 288) ? 1 : 0, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

			AMESDK_SET_FORMAT( m_hVideoEncoderDev[ 1 ], MAKEFOURCC('H', '2', '6', '4'), cxe[ 1 ], cye[ 1 ], 24, fps[ 1 ], mode[ 1 ], bitrate[ 1 ], quality[ 1 ], gop[ 1 ], (cye[ 1 ] > 288) ? 1 : 0, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

			AMESDK_SET_FORMAT( m_hVideoEncoderDev[ 2 ], MAKEFOURCC('H', '2', '6', '4'), cxe[ 2 ], cye[ 2 ], 24, fps[ 2 ], mode[ 2 ], bitrate[ 2 ], quality[ 2 ], gop[ 2 ], (cye[ 2 ] > 288) ? 1 : 0, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

			AMESDK_SET_FORMAT( m_hVideoEncoderDev[ 3 ], MAKEFOURCC('H', '2', '6', '4'), cxe[ 3 ], cye[ 3 ], 24, fps[ 3 ], mode[ 3 ], bitrate[ 3 ], quality[ 3 ], gop[ 3 ], (cye[ 3 ] > 288) ? 1 : 0, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE
		}
		// START
		//
		m_nVideoEncoderFrameWidth [ 0 ] = cxe[ 0 ];

		m_nVideoEncoderFrameHeight[ 0 ] = cye[ 0 ];

		m_nVideoEncoderFrameWidth [ 1 ] = cxe[ 1 ];

		m_nVideoEncoderFrameHeight[ 1 ] = cye[ 1 ];

		m_nVideoEncoderFrameWidth [ 2 ] = cxe[ 2 ];

		m_nVideoEncoderFrameHeight[ 2 ] = cye[ 2 ];

		m_nVideoEncoderFrameWidth [ 3 ] = cxe[ 3 ];

		m_nVideoEncoderFrameHeight[ 3 ] = cye[ 3 ];

		m_nVideoFrameWidth [ 0 ] = cxo[ 0 ];

		m_nVideoFrameHeight[ 0 ] = cyo[ 0 ];

		m_nVideoFrameWidth [ 1 ] = cxo[ 1 ];

		m_nVideoFrameHeight[ 1 ] = cyo[ 1 ];

		m_nVideoFrameWidth [ 2 ] = cxo[ 2 ];

		m_nVideoFrameHeight[ 2 ] = cyo[ 2 ];

		m_nVideoFrameWidth [ 3 ] = cxo[ 3 ];

		m_nVideoFrameHeight[ 3 ] = cyo[ 3 ];

		m_nVideoFrameRate[ 0 ] = (standard & 0x00000001) ? 29970000 : 25000000;

		m_nVideoFrameRate[ 1 ] = (standard & 0x00000001) ? 29970000 : 25000000;

		m_nVideoFrameRate[ 2 ] = (standard & 0x00000001) ? 29970000 : 25000000;

		m_nVideoFrameRate[ 3 ] = (standard & 0x00000001) ? 29970000 : 25000000;

		m_nVideoEncoderFrameRate[ 0 ] = (ULONG)(fps[ 0 ] * 1000000);

		m_nVideoEncoderFrameRate[ 1 ] = (ULONG)(fps[ 1 ] * 1000000);

		m_nVideoEncoderFrameRate[ 2 ] = (ULONG)(fps[ 2 ] * 1000000);

		m_nVideoEncoderFrameRate[ 3 ] = (ULONG)(fps[ 3 ] * 1000000);

		m_nVideoEncoderFrameNumber[ 0 ] = 0;

		m_nVideoEncoderFrameNumber[ 1 ] = 0;

		m_nVideoEncoderFrameNumber[ 2 ] = 0;

		m_nVideoEncoderFrameNumber[ 3 ] = 0;

		AMESDK_RUN( m_hVideoDev[ 0 ] );

		AMESDK_RUN( m_hVideoDev[ 1 ] );

		AMESDK_RUN( m_hVideoDev[ 2 ] );

		AMESDK_RUN( m_hVideoDev[ 3 ] );
		
		AMESDK_RUN( m_hAudioDev[ 0 ] );

		AMESDK_RUN( m_hAudioDev[ 1 ] );

		AMESDK_RUN( m_hAudioDev[ 2 ] );

		AMESDK_RUN( m_hAudioDev[ 3 ] );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] START RECORDING
	//
	{	m_bFileRendererChangeNotify[ 0 ] = FALSE;

		m_bFileRendererChangeNotify[ 1 ] = FALSE;
	
		m_bFileRendererChangeNotify[ 2 ] = FALSE;

		m_bFileRendererChangeNotify[ 3 ] = FALSE;
	
		m_nFileRendererRecordState[ 0 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 1 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 2 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 3 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
	}

	return TRUE;
}

BOOL CSC210Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE AVI RESOURCE
	//
	{	AVIFileInit();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE USER INTERFACE RESOURCE
	//
	{	CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		ULONG tx = 10; // SET CUSTOM BOUNDARY WIDTH OF TAB CONTROL

		ULONG ty = 32; // SET CUSTOM BOUNDARY HEIGHT OF TAB CONTROL

		SetWindowPos( &(CWnd::wndTop), 0, 0, 704 + (cx) + (tx + tx), 480 + (cy) + (ty + tx), SWP_NOMOVE );

		m_tabDisplayExchange.MoveWindow( 0, 0, 704 + (tx + tx), 480 + (ty + tx) );

		m_tabDisplayExchange.InsertItem( 0, "LIVE DISPLAY" );

		m_tabDisplayExchange.InsertItem( 1, "RECORD PLAYBACK" );

		m_nDisplayModeNumber = 0x00000000;

		{	g_rect_channel_window_topology_01_704[ 0 ].top += ty; g_rect_channel_window_topology_01_704[ 0 ].bottom += ty; g_rect_channel_window_topology_01_704[ 0 ].left += tx; g_rect_channel_window_topology_01_704[ 0 ].right += tx;

			g_rect_channel_window_topology_04_704[ 0 ].top += ty; g_rect_channel_window_topology_04_704[ 0 ].bottom += ty; g_rect_channel_window_topology_04_704[ 0 ].left += tx; g_rect_channel_window_topology_04_704[ 0 ].right += tx;

			g_rect_channel_window_topology_04_704[ 1 ].top += ty; g_rect_channel_window_topology_04_704[ 1 ].bottom += ty; g_rect_channel_window_topology_04_704[ 1 ].left += tx; g_rect_channel_window_topology_04_704[ 1 ].right += tx;

			g_rect_channel_window_topology_04_704[ 2 ].top += ty; g_rect_channel_window_topology_04_704[ 2 ].bottom += ty; g_rect_channel_window_topology_04_704[ 2 ].left += tx; g_rect_channel_window_topology_04_704[ 2 ].right += tx;

			g_rect_channel_window_topology_04_704[ 3 ].top += ty; g_rect_channel_window_topology_04_704[ 3 ].bottom += ty; g_rect_channel_window_topology_04_704[ 3 ].left += tx; g_rect_channel_window_topology_04_704[ 3 ].right += tx;
		}
		m_oChannelWindow_LIVE[ 0 ].Create( NULL, "MyChannelWindow#LIVE#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 0 ], this, 0x00000001, NULL );

		m_oChannelWindow_LIVE[ 1 ].Create( NULL, "MyChannelWindow#LIVE#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 1 ], this, 0x00000002, NULL );

		m_oChannelWindow_LIVE[ 2 ].Create( NULL, "MyChannelWindow#LIVE#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 2 ], this, 0x00000003, NULL );

		m_oChannelWindow_LIVE[ 3 ].Create( NULL, "MyChannelWindow#LIVE#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 3 ], this, 0x00000004, NULL );

		m_oChannelWindow_FILE[ 0 ].Create( NULL, "MyChannelWindow#FILE#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 0 ], this, 0x10000001, NULL );

		m_oChannelWindow_FILE[ 1 ].Create( NULL, "MyChannelWindow#FILE#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 1 ], this, 0x10000002, NULL );

		m_oChannelWindow_FILE[ 2 ].Create( NULL, "MyChannelWindow#FILE#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 2 ], this, 0x10000003, NULL );

		m_oChannelWindow_FILE[ 3 ].Create( NULL, "MyChannelWindow#FILE#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 3 ], this, 0x10000004, NULL );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );

		SetTimer( 0x00000000, 0, NULL );
	}	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC210Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING
	//
	if( nIDEvent == 0x00000000 ) {

		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		ULONG tx = (960 - 704 - 20) >> 1;

		m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

		m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), oWindowRect.left - tx, oWindowRect.bottom - 75 + 5, cx + 960, cy + 150, NULL );

		m_oSetupDialog.ShowWindow( TRUE );

		SetWindowPos( NULL, oWindowRect.left, oWindowRect.top - 75, 0, 0, SWP_NOSIZE | SWP_NOZORDER );

		SetFocus();

		m_oSetupDialog.UpdateWindow();

		KillTimer( 0x00000000 );

		// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE DEVICE RESOURCE
		//
		HwInitialize();
	}
	CDialog::OnTimer(nIDEvent);
}

void CSC210Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC210Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC210Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSC210Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

extern volatile HANDLE  g_h_export_file_to_disk_thread;

void CSC210Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	if( g_h_export_file_to_disk_thread != NULL ) {

		AfxMessageBox( "FILE EXPROTING ...\n\nDON'T CLOSE SOFTWARE !!!" );

		return ;
	}
	CDialog::OnCancel();
}

void CSC210Dlg::OnSelChangeTabDisplay(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING (LIVE/RCPB/RTPB)
	//
	m_nDisplayModeNumber = m_tabDisplayExchange.GetCurSel();

	if( m_nDisplayModeNumber == 0x00000000 ) { // LIVE

		m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ], FALSE ); // QUAD

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ], 0 );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ], 1 );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ], 2 );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ], 3 );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );
	}
	if( m_nDisplayModeNumber == 0x00000001 ) { // RCPB

		m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ], FALSE ); // QUAD

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] );

		m_oChannelWindow_FILE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE );
	}

	m_oSetupDialog.OnSelChangeTabDisplay_SC210Dlg( m_nDisplayModeNumber );

   *pResult = 0;
}

BOOL CSC210Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING
	// 
	{	CBrush brush( RGB( 236, 233, 216 ) );

		CRect rect_client; 

		CRgn rgn_client;

		CRgn rgn_children;

		GetClientRect( &rect_client );

		rgn_client.CreateRectRgn( rect_client.left, rect_client.top, rect_client.right, rect_client.bottom );

		rgn_children.CreateRectRgn( 0, 0, 0, 0 );

		for( ULONG i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_LIVE[ i ].IsWindowVisible() ) {

				m_oChannelWindow_LIVE[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}
		for( i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_FILE[ i ].IsWindowVisible() ) {

				m_oChannelWindow_FILE[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}
		rgn_client.CombineRgn( &rgn_client, &rgn_children, RGN_XOR );

		pDC->FillRgn( &rgn_client, &brush );
	}
	return TRUE;

	return CDialog::OnEraseBkgnd(pDC);
}

BOOL CSC210Dlg::OnLButtonDown_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING (LIVE MODE)
	//
	if( nChannelNumber == 0x00000001 ||

		nChannelNumber == 0x00000002 ||

		nChannelNumber == 0x00000003 ||

		nChannelNumber == 0x00000004 ) {

		nChannelNumber -= 0x00000001;

		CRect rect;
	
		m_oChannelWindow_LIVE[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 360 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 3 ] ); }

		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 3 ] ); }
		}
	}

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING (RCPB MODE)
	//
	if( nChannelNumber == 0x10000001 ||

		nChannelNumber == 0x10000002 ||

		nChannelNumber == 0x10000003 ||

		nChannelNumber == 0x10000004 ) {

		nChannelNumber -= 0x10000001;

		CRect rect;
	
		m_oChannelWindow_FILE[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 360 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] ); }
		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] ); }
		}
	}
	return TRUE;
}

BOOL CSC210Dlg::OnLButtonUp_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point )
{
	return TRUE;
}

BOOL CSC210Dlg::OnSync_SetupDialog()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] CHANGE CURRENT RECORD FILE [FILE.CHANGING.EVENT]
	//
	SYSTEMTIME system_times; 
	
	GetLocalTime( &system_times );

	ULONG channel[ 4 ] = { 0, 0, 0, 0 };

	CHAR path[ MAX_PATH ];

	m_oSetupDialog.GetRecordPathParameters( path );

	sprintf( m_pFileRendererChangeDevName[ 0 ], "Common Analog File Renderer %sCH01\\%04d%02d%02d%02d%02d%02d.AVI", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

	sprintf( m_pFileRendererChangeDevName[ 1 ], "Common Analog File Renderer %sCH02\\%04d%02d%02d%02d%02d%02d.AVI", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

	sprintf( m_pFileRendererChangeDevName[ 2 ], "Common Analog File Renderer %sCH03\\%04d%02d%02d%02d%02d%02d.AVI", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

	sprintf( m_pFileRendererChangeDevName[ 3 ], "Common Analog File Renderer %sCH04\\%04d%02d%02d%02d%02d%02d.AVI", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

	m_sFileRendererChangeSystemTime[ 0 ] = system_times;

	m_sFileRendererChangeSystemTime[ 1 ] = system_times;

	m_sFileRendererChangeSystemTime[ 2 ] = system_times;

	m_sFileRendererChangeSystemTime[ 3 ] = system_times;

	m_bFileRendererChangeNotify[ 0 ] = TRUE;

	m_bFileRendererChangeNotify[ 1 ] = TRUE;

	m_bFileRendererChangeNotify[ 2 ] = TRUE;

	m_bFileRendererChangeNotify[ 3 ] = TRUE;

	// WAITING FILE.CHANGE.EVENT COMPLETE ...
	//
	if( m_hVideoEncoderDev[ 0 ] != 0xFFFFFFFF ) { while( m_bFileRendererChangeNotify[ 0 ] == TRUE ) { ; } }

	if( m_hVideoEncoderDev[ 1 ] != 0xFFFFFFFF ) { while( m_bFileRendererChangeNotify[ 1 ] == TRUE ) { ; } }

	if( m_hVideoEncoderDev[ 2 ] != 0xFFFFFFFF ) { while( m_bFileRendererChangeNotify[ 2 ] == TRUE ) { ; } }

	if( m_hVideoEncoderDev[ 3 ] != 0xFFFFFFFF ) { while( m_bFileRendererChangeNotify[ 3 ] == TRUE ) { ; } }

	return TRUE;
}

BOOL CSC210Dlg::OnSnapshot_SetupDialog()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] SNAPSHOT FUNCTION PROGRAMMING
	//
	CHAR path[ MAX_PATH ];

	CHAR psz[ MAX_PATH ];

	SYSTEMTIME system_times; 
	
	GetLocalTime( &system_times );

	m_oSetupDialog.GetRecordPathParameters( path );

	if( m_nDisplayModeNumber == 0x00000000 ) { // LIVE
	
		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoDev[ 0 ], psz, 0 );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 0 ], psz, 80, 0 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 1 ], psz, 80, 0 );
	
		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 2 ], psz, 80, 0 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 3 ], psz, 80, 0 );
	}
	if( m_nDisplayModeNumber == 0x00000001 ) { // RCPB

		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hFileSourceDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 3 ], psz, 80 );
	}
	return TRUE;
}

BOOL CSC210Dlg::OnApply_SetupDialog()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] RESET DEVICE RESOURCE
	//
	HwUnInitialize();

	HwInitialize();

	Invalidate( TRUE );

	return TRUE;
}

BOOL CSC210Dlg::OnFileSourceDestroy_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE FILE SOURCE RESOURCE
	//
	if( m_hFileSourceDev[ nChannelNumber ] != 0xFFFFFFFF ) { 
		
		AMESDK_DESTROY( m_hFileSourceDev[ nChannelNumber ] ); 
		
		m_hFileSourceDev[ nChannelNumber ] = 0xFFFFFFFF; 
	}
	return TRUE;
}

BOOL CSC210Dlg::OnFileSourceCreate_FileManagerWindow( ULONG nChannelNumber, AMESDK_FILE_INFO * pFileInfo )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE FILE SOURCE RESOURCE (PLAYING & PRELOAD)
	//
	ULONG deinterlace[ 4 ] = { 0, 0, 0, 0 };

	m_oSetupDialog.GetDeinterlaceParameters( deinterlace );

	if( m_hFileSourceDev[ nChannelNumber ] == 0xFFFFFFFF ) {

		CHAR psz[ MAX_PATH ];

		sprintf( psz, "Common Analog File Source %s", pFileInfo->m_pszFileName );

		// THE TWO LOCATIONS OF POOL ARE USED TO PLAYING & PRELOAD ALGORITHM
		// 
		m_hFileSourceDev[ nChannelNumber ] = AMESDK_CREATE( psz, nChannelNumber, 2 /*FILE SOURCE*/, m_oChannelWindow_FILE[ nChannelNumber ].m_hWnd, NULL, NULL );

		if( m_hFileSourceDev[ nChannelNumber ] & 0x80000000 ) { 

			m_hFileSourceDev[ nChannelNumber ] = 0xFFFFFFFF; 
		}
		if( pFileInfo->m_nVideoHeight > 288 ) { // 720  480, 720  576, 704  480, 704  576, 640  480, 640  576

			AMESDK_SET_DEINTERLACE( m_hFileSourceDev[ nChannelNumber ], deinterlace[ nChannelNumber ] );
		}
		else { // 720  240, 720  288, 704  240, 704  288, 640  240, 640  288, 
			
			   // 360  240, 360  288, 352  240, 352  288, 320  240, 320  288

			AMESDK_SET_DEINTERLACE( m_hFileSourceDev[ nChannelNumber ], 0x00000000 );
		}
	}
	return TRUE;
}

BOOL CSC210Dlg::OnFileSourceRun_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_RUN( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC210Dlg::OnFileSourcePause_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_PAUSE( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC210Dlg::OnFileSourceStop_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_STOP( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC210Dlg::OnFileSourceStep_FileManagerWindow( ULONG nChannelNumber, ULONG nSteps )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_STEP( m_hFileSourceDev[ nChannelNumber ], nSteps );
}

BOOL CSC210Dlg::OnFileSourceGetVideoStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp, BOOL * pIsKeyFrame )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_VIDEO_STREAM_DATA( m_hFileSourceDev[ nChannelNumber ], nSample, pTimeStamp, pIsKeyFrame );
}

BOOL CSC210Dlg::OnFileSourceGetAudioStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_AUDIO_STREAM_DATA( m_hFileSourceDev[ nChannelNumber ], nSample, pTimeStamp );
}

LONGLONG CSC210Dlg::OnFileSourceGetMediaLength_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	LONGLONG nLength = 0;

	AMESDK_FILE_GET_MEDIA_LENGTH( m_hFileSourceDev[ nChannelNumber ], &nLength, dwTimeUnits );

	return nLength;
}

LONGLONG CSC210Dlg::OnFileSourceGetMediaPosition_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	LONGLONG nPosition = 0;

	AMESDK_FILE_GET_MEDIA_POSITION( m_hFileSourceDev[ nChannelNumber ], &nPosition, dwTimeUnits );

	return nPosition;
}

BOOL CSC210Dlg::OnFileSourceSetMediaPosition_FileManagerWindow( ULONG nChannelNumber, LONGLONG nPosition, DWORD dwTimeUnits )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_SET_MEDIA_POSITION( m_hFileSourceDev[ nChannelNumber ], nPosition, dwTimeUnits );
}

double CSC210Dlg::OnFileSourceGetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	double dRate = 0;

	AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE( m_hFileSourceDev[ nChannelNumber ], &dRate );

	return dRate;
}

BOOL CSC210Dlg::OnFileSourceSetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber, double dRate )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_SET_MEDIA_PLAYBACK_RATE( m_hFileSourceDev[ nChannelNumber ], dRate );
}
