#include <stdio.h>
#include <inttypes.h>
#include "lite-qmi-dms.h"
#include "dms.h"


typedef struct
{
	uint32_t status;
	const char* szStatus;
}Map_Status;

static Map_Status g_Table_ActivationStatus[] =
{
  {0, "Online"},
  {1, "Low power"},
  {2, "Factory test mode"},
  {3, "Offline"},
  {4, "Resetting"},
  {5, "Shutting down"},
  {6, "Persistent low power"},
  {7, "Mode-only low power"},
  {8, "Conducting network test for GSM/WCDMA"},
  {9, "Camp only"},
 };

static Map_Status g_Table_OperatingMode[] =
{
  {0, "Service not activated"},
  {1, "Service activated"},
  {2, "Activation connecting"},
  {3, "Activation connected"},
  {4, "OTASP security authenticated"},
  {5, "OTASP NAM downloaded"},
  {6, "OTASP MDN downloaded"},
  {7, "OTASP IMSI downloaded"},
  {8, "OTASP PRL downloaded"},
  {9, "OTASP SPC downloaded"},
  {10, "OTASP settings committed"},
};

void DisplayGetBandCapability(unpack_dms_SLQSGetBandCapability_t *pBandCapability)
{
    printf("\n%s: Success\n", "GetBandCapability");
    if(swi_uint256_get_bit (pBandCapability->ParamPresenceMask, 1))
    {
        printf(" Band Cap    : 0x%"PRIX64"\n", pBandCapability->bandCapability);
    }
    if(swi_uint256_get_bit (pBandCapability->ParamPresenceMask, 16))
    {
        printf(" LTE Band Cap: 0x%"PRIX64"\n", pBandCapability->LteBandCapability);
    }
    if(swi_uint256_get_bit (pBandCapability->ParamPresenceMask, 17))
    {
            printf(" TDS Band Cap: 0x%"PRIX64"\n", pBandCapability->TdsBandCapability);
    }
	if (swi_uint256_get_bit(pBandCapability->ParamPresenceMask, 18))
	{
		printf(" LTE Band length: %d\n", pBandCapability->LteBands.bands_len);
		for (int i = 0; i < pBandCapability->LteBands.bands_len; i++)
			printf("  LTE Band %d: %d\n", i, pBandCapability->LteBands.bands[i]);
	}
	if (swi_uint256_get_bit(pBandCapability->ParamPresenceMask, 19))
	{
		printf(" NR5G band len: %d\n", pBandCapability->Nr5gBands.bands_len);
		for (int idx = 0; idx < pBandCapability->Nr5gBands.bands_len; idx++)
			printf("  NR5G band[%d]: %d\n", idx, pBandCapability->Nr5gBands.bands[idx]);
	}
}

void DisplayGetFirmwareInformation(unpack_dms_GetFirmwareInfo_t *pfirmwareInfo)
{
    printf("\n%s: %s\n", "GetFirmwareInformation", pfirmwareInfo->Tlvresult? "Fail" : "Success");
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 16))
        printf("  Model Id: %s\n", pfirmwareInfo->modelid_str);
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 17))
        printf("  Boot Version: %s\n", pfirmwareInfo->bootversion_str);
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 18))
        printf("  app version: %s\n", pfirmwareInfo->appversion_str);
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 19))
        printf("  SKU Id: %s\n", pfirmwareInfo->sku_str);
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 20))
        printf("  Package Id: %s\n", pfirmwareInfo->packageid_str);
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 21))
        printf("  Carrier: %s\n", pfirmwareInfo->carrier_str);
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 22))
        printf("  PRI Version: %s\n", pfirmwareInfo->priversion_str);
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 23))
        printf("  Carrier Name: %s\n", pfirmwareInfo->cur_carr_name);
    if(swi_uint256_get_bit (pfirmwareInfo->ParamPresenceMask, 24))
        printf("  Carrier Rev: %s\n", pfirmwareInfo->cur_carr_rev);
}

void DisplayGetSerialNumbers(unpack_dms_GetSerialNumbers_t *pSerialNumbers)
{
    printf("\nGetSerialNumbers : Success\n");
    if(swi_uint256_get_bit (pSerialNumbers->ParamPresenceMask, 16))
        printf("  ESN String : %s\n", pSerialNumbers->esn);
    if(swi_uint256_get_bit (pSerialNumbers->ParamPresenceMask, 17))
        printf("  IMEI String : %s\n", pSerialNumbers->imei_no);
    if(swi_uint256_get_bit (pSerialNumbers->ParamPresenceMask, 18))
        printf("  MEID String : %s\n", pSerialNumbers->meid);
    if(swi_uint256_get_bit (pSerialNumbers->ParamPresenceMask, 19))
        printf("  IMEI SV String : %s\n", pSerialNumbers->imeisv_svn);
}

void DisplayGetHostDevInfoSettings(unpack_dms_SLQSSwiGetHostDevInfo_t *pSwiGetHostDevInfo)
{
	printf("%s Result : %d\n", __FUNCTION__, pSwiGetHostDevInfo->Tlvresult);

	if (swi_uint256_get_bit (pSwiGetHostDevInfo->ParamPresenceMask, 0x10) && 
		pSwiGetHostDevInfo->manString != NULL && 
		pSwiGetHostDevInfo->manString[0] != 0x7f)
	{
		printf("Manufacturer : %s\n", pSwiGetHostDevInfo->manString);
	}
	if (swi_uint256_get_bit (pSwiGetHostDevInfo->ParamPresenceMask, 0x11) && 
		pSwiGetHostDevInfo->modelString != NULL &&
		pSwiGetHostDevInfo->modelString[0] != 0x7f)
	{
		printf("Model String : %s\n", pSwiGetHostDevInfo->modelString);
	}
	if (swi_uint256_get_bit (pSwiGetHostDevInfo->ParamPresenceMask, 0x12) && 
		pSwiGetHostDevInfo->swVerString != NULL &&
		pSwiGetHostDevInfo->swVerString[0] != 0x7f)
	{
		printf("Software Version : %s\n", pSwiGetHostDevInfo->swVerString);
	}
	if (swi_uint256_get_bit (pSwiGetHostDevInfo->ParamPresenceMask, 0x13) &&
		pSwiGetHostDevInfo->plasmaIDString != NULL &&
		pSwiGetHostDevInfo->plasmaIDString[0] != 0x7f)
	{
		printf("Plasma ID String : %s\n", pSwiGetHostDevInfo->plasmaIDString);
	}
	if (swi_uint256_get_bit (pSwiGetHostDevInfo->ParamPresenceMask, 0x14) &&
		pSwiGetHostDevInfo->hostID != NULL &&
		pSwiGetHostDevInfo->hostID[0] != 0x7f)
	{
		printf("Host ID : %s\n", pSwiGetHostDevInfo->hostID);
	}
	if (swi_uint256_get_bit (pSwiGetHostDevInfo->ParamPresenceMask, 0x14) &&
		pSwiGetHostDevInfo->pInstance != NULL)
	{
		printf("instance : %d\n", *pSwiGetHostDevInfo->pInstance);
	}
}

void DisplaySetEventReportInd(unpack_dms_SetEventReport_ind_t *pSetEventReport_ind)
{
	printf("\nSetEventReport Indication:\n");
 
	if (swi_uint256_get_bit(pSetEventReport_ind->ParamPresenceMask, 0x13) && pSetEventReport_ind->ActivationStatusTlv.activationStatus < 8)
	{
		printf("Activation Status: %s\n", g_Table_ActivationStatus[pSetEventReport_ind->ActivationStatusTlv.activationStatus].szStatus);
	}

	if (swi_uint256_get_bit(pSetEventReport_ind->ParamPresenceMask, 0x14) && pSetEventReport_ind->OperatingModeTlv.operatingMode < 11)
	{
		printf("Operating Mode: %s\n", g_Table_OperatingMode[pSetEventReport_ind->OperatingModeTlv.operatingMode].szStatus);
	}
}

void DisplayGetPower(unpack_dms_GetPower_t *pUnpackGetPower)
{
	printf("\nGet Power:\n");
 
	if (swi_uint256_get_bit (pUnpackGetPower->ParamPresenceMask, 0x01))
	{
		printf("  Activation Status: %s\n", g_Table_ActivationStatus[pUnpackGetPower->OperationMode].szStatus);
	}
	if (swi_uint256_get_bit (pUnpackGetPower->ParamPresenceMask, 0x10))
	{
		printf("  Offline reason:\n");
        if (pUnpackGetPower->OfflineReason & 0x01)
		    printf("    Host image misconfiguration\n");
        if (pUnpackGetPower->OfflineReason & 0x02)
		    printf("    PRI image misconfiguration\n");
        if (pUnpackGetPower->OfflineReason & 0x04)
		    printf("    PRI version incompatible\n");
        if (pUnpackGetPower->OfflineReason & 0x08)
		    printf("    Device memory is full,cannot copy PRI information\n");
	}
	if (swi_uint256_get_bit (pUnpackGetPower->ParamPresenceMask, 0x11))
	{
		printf("  hardware restricted mode: %s\n", pUnpackGetPower->HardwareControlledMode? "true" : "false");
	}
}
