#include <assert.h>
#ifndef DRI_NEW_INTERFACE_ONLY
# include <X11/Xlibint.h>
# include <Xext.h>
# include <extutil.h>
# include "xf86dri.h"
# define _mesa_malloc(b) Xmalloc(b)
# define _mesa_free(m) Xfree(m)
#else
# include "imports.h"
# define None 0
#endif /* DRI_NEW_INTERFACE_ONLY */

#include "dri_util.h"
#include "drm_sarea.h"
#include "glcontextmodes.h"

#include "intel_screen.h"


#ifndef MAP_FAILED
#define MAP_FAILED ((void *)-1)
#endif


/**
 * Driver-specific version of the __driUtilCreateScreen function.
 * We can't use the version in dri_util.c because we need access to
 * the front color buffer memory map.
 *
 * See comments/docs for __driUtilCreateScreen for more info.
 */
__DRIscreenPrivate *
intelCreateScreen(Display *dpy, int scrn, __DRIscreen *psc,
                  int numConfigs, __GLXvisualConfig *configs,
                  const struct __DriverAPIRec *driverAPI)
{
    int directCapable;
    __DRIscreenPrivate *psp = NULL;
    drm_handle_t hSAREA;
    drmAddress pSAREA;
    char *BusID;
    __GLcontextModes *modes;
    __GLcontextModes *temp;
    int   i;
    __DRIversion   ddx_version;
    __DRIversion   dri_version;
    __DRIversion   drm_version;
    __DRIframebuffer  framebuffer;
    int   fd = -1;
    int   status;
    const char * err_msg;
    const char * err_extra;


    if (!XF86DRIQueryDirectRenderingCapable(dpy, scrn, &directCapable)
	|| !directCapable) {
	return NULL;
    }


    /* Create the linked list of context modes, and populate it with the
     * GLX visual information passed in by libGL.
     */

    modes = _gl_context_modes_create( numConfigs, sizeof(__GLcontextModes) );
    if ( modes == NULL ) {
	return NULL;
    }

    temp = modes;
    for ( i = 0 ; i < numConfigs ; i++ ) {
	assert( temp != NULL );
	_gl_copy_visual_to_context_mode( temp, & configs[i] );
	temp->screen = scrn;

	temp = temp->next;
    }

    err_msg = "XF86DRIOpenConnection";
    err_extra = NULL;

    if (XF86DRIOpenConnection(dpy, scrn, &hSAREA, &BusID)) {
	fd = drmOpen(NULL,BusID);
	_mesa_free(BusID); /* No longer needed */

	err_msg = "open DRM";
	err_extra = strerror( -fd );

	if (fd >= 0) {
	    drm_magic_t magic;

	    err_msg = "drmGetMagic";
	    err_extra = NULL;

	    if (!drmGetMagic(fd, &magic)) {
		drmVersionPtr version = drmGetVersion(fd);
		if (version) {
		    drm_version.major = version->version_major;
		    drm_version.minor = version->version_minor;
		    drm_version.patch = version->version_patchlevel;
		    drmFreeVersion(version);
		}
		else {
		    drm_version.major = -1;
		    drm_version.minor = -1;
		    drm_version.patch = -1;
		}

		err_msg = "XF86DRIAuthConnection";
		if (XF86DRIAuthConnection(dpy, scrn, magic)) {
		    char *driverName;

		    /*
		     * Get device name (like "tdfx") and the ddx version numbers.
		     * We'll check the version in each DRI driver's "createScreen"
		     * function.
		     */
		    err_msg = "XF86DRIGetClientDriverName";
		    if (XF86DRIGetClientDriverName(dpy, scrn,
						   &ddx_version.major,
						   &ddx_version.minor,
						   &ddx_version.patch,
						   &driverName)) {

			/* No longer needed. */
			_mesa_free( driverName );

			/*
			 * Get the DRI X extension version.
			 */
			err_msg = "XF86DRIQueryVersion";
			if (XF86DRIQueryVersion(dpy,
						&dri_version.major,
						&dri_version.minor,
						&dri_version.patch)) {
			    drm_handle_t  hFB;
			    int        junk;

			    /*
			     * Get device-specific info.  pDevPriv will point to a struct
			     * (such as DRIRADEONRec in xfree86/driver/ati/radeon_dri.h)
			     * that has information about the screen size, depth, pitch,
			     * ancilliary buffers, DRM mmap handles, etc.
			     */
			    err_msg = "XF86DRIGetDeviceInfo";
			    if (XF86DRIGetDeviceInfo(dpy, scrn,
						     &hFB,
						     &junk,
						     &framebuffer.size,
						     &framebuffer.stride,
						     &framebuffer.dev_priv_size,
						     &framebuffer.dev_priv)) {
				framebuffer.width = DisplayWidth(dpy, scrn);
				framebuffer.height = DisplayHeight(dpy, scrn);

				/*
				 * Map the framebuffer region.
				 */
#if 0
				status = drmMap(fd, hFB, framebuffer.size, 
						(drmAddressPtr)&framebuffer.base);
				
				err_msg = "drmMap of framebuffer";
				err_extra = strerror( -status );
#else
                                /* do mapping in the driver code */
                                framebuffer.base = NULL;
                                status = 0;
#endif

				if ( status == 0 ) {
				    /*
				     * Map the SAREA region.  Further mmap regions may be setup in
				     * each DRI driver's "createScreen" function.
				     */
				    status = drmMap(fd, hSAREA, SAREA_MAX, 
						    &pSAREA);

				    err_msg = "drmMap of sarea";
				    err_extra = strerror( -status );

				    if ( status == 0 ) {
					PFNGLXGETINTERNALVERSIONPROC get_ver;

					get_ver = (PFNGLXGETINTERNALVERSIONPROC)
					    glXGetProcAddress( (const GLubyte *) "__glXGetInternalVersion" );

					err_msg = "InitDriver";
					err_extra = NULL;
					psp = __driUtilCreateNewScreen( dpy, scrn, psc, modes,
									& ddx_version,
									& dri_version,
									& drm_version,
									& framebuffer,
									pSAREA,
									fd,
									(get_ver != NULL) ? (*get_ver)() : 1,
									driverAPI );
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    if ( psp == NULL ) {
	if ( pSAREA != MAP_FAILED ) {
	    (void)drmUnmap(pSAREA, SAREA_MAX);
	}

	if ( framebuffer.base != MAP_FAILED ) {
	    (void)drmUnmap((drmAddress)framebuffer.base, framebuffer.size);
	}

	if ( framebuffer.dev_priv != NULL ) {
	    _mesa_free(framebuffer.dev_priv);
	}

	if ( fd >= 0 ) {
	    (void)drmClose(fd);
	}

	if ( modes != NULL ) {
	    _gl_context_modes_destroy( modes );
	}

	(void)XF86DRICloseConnection(dpy, scrn);

	if ( err_extra != NULL ) {
	    fprintf(stderr, "libGL error: %s failed (%s)\n", err_msg,
		    err_extra);
	}
	else {
	    fprintf(stderr, "libGL error: %s failed\n", err_msg );
	}

        fprintf(stderr, "libGL error: reverting to (slow) indirect rendering\n");
    }

    return psp;
}
