/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2004, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	assoc.c

	Abstract:

	Revision History:
	Who			When			What
	--------	----------		----------------------------------------------
	John		2004-9-3		porting from RT2500
*/
#include "rt_config.h"

UCHAR	CipherWpaTemplate[] = {
		0xdd, 					// WPA IE
		0x16,					// Length
		0x00, 0x50, 0xf2, 0x01,	// oui
		0x01, 0x00,				// Version
		0x00, 0x50, 0xf2, 0x02,	// Multicast
		0x01, 0x00,				// Number of unicast
		0x00, 0x50, 0xf2, 0x02,	// unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x50, 0xf2, 0x01	// authentication
		};

UCHAR	CipherWpa2Template[] = {
		0x30,					// RSN IE
		0x14,					// Length
		0x01, 0x00,				// Version
		0x00, 0x0f, 0xac, 0x02,	// group cipher, TKIP
		0x01, 0x00,				// number of pairwise
		0x00, 0x0f, 0xac, 0x02,	// unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x0f, 0xac, 0x02,	// authentication
		0x00, 0x00,				// RSN capability
		};

UCHAR	Ccx2IeInfo[] = { 0x00, 0x40, 0x96, 0x03, 0x02};
/*
	==========================================================================
	Description:
		association state machine init, including state transition and timer init
	Parameters:
		S - pointer to the association state machine

	IRQL = PASSIVE_LEVEL

	==========================================================================
 */
VOID AssocStateMachineInit(
	IN	PRTMP_ADAPTER		pAd,
	IN	STATE_MACHINE		*S,
	OUT	STATE_MACHINE_FUNC	Trans[])
{
	StateMachineInit(S, Trans, MAX_ASSOC_STATE, MAX_ASSOC_MSG, (STATE_MACHINE_FUNC)Drop, ASSOC_IDLE, ASSOC_MACHINE_BASE);

	// first column
	StateMachineSetAction(S, ASSOC_IDLE, MT2_MLME_ASSOC_REQ, (STATE_MACHINE_FUNC)MlmeAssocReqAction);
	StateMachineSetAction(S, ASSOC_IDLE, MT2_MLME_REASSOC_REQ, (STATE_MACHINE_FUNC)MlmeReassocReqAction);
	StateMachineSetAction(S, ASSOC_IDLE, MT2_MLME_DISASSOC_REQ, (STATE_MACHINE_FUNC)MlmeDisassocReqAction);
	StateMachineSetAction(S, ASSOC_IDLE, MT2_PEER_DISASSOC_REQ, (STATE_MACHINE_FUNC)PeerDisassocAction);

	// second column
	StateMachineSetAction(S, ASSOC_WAIT_RSP, MT2_MLME_ASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenAssoc);
	StateMachineSetAction(S, ASSOC_WAIT_RSP, MT2_MLME_REASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenReassoc);
	StateMachineSetAction(S, ASSOC_WAIT_RSP, MT2_MLME_DISASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenDisassociate);
	StateMachineSetAction(S, ASSOC_WAIT_RSP, MT2_PEER_DISASSOC_REQ, (STATE_MACHINE_FUNC)PeerDisassocAction);
	StateMachineSetAction(S, ASSOC_WAIT_RSP, MT2_PEER_ASSOC_RSP, (STATE_MACHINE_FUNC)PeerAssocRspAction);
	StateMachineSetAction(S, ASSOC_WAIT_RSP, MT2_ASSOC_TIMEOUT, (STATE_MACHINE_FUNC)AssocTimeoutAction);

	// third column
	StateMachineSetAction(S, REASSOC_WAIT_RSP, MT2_MLME_ASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenAssoc);
	StateMachineSetAction(S, REASSOC_WAIT_RSP, MT2_MLME_REASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenReassoc);
	StateMachineSetAction(S, REASSOC_WAIT_RSP, MT2_MLME_DISASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenDisassociate);
	StateMachineSetAction(S, REASSOC_WAIT_RSP, MT2_PEER_DISASSOC_REQ, (STATE_MACHINE_FUNC)PeerDisassocAction);
	StateMachineSetAction(S, REASSOC_WAIT_RSP, MT2_PEER_REASSOC_RSP, (STATE_MACHINE_FUNC)PeerReassocRspAction);
	StateMachineSetAction(S, REASSOC_WAIT_RSP, MT2_REASSOC_TIMEOUT, (STATE_MACHINE_FUNC)ReassocTimeoutAction);

	// fourth column
	StateMachineSetAction(S, DISASSOC_WAIT_RSP, MT2_MLME_ASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenAssoc);
	StateMachineSetAction(S, DISASSOC_WAIT_RSP, MT2_MLME_REASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenReassoc);
	StateMachineSetAction(S, DISASSOC_WAIT_RSP, MT2_MLME_DISASSOC_REQ, (STATE_MACHINE_FUNC)InvalidStateWhenDisassociate);
	StateMachineSetAction(S, DISASSOC_WAIT_RSP, MT2_PEER_DISASSOC_REQ, (STATE_MACHINE_FUNC)PeerDisassocAction);
	StateMachineSetAction(S, DISASSOC_WAIT_RSP, MT2_DISASSOC_TIMEOUT, (STATE_MACHINE_FUNC)DisassocTimeoutAction);

	// initialize the timer
	RTMPInitTimer(pAd, &pAd->MlmeAux.AssocTimer, GET_TIMER_FUNCTION(AssocTimeout), pAd, FALSE);
	RTMPInitTimer(pAd, &pAd->MlmeAux.ReassocTimer, GET_TIMER_FUNCTION(ReassocTimeout), pAd, FALSE);
	RTMPInitTimer(pAd, &pAd->MlmeAux.DisassocTimer, GET_TIMER_FUNCTION(DisassocTimeout), pAd, FALSE);
}

/*
	==========================================================================
	Description:
		Association timeout procedure. After association timeout, this function
		will be called and it will put a message into the MLME queue
	Parameters:
		Standard timer parameters

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID AssocTimeout(
	IN	PVOID	SystemSpecific1,
	IN	PVOID	FunctionContext,
	IN	PVOID	SystemSpecific2,
	IN	PVOID	SystemSpecific3)
{
	RTMP_ADAPTER *pAd = (RTMP_ADAPTER *)FunctionContext;

	DBGPRINT(RT_DEBUG_INFO,("ASSOC - enqueue MT2_ASSOC_TIMEOUT \n"));

	// Do nothing if the driver is starting halt state.
	// This might happen when timer already been fired before cancel timer with mlmehalt
	if (RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS))
		return;

	pAd->BbpTuning.R17LowerUpperSelect = !pAd->BbpTuning.R17LowerUpperSelect;

	MlmeEnqueue(pAd, ASSOC_STATE_MACHINE, MT2_ASSOC_TIMEOUT, 0, NULL);
#ifdef WIN_NDIS
	KeSetEvent(&pAd->MLMEEvent, 0, FALSE);
#else
	RTUSBMlmeUp(pAd);
#endif
}

/*
	==========================================================================
	Description:
		Reassociation timeout procedure. After reassociation timeout, this
		function will be called and put a message into the MLME queue
	Parameters:
		Standard timer parameters

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID ReassocTimeout(
	IN	PVOID	SystemSpecific1,
	IN	PVOID	FunctionContext,
	IN	PVOID	SystemSpecific2,
	IN	PVOID	SystemSpecific3)
{
	RTMP_ADAPTER *pAd = (RTMP_ADAPTER *)FunctionContext;

	DBGPRINT(RT_DEBUG_INFO,("ASSOC - enqueue MT2_REASSOC_TIMEOUT \n"));

	// Do nothing if the driver is starting halt state.
	// This might happen when timer already been fired before cancel timer with mlmehalt
	if (RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS))
		return;

	pAd->BbpTuning.R17LowerUpperSelect = !pAd->BbpTuning.R17LowerUpperSelect;

	MlmeEnqueue(pAd, ASSOC_STATE_MACHINE, MT2_REASSOC_TIMEOUT, 0, NULL);
#ifdef WIN_NDIS
	KeSetEvent(&pAd->MLMEEvent, 0, FALSE);
#else
	RTUSBMlmeUp(pAd);
#endif
}

/*
	==========================================================================
	Description:
		Disassociation timeout procedure. After disassociation timeout, this
		function will be called and put a message into the MLME queue
	Parameters:
		Standard timer parameters

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID DisassocTimeout(
	IN	PVOID	SystemSpecific1,
	IN	PVOID	FunctionContext,
	IN	PVOID	SystemSpecific2,
	IN	PVOID	SystemSpecific3)
{
	RTMP_ADAPTER *pAd = (RTMP_ADAPTER *)FunctionContext;

	DBGPRINT(RT_DEBUG_INFO,("ASSOC - enqueue MT2_DISASSOC_TIMEOUT \n"));

	// Do nothing if the driver is starting halt state.
	// This might happen when timer already been fired before cancel timer with mlmehalt
	if (RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS))
		return;

	MlmeEnqueue(pAd, ASSOC_STATE_MACHINE, MT2_DISASSOC_TIMEOUT, 0, NULL);
#ifdef WIN_NDIS
	KeSetEvent(&pAd->MLMEEvent, 0, FALSE);
#else
	RTUSBMlmeUp(pAd);
#endif
	
}

/*
	==========================================================================
	Description:
		mlme assoc req handling procedure
	Parameters:
		Adapter - Adapter pointer
		Elem - MLME Queue Element
	Pre:
		the station has been authenticated and the following information is stored in the config
			-# SSID
			-# supported rates and their length
			-# listen interval (Adapter->StaCfg.default_listen_count)
			-# Transmit power  (Adapter->StaCfg.tx_power)
	Post  :
		-# An association request frame is generated and sent to the air
		-# Association timer starts
		-# Association state -> ASSOC_WAIT_RSP

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID MlmeAssocReqAction(
	IN	PRTMP_ADAPTER		pAd,
	IN	MLME_QUEUE_ELEM		*Elem)
{
	UCHAR			ApAddr[6];
	HEADER_802_11	AssocHdr;
	UCHAR			Ccx2Len = 5;
	UCHAR			WmeIe[9] = {IE_VENDOR_SPECIFIC, 0x07, 0x00, 0x50, 0xf2, 0x02, 0x00, 0x01, STA_QOS_CAPABILITY};
	UCHAR			CipherTmp[64];
	UCHAR			CipherTmpLen;
	USHORT			ListenIntv;
	ULONG			Timeout;
	USHORT			CapabilityInfo;
	BOOLEAN			TimerCancelled;
	PUCHAR			pOutBuffer = NULL;
	NDIS_STATUS		NStatus;
	ULONG			FrameLen = 0;
	ULONG			tmp, idx;
	BOOLEAN			FoundPMK = FALSE;
	UCHAR			VarIesOffset;
	UCHAR			CkipFlag;
	UCHAR			CkipNegotiationBuffer[CKIP_NEGOTIATION_LENGTH];
	UCHAR			AironetCkipIe = IE_AIRONET_CKIP;
	UCHAR			AironetCkipLen = CKIP_NEGOTIATION_LENGTH;
	UCHAR			AironetIPAddressIE = IE_AIRONET_IPADDRESS;
	UCHAR			AironetIPAddressLen = AIRONET_IPADDRESS_LENGTH;
	UCHAR			AironetIPAddressBuffer[AIRONET_IPADDRESS_LENGTH] = {0x00, 0x40, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00};
	USHORT			Status;

	// Block all authentication request durning WPA block period
	if (pAd->StaCfg.bBlockAssoc == TRUE)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - Block Assoc request durning WPA block period!\n"));
		pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
		Status = MLME_STATE_MACHINE_REJECT;
		MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_ASSOC_CONF, 2, &Status);
	}
	// check sanity first
	else if (MlmeAssocReqSanity(pAd, Elem->Msg, Elem->MsgLen, ApAddr, &CapabilityInfo, &Timeout, &ListenIntv))
	{
		RTMPCancelTimer(&pAd->MlmeAux.AssocTimer, &TimerCancelled);
		COPY_MAC_ADDR(pAd->MlmeAux.Bssid, ApAddr);

		NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  //Get an unused nonpaged memory
		if (NStatus != NDIS_STATUS_SUCCESS)
		{
			DBGPRINT(RT_DEBUG_TRACE,("ASSOC - MlmeAssocReqAction() allocate memory failed \n"));
			pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
			Status = MLME_FAIL_NO_RESOURCE;
			MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_ASSOC_CONF, 2, &Status);
			return;
		}

		// Add by James 03/06/27
		pAd->StaCfg.AssocInfo.Length = sizeof(NDIS_802_11_ASSOCIATION_INFORMATION);
		// Association don't need to report MAC address
		pAd->StaCfg.AssocInfo.AvailableRequestFixedIEs =
			NDIS_802_11_AI_REQFI_CAPABILITIES | NDIS_802_11_AI_REQFI_LISTENINTERVAL;
		pAd->StaCfg.AssocInfo.RequestFixedIEs.Capabilities = CapabilityInfo;
		pAd->StaCfg.AssocInfo.RequestFixedIEs.ListenInterval = ListenIntv;
		// Only reassociate need this
		//COPY_MAC_ADDR(pAd->StaCfg.AssocInfo.RequestFixedIEs.CurrentAPAddress, ApAddr);
		pAd->StaCfg.AssocInfo.OffsetRequestIEs = sizeof(NDIS_802_11_ASSOCIATION_INFORMATION);

		// First add SSID
		VarIesOffset = 0;
		NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, &SsidIe, 1);
		VarIesOffset += 1;
		NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, &pAd->MlmeAux.SsidLen, 1);
		VarIesOffset += 1;
		NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, pAd->MlmeAux.Ssid, pAd->MlmeAux.SsidLen);
		VarIesOffset += pAd->MlmeAux.SsidLen;

		// Second add Supported rates
		NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, &SupRateIe, 1);
		VarIesOffset += 1;
		NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, &pAd->MlmeAux.SupRateLen, 1);
		VarIesOffset += 1;
		NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, pAd->MlmeAux.SupRate, pAd->MlmeAux.SupRateLen);
		VarIesOffset += pAd->MlmeAux.SupRateLen;
		// End Add by James

		DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - Send ASSOC request...\n"));
		MgtMacHeaderInit(pAd, &AssocHdr, SUBTYPE_ASSOC_REQ, 0, ApAddr, ApAddr);

		// Build basic frame first
		MakeOutgoingFrame(pOutBuffer,				&FrameLen,
						  sizeof(HEADER_802_11),	&AssocHdr,
						  2,						&CapabilityInfo,
						  2,						&ListenIntv,
						  1,						&SsidIe,
						  1,						&pAd->MlmeAux.SsidLen,
						  pAd->MlmeAux.SsidLen, 	pAd->MlmeAux.Ssid,
						  1,						&SupRateIe,
						  1,						&pAd->MlmeAux.SupRateLen,
						  pAd->MlmeAux.SupRateLen,  pAd->MlmeAux.SupRate,
						  END_OF_ARGS);

		if (pAd->MlmeAux.ExtRateLen != 0)
		{
			MakeOutgoingFrame(pOutBuffer + FrameLen,		&tmp,
								1,							&ExtRateIe,
								1,							&pAd->MlmeAux.ExtRateLen,
								pAd->MlmeAux.ExtRateLen,	pAd->MlmeAux.ExtRate,
								END_OF_ARGS);
			FrameLen += tmp;
		}

		if (pAd->MlmeAux.APEdcaParm.bValid)
		{
			if (pAd->CommonCfg.bAPSDCapable && pAd->MlmeAux.APEdcaParm.bAPSDCapable)
			{
				QBSS_STA_INFO_PARM QosInfo;

				NdisZeroMemory(&QosInfo, sizeof(QBSS_STA_INFO_PARM));
				QosInfo.UAPSD_AC_BE = pAd->CommonCfg.bAPSDAC_BE;
				QosInfo.UAPSD_AC_BK = pAd->CommonCfg.bAPSDAC_BK;
				QosInfo.UAPSD_AC_VI = pAd->CommonCfg.bAPSDAC_VI;
				QosInfo.UAPSD_AC_VO = pAd->CommonCfg.bAPSDAC_VO;
				QosInfo.MaxSPLength = pAd->CommonCfg.MaxSPLength;
				WmeIe[8] |= *(PUCHAR)&QosInfo;
			}
			else
			{
				// The Parameter Set Count is set to 0 in the association request frames
				// WmeIe[8] |= (pAd->MlmeAux.APEdcaParm.EdcaUpdateCount & 0x0f);
			}

			MakeOutgoingFrame(pOutBuffer + FrameLen,		&tmp,
								9,							&WmeIe[0],
								END_OF_ARGS);
			FrameLen += tmp;
		}

		if ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA) ||
			(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPAPSK))
		{
			// Copy WPA template to buffer
			CipherTmpLen = sizeof(CipherWpaTemplate);
			NdisMoveMemory(CipherTmp, CipherWpaTemplate, CipherTmpLen);

			// Modify Group cipher, WPA+WEP mixed mode is possible
			switch (pAd->CommonCfg.GroupCipher)
			{
				case 1:  // WEP-40
					CipherTmp[11] = 0x01;
					break;
				case 5:  // WEP-104
					CipherTmp[11] = 0x05;
					break;
				default: // TKIP, otherwise AES
					CipherTmp[11] = ((pAd->CommonCfg.GroupCipher == Ndis802_11Encryption2Enabled) ? 0x2 : 0x4);
					break;
			}

			// Modify Pairwise cipher
			CipherTmp[17] = ((pAd->CommonCfg.PairCipher == Ndis802_11Encryption2Enabled) ? 0x2 : 0x4);
			// Modify AKM
			CipherTmp[23] = ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA) ? 0x1 : 0x2);
			// Make outgoing frame
			MakeOutgoingFrame(pOutBuffer + FrameLen,	&tmp,
								CipherTmpLen,			&CipherTmp[0],
								END_OF_ARGS);
			FrameLen += tmp;

			// Append Variable IE
			NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, CipherTmp, CipherTmpLen);
			VarIesOffset += CipherTmpLen;

			// Set Variable IEs Length
			pAd->StaCfg.ReqVarIELen = VarIesOffset;
			pAd->StaCfg.AssocInfo.RequestIELength = VarIesOffset;
			// OffsetResponseIEs follow ReqVarIE
			pAd->StaCfg.AssocInfo.OffsetResponseIEs = sizeof(NDIS_802_11_ASSOCIATION_INFORMATION) + pAd->StaCfg.ReqVarIELen;
		}
		// For WPA2 / WPA2-PSK
		else if ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2) ||
				 (pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2PSK))
		{
			// Copy WPA2 template to buffer
			CipherTmpLen = sizeof(CipherWpa2Template);
			NdisMoveMemory(CipherTmp, CipherWpa2Template, CipherTmpLen);
			// Modify Group cipher
			CipherTmp[7] = ((pAd->CommonCfg.GroupCipher == Ndis802_11Encryption2Enabled) ? 0x2 : 0x4);
			// Modify Pairwise cipher
			CipherTmp[13] = ((pAd->CommonCfg.PairCipher == Ndis802_11Encryption2Enabled) ? 0x2 : 0x4);
			// Modify AKM
			CipherTmp[19] = ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2) ? 0x1 : 0x2);
			// Check for WPA PMK cache list
			if (pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2)
			{
				// Search chched PMKID, append it if existed
				for (idx = 0; idx < PMKID_NO; idx++)
				{
					if (NdisEqualMemory(ApAddr, &pAd->StaCfg.SavedPMK[idx].BSSID, 6))
					{
						FoundPMK = TRUE;
						break;
					}
				}

				if (FoundPMK)
				{
					// Update length within RSN IE
					CipherTmp[1] += 18;
					// Set PMK number
					*(PUSHORT) &CipherTmp[CipherTmpLen] = 1;
					NdisMoveMemory(&CipherTmp[CipherTmpLen + 2], &pAd->StaCfg.SavedPMK[idx].PMKID, 16);
					CipherTmpLen += 18;
				}
			}

			// Make outgoing frame
			MakeOutgoingFrame(pOutBuffer + FrameLen,    &tmp,
							  CipherTmpLen,			&CipherTmp[0],
							  END_OF_ARGS);
			FrameLen += tmp;

			// Append Variable IE
			NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, CipherTmp, CipherTmpLen);
			VarIesOffset += CipherTmpLen;

			// Set Variable IEs Length
			pAd->StaCfg.ReqVarIELen = VarIesOffset;
			pAd->StaCfg.AssocInfo.RequestIELength = VarIesOffset;
			// OffsetResponseIEs follow ReqVarIE
			pAd->StaCfg.AssocInfo.OffsetResponseIEs = sizeof(NDIS_802_11_ASSOCIATION_INFORMATION) + pAd->StaCfg.ReqVarIELen;
		}
		else
		{
			// Do nothing
			;
		}

#if 1
		// add Ralink proprietary IE to inform AP this STA is going to use AGGREGATION, only when -
		// 1. user enable aggregation, AND
		// 2. AP annouces it's AGGREGATION-capable in BEACON
		if (pAd->CommonCfg.bAggregationCapable && (pAd->MlmeAux.APRalinkIe & 0x00000001))
		{
			ULONG TmpLen;
			UCHAR RalinkIe[9] = {IE_VENDOR_SPECIFIC, 7, 0x00, 0x0c, 0x43, 0x01, 0x00, 0x00, 0x00};
			MakeOutgoingFrame(pOutBuffer+FrameLen,           &TmpLen,
								9,                             RalinkIe,
								END_OF_ARGS);
			FrameLen += TmpLen;
		}
#endif
		// We have update that at PeerBeaconAtJoinRequest()
		CkipFlag = pAd->StaCfg.CkipFlag;
		if (CkipFlag != 0)
		{
			NdisZeroMemory(CkipNegotiationBuffer, CKIP_NEGOTIATION_LENGTH);
			CkipNegotiationBuffer[2] = 0x66;
			// Make it try KP & MIC, since we have to follow the result from AssocRsp
			CkipNegotiationBuffer[8] = 0x18;
			CkipNegotiationBuffer[CKIP_NEGOTIATION_LENGTH - 1] = 0x22;
			CkipFlag = 0x18;

			MakeOutgoingFrame(pOutBuffer + FrameLen, 	&tmp,
						1,						  		&AironetCkipIe,
						1,						  		&AironetCkipLen,
						AironetCkipLen, 		  		CkipNegotiationBuffer,
						END_OF_ARGS);
			FrameLen += tmp;
		}

		// Add CCX v2 request if CCX2 admin state is on
		if (pAd->StaCfg.CCX2Control.field.Enable == 1)
		{

			//
			// Add AironetIPAddressIE for Cisco CCX 2.X
			// Add CCX Version
			//
			MakeOutgoingFrame(pOutBuffer + FrameLen, &tmp,
						1,							&AironetIPAddressIE,
						1,							&AironetIPAddressLen,
						AironetIPAddressLen,		AironetIPAddressBuffer,
						1,							&Ccx2Ie,
						1,							&Ccx2Len,
						Ccx2Len,				    Ccx2IeInfo,
						END_OF_ARGS);
			FrameLen += tmp;

			//
			// Add CipherSuite CCKM or LeapTkip if setting.
			//
			if (LEAP_CCKM_ON(pAd))
			{
				//
				// LEAP CCKM WEP Case.
				//
				if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled)
				{
					MakeOutgoingFrame(pOutBuffer + FrameLen,	&tmp,
							CipherSuiteCiscoCCKMLen,		CipherSuiteCiscoCCKM,
							END_OF_ARGS);
					FrameLen += tmp;

					// Third add RSN
					NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, CipherSuiteCiscoCCKM, CipherSuiteCiscoCCKMLen); //Save CipherSuite
					VarIesOffset += CipherSuiteCiscoCCKMLen;
				}
				//
				// LEAP CCKM TKIP Case
				//
				else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
				{
					MakeOutgoingFrame(pOutBuffer + FrameLen,	&tmp,
							CipherSuiteCiscoCCKMTkipLen,		CipherSuiteCiscoCCKMTkip,
							END_OF_ARGS);
					FrameLen += tmp;

					// Third add RSN
					NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, CipherSuiteCiscoCCKMTkip, CipherSuiteCiscoCCKMTkipLen); //Save CipherSuite
					VarIesOffset += CipherSuiteCiscoCCKMTkipLen;
				}
			}
			else if ((pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP) && (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled))
			{
				MakeOutgoingFrame(pOutBuffer + FrameLen, &tmp,
						CipherSuiteCCXTkipLen,	    CipherSuiteCCXTkip,
						END_OF_ARGS);
				FrameLen += tmp;

				// Third add RSN
				NdisMoveMemory(pAd->StaCfg.ReqVarIEs + VarIesOffset, CipherSuiteCCXTkip, CipherSuiteCCXTkipLen);
				VarIesOffset += CipherSuiteCCXTkipLen;
			}

			// Add by James 03/06/27
			// Set Variable IEs Length
			pAd->StaCfg.ReqVarIELen = VarIesOffset;
			pAd->StaCfg.AssocInfo.RequestIELength = VarIesOffset;

			// OffsetResponseIEs follow ReqVarIE
			pAd->StaCfg.AssocInfo.OffsetResponseIEs = sizeof(NDIS_802_11_ASSOCIATION_INFORMATION) + pAd->StaCfg.ReqVarIELen;
			// End Add by James
		}

		MiniportMMRequest(pAd, pOutBuffer, FrameLen);

		RTMPSetTimer(&pAd->MlmeAux.AssocTimer, Timeout);
		pAd->Mlme.AssocMachine.CurrState = ASSOC_WAIT_RSP;
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE,("ASSOC - MlmeAssocReqAction() sanity check failed. BUG!!!!!! \n"));
		pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
		Status = MLME_INVALID_FORMAT;
		MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_ASSOC_CONF, 2, &Status);
	}

}

/*
	==========================================================================
	Description:
		mlme reassoc req handling procedure
	Parameters:
		Elem -
	Pre:
		-# SSID  (Adapter->StaCfg.ssid[])
		-# BSSID (AP address, Adapter->StaCfg.bssid)
		-# Supported rates (Adapter->StaCfg.supported_rates[])
		-# Supported rates length (Adapter->StaCfg.supported_rates_len)
		-# Tx power (Adapter->StaCfg.tx_power)

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID MlmeReassocReqAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem) 
{
	UCHAR           ApAddr[6];
	HEADER_802_11   ReassocHdr;
	UCHAR			Ccx2Len = 5;
	UCHAR           WmeIe[9] = {IE_VENDOR_SPECIFIC, 0x07, 0x00, 0x50, 0xf2, 0x02, 0x00, 0x01, STA_QOS_CAPABILITY};
	USHORT          CapabilityInfo, ListenIntv;
	ULONG           Timeout;
	ULONG           FrameLen = 0;
	BOOLEAN         TimerCancelled;
	NDIS_STATUS     NStatus;
	ULONG			tmp;
	PUCHAR          pOutBuffer = NULL;
	//CCX 2.X
	UCHAR           CkipFlag;
	UCHAR           CkipNegotiationBuffer[CKIP_NEGOTIATION_LENGTH];
	UCHAR           AironetCkipIe = IE_AIRONET_CKIP;
	UCHAR           AironetCkipLen = CKIP_NEGOTIATION_LENGTH;
	UCHAR           AironetIPAddressIE = IE_AIRONET_IPADDRESS;
	UCHAR           AironetIPAddressLen = AIRONET_IPADDRESS_LENGTH;
	UCHAR           AironetIPAddressBuffer[AIRONET_IPADDRESS_LENGTH] = {0x00, 0x40, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00};
	UCHAR           AironetCCKMReassocIE = IE_AIRONET_CCKMREASSOC;
	UCHAR           AironetCCKMReassocLen = AIRONET_CCKMREASSOC_LENGTH;
	UCHAR           AironetCCKMReassocBuffer[AIRONET_CCKMREASSOC_LENGTH];
	UCHAR           AironetOUI[] = {0x00, 0x40, 0x96, 0x00};
	UCHAR           MICMN[16];
	UCHAR           CalcMicBuffer[80];
	ULONG           CalcMicBufferLen = 0;
	USHORT          Status;
	PUCHAR	        pCipherSuite = CipherSuiteCiscoCCKMTkip;
	ULONG	        CipherSuiteLen = 0;

	// Block all authentication request durning WPA block period
	if (pAd->StaCfg.bBlockAssoc == TRUE)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - Block ReAssoc request durning WPA block period!\n"));
		pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
		Status = MLME_STATE_MACHINE_REJECT;
		MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_REASSOC_CONF, 2, &Status);
	}
	// the parameters are the same as the association
	else if(MlmeAssocReqSanity(pAd, Elem->Msg, Elem->MsgLen, ApAddr, &CapabilityInfo, &Timeout, &ListenIntv))
	{
		RTMPCancelTimer(&pAd->MlmeAux.ReassocTimer, &TimerCancelled);

		NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  //Get an unused nonpaged memory
		if(NStatus != NDIS_STATUS_SUCCESS)
		{
			DBGPRINT(RT_DEBUG_TRACE,("ASSOC - MlmeReassocReqAction() allocate memory failed \n"));
			pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
			Status = MLME_FAIL_NO_RESOURCE;
			MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_REASSOC_CONF, 2, &Status);
			return;
		}

		COPY_MAC_ADDR(pAd->MlmeAux.Bssid, ApAddr);

		// make frame, use bssid as the AP address??
		DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - Send RE-ASSOC request...\n"));
		MgtMacHeaderInit(pAd, &ReassocHdr, SUBTYPE_REASSOC_REQ, 0, ApAddr, ApAddr);
		MakeOutgoingFrame(pOutBuffer,               &FrameLen,
						sizeof(HEADER_802_11),    &ReassocHdr,
						2,                        &CapabilityInfo,
						2,                        &ListenIntv,
						MAC_ADDR_LEN,             ApAddr,
						1,                        &SsidIe,
						1,                        &pAd->MlmeAux.SsidLen,
						pAd->MlmeAux.SsidLen,     pAd->MlmeAux.Ssid,
						1,                        &SupRateIe,
						1,						&pAd->MlmeAux.SupRateLen,
						pAd->MlmeAux.SupRateLen,  pAd->MlmeAux.SupRate,
						END_OF_ARGS);

		if (pAd->MlmeAux.ExtRateLen != 0)
		{
			MakeOutgoingFrame(pOutBuffer + FrameLen,        &tmp,
							1,                            &ExtRateIe,
							1,                            &pAd->MlmeAux.ExtRateLen,
							pAd->MlmeAux.ExtRateLen,	    pAd->MlmeAux.ExtRate,
							END_OF_ARGS);
			FrameLen += tmp;
		}

		if (pAd->MlmeAux.APEdcaParm.bValid)
		{
			if (pAd->CommonCfg.bAPSDCapable && pAd->MlmeAux.APEdcaParm.bAPSDCapable)
			{
				QBSS_STA_INFO_PARM QosInfo;

				NdisZeroMemory(&QosInfo, sizeof(QBSS_STA_INFO_PARM));
				QosInfo.UAPSD_AC_BE = pAd->CommonCfg.bAPSDAC_BE;
				QosInfo.UAPSD_AC_BK = pAd->CommonCfg.bAPSDAC_BK;
				QosInfo.UAPSD_AC_VI = pAd->CommonCfg.bAPSDAC_VI;
				QosInfo.UAPSD_AC_VO = pAd->CommonCfg.bAPSDAC_VO;
				QosInfo.MaxSPLength = pAd->CommonCfg.MaxSPLength;
				WmeIe[8] |= *(PUCHAR)&QosInfo;
			}
			else
			{
				// The Parameter Set Count is set to 0 in the association request frames
				// WmeIe[8] |= (pAd->MlmeAux.APEdcaParm.EdcaUpdateCount & 0x0f);
			}

			MakeOutgoingFrame(pOutBuffer + FrameLen,    &tmp,
							9,                        &WmeIe[0],
							END_OF_ARGS);
			FrameLen += tmp;
		}

#if 1
		// add Ralink proprietary IE to inform AP this STA is going to use AGGREGATION, only when -
		// 1. user enable aggregation, AND
		// 2. AP annouces it's AGGREGATION-capable in BEACON
		if (pAd->CommonCfg.bAggregationCapable && (pAd->MlmeAux.APRalinkIe & 0x00000001))
		{
			ULONG TmpLen;
			UCHAR RalinkIe[9] = {IE_VENDOR_SPECIFIC, 7, 0x00, 0x0c, 0x43, 0x01, 0x00, 0x00, 0x00};
			MakeOutgoingFrame(pOutBuffer+FrameLen,           &TmpLen,
							9,                             RalinkIe,
							END_OF_ARGS);
			FrameLen += TmpLen;
		}
#endif
		if (LEAP_CCKM_ON(pAd) && (pAd->StaCfg.CCKMLinkUpFlag == TRUE))
		{
			CkipFlag = pAd->StaCfg.CkipFlag;	// We have update that at PeerBeaconAtJoinRequest()
			if (CkipFlag != 0)
			{
				NdisZeroMemory(CkipNegotiationBuffer, CKIP_NEGOTIATION_LENGTH);
				CkipNegotiationBuffer[2] = 0x66;
				// Make it try KP & MIC, since we have to follow the result from AssocRsp
				CkipNegotiationBuffer[8] = 0x18;
				CkipNegotiationBuffer[CKIP_NEGOTIATION_LENGTH - 1] = 0x22;

				MakeOutgoingFrame(pOutBuffer + FrameLen,            &tmp,
								1,                              &AironetCkipIe,
								1,                              &AironetCkipLen,
								AironetCkipLen,                 CkipNegotiationBuffer,
								END_OF_ARGS);
				FrameLen += tmp;
			}

			MakeOutgoingFrame(pOutBuffer + FrameLen, &tmp,
							1,                              &AironetIPAddressIE,
							1,                              &AironetIPAddressLen,
							AironetIPAddressLen,            AironetIPAddressBuffer,
							END_OF_ARGS);
			FrameLen += tmp;

			//
			// The RN is incremented before each reassociation request.
			//
			pAd->StaCfg.CCKMRN++;
			//
			// Calculate MIC = hmac-md5(krk, STA-ID|BSSID|RSNIE|TSF|RN);
			//
			COPY_MAC_ADDR(CalcMicBuffer, pAd->CurrentAddress);
			CalcMicBufferLen = MAC_ADDR_LEN;
			COPY_MAC_ADDR(CalcMicBuffer + CalcMicBufferLen, pAd->MlmeAux.Bssid);

			CalcMicBufferLen += MAC_ADDR_LEN;
			//
			// Build up CCKM associate info.
			//
			if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled)
			{
				NdisMoveMemory(CalcMicBuffer + CalcMicBufferLen, CipherSuiteCiscoCCKM, CipherSuiteCiscoCCKMLen);
				CalcMicBufferLen += CipherSuiteCiscoCCKMLen;
				CipherSuiteLen = CipherSuiteCiscoCCKMLen;
				pCipherSuite = CipherSuiteCiscoCCKM;
			}
			else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
			{
				NdisMoveMemory(CalcMicBuffer + CalcMicBufferLen, CipherSuiteCiscoCCKMTkip, CipherSuiteCiscoCCKMTkipLen);
				CalcMicBufferLen += CipherSuiteCiscoCCKMTkipLen;
				CipherSuiteLen = CipherSuiteCiscoCCKMTkipLen;
				pCipherSuite = CipherSuiteCiscoCCKMTkip;
			}

			NdisMoveMemory(CalcMicBuffer + CalcMicBufferLen, (PUCHAR) &pAd->StaCfg.CCKMBeaconAtJoinTimeStamp, sizeof(pAd->StaCfg.CCKMBeaconAtJoinTimeStamp));
			CalcMicBufferLen += sizeof(pAd->StaCfg.CCKMBeaconAtJoinTimeStamp);
			NdisMoveMemory(CalcMicBuffer + CalcMicBufferLen, (PUCHAR)&pAd->StaCfg.CCKMRN, sizeof(pAd->StaCfg.CCKMRN));
			CalcMicBufferLen += sizeof(pAd->StaCfg.CCKMRN);
			hmac_md5(pAd->StaCfg.KRK, LEN_EAP_MICK, CalcMicBuffer, CalcMicBufferLen, MICMN);

			//
			// fill up CCKM reassociation request element
			//
			NdisMoveMemory(AironetCCKMReassocBuffer, AironetOUI, 4);
			NdisMoveMemory(AironetCCKMReassocBuffer + 4, (PUCHAR)&pAd->StaCfg.CCKMBeaconAtJoinTimeStamp, 8);
			NdisMoveMemory(AironetCCKMReassocBuffer + 12, (PUCHAR) &pAd->StaCfg.CCKMRN, 4);
			NdisMoveMemory(AironetCCKMReassocBuffer +16, MICMN, 8);

			MakeOutgoingFrame(pOutBuffer + FrameLen, &tmp,
							1,                      &AironetCCKMReassocIE,
							1,                      &AironetCCKMReassocLen,
							AironetCCKMReassocLen,  AironetCCKMReassocBuffer,
							END_OF_ARGS);
			FrameLen += tmp;

			MakeOutgoingFrame(pOutBuffer + FrameLen, &tmp,
							CipherSuiteLen,pCipherSuite,
							END_OF_ARGS);
			FrameLen += tmp;
}

		// Add CCX v2 request if CCX2 admin state is on
		if (pAd->StaCfg.CCX2Control.field.Enable == 1)
		{
			//
			// Add CCX Version
			//
			MakeOutgoingFrame(pOutBuffer + FrameLen, &tmp,
						1,							&Ccx2Ie,
						1,							&Ccx2Len,
						Ccx2Len,				    Ccx2IeInfo,
						END_OF_ARGS);
			FrameLen += tmp;
		}

		MiniportMMRequest(pAd, pOutBuffer, FrameLen);

		RTMPSetTimer(&pAd->MlmeAux.ReassocTimer, Timeout); /* in mSec */
		pAd->Mlme.AssocMachine.CurrState = REASSOC_WAIT_RSP;
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE,("ASSOC - MlmeReassocReqAction() sanity check failed. BUG!!!! \n"));
		pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
		Status = MLME_INVALID_FORMAT;
		MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_REASSOC_CONF, 2, &Status);
	}
}

/*
	==========================================================================
	Description:
		Upper layer issues disassoc request
	Parameters:
		Elem -

	IRQL = PASSIVE_LEVEL

	==========================================================================
 */
VOID MlmeDisassocReqAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	PMLME_DISASSOC_REQ_STRUCT pDisassocReq;
	HEADER_802_11         DisassocHdr;
	PCHAR                 pOutBuffer = NULL;
	ULONG                 FrameLen = 0;
	NDIS_STATUS           NStatus;
	BOOLEAN               TimerCancelled;
	ULONG                 i, Timeout = 0;
	USHORT                Status;

	// send DLS-TEAR_DOWN message,
	if (pAd->CommonCfg.bDLSCapable)
	{
		// tear down local dls table entry
		for (i=0; i<MAX_NUM_OF_INIT_DLS_ENTRY; i++)
		{
			if (pAd->StaCfg.DLSEntry[i].Valid && (pAd->StaCfg.DLSEntry[i].Status == DLS_FINISH))
			{
				pAd->StaCfg.DLSEntry[i].Status	= DLS_NONE;
				pAd->StaCfg.DLSEntry[i].Valid	= FALSE;
				RTMPSendDLSTearDownFrame(pAd, pAd->StaCfg.DLSEntry[i].MacAddr);
			}
		}

		// tear down peer dls table entry
		for (i=MAX_NUM_OF_INIT_DLS_ENTRY; i<MAX_NUM_OF_DLS_ENTRY; i++)
		{
			if (pAd->StaCfg.DLSEntry[i].Valid && (pAd->StaCfg.DLSEntry[i].Status == DLS_FINISH))
			{
				pAd->StaCfg.DLSEntry[i].Status = DLS_NONE;
				pAd->StaCfg.DLSEntry[i].Valid	= FALSE;
				RTMPSendDLSTearDownFrame(pAd, pAd->StaCfg.DLSEntry[i].MacAddr);
			}
		}
	}

	// skip sanity check
	pDisassocReq = (PMLME_DISASSOC_REQ_STRUCT)(Elem->Msg);

	NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  //Get an unused nonpaged memory
	if (NStatus != NDIS_STATUS_SUCCESS)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - MlmeDisassocReqAction() allocate memory failed\n"));
		pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
		Status = MLME_FAIL_NO_RESOURCE;
		MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_DISASSOC_CONF, 2, &Status);
		return;
	}

	RTMPCancelTimer(&pAd->MlmeAux.DisassocTimer, &TimerCancelled);

	DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - Send DISASSOC request[BSSID::%02x:%02x:%02x:%02x:%02x:%02x\n",
				pDisassocReq->Addr[0], pDisassocReq->Addr[1], pDisassocReq->Addr[2],
				pDisassocReq->Addr[3], pDisassocReq->Addr[4], pDisassocReq->Addr[5]));
	MgtMacHeaderInit(pAd, &DisassocHdr, SUBTYPE_DISASSOC, 0, pDisassocReq->Addr, pDisassocReq->Addr);
	MakeOutgoingFrame(pOutBuffer,           &FrameLen,
					sizeof(HEADER_802_11),&DisassocHdr,
					2,                    &pDisassocReq->Reason,
					END_OF_ARGS);
	MiniportMMRequest(pAd, pOutBuffer, FrameLen);

	// Set the control aux SSID to prevent it reconnect to old SSID
	// Since calling this indicate user don't want to connect to that SSID anymore.
	// 2004-11-10 can't reset this info, cause it may be the new SSID that user requests for
	// pAd->MlmeAux.SsidLen = MAX_LEN_OF_SSID;
	// NdisZeroMemory(pAd->MlmeAux.Ssid, MAX_LEN_OF_SSID);
	// NdisZeroMemory(pAd->MlmeAux.Bssid, MAC_ADDR_LEN);

	pAd->StaCfg.DisassocReason = REASON_DISASSOC_STA_LEAVING;
	COPY_MAC_ADDR(pAd->StaCfg.DisassocSta, pDisassocReq->Addr);

	RTMPSetTimer(&pAd->MlmeAux.DisassocTimer, Timeout); /* in mSec */
	pAd->Mlme.AssocMachine.CurrState = DISASSOC_WAIT_RSP;
}

/*
	==========================================================================
	Description:
		peer sends assoc rsp back
	Parameters:
		Elme - MLME message containing the received frame

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID PeerAssocRspAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	USHORT        CapabilityInfo, Status, Aid;
	UCHAR         SupRate[MAX_LEN_OF_SUPPORTED_RATES], SupRateLen;
	UCHAR         ExtRate[MAX_LEN_OF_SUPPORTED_RATES], ExtRateLen;
	UCHAR         Addr2[MAC_ADDR_LEN];
	BOOLEAN       TimerCancelled;
	UCHAR         CkipFlag;
	EDCA_PARM     EdcaParm;

	if (PeerAssocRspSanity(pAd, Elem->Msg, Elem->MsgLen, Addr2, &CapabilityInfo, &Status, &Aid, SupRate, &SupRateLen, ExtRate, &ExtRateLen, &EdcaParm, &CkipFlag))
	{
		// The frame is for me ?
		if(MAC_ADDR_EQUAL(Addr2, pAd->MlmeAux.Bssid))
		{
			DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - receive ASSOC_RSP to me (status=%d)\n", Status));
			RTMPCancelTimer(&pAd->MlmeAux.AssocTimer, &TimerCancelled);
			if(Status == MLME_SUCCESS)
			{
				//
				// There may some packets will be drop, if we haven't set the BSS type!
				// For example: EAPOL packet and the case of WHQL lost Packets.
				// Since this may some delays to set those variables at LinkUp(..) on this (Mlme) thread.
				//
				// This is a trick, set the BSS type here.
				//
				if (pAd->StaCfg.BssType == BSS_INFRA)
				{
					OPSTATUS_SET_FLAG(pAd, fOP_STATUS_MEDIA_STATE_CONNECTED);
				}

				// go to procedure listed on page 376
				AssocPostProc(pAd, Addr2, CapabilityInfo, Aid, SupRate, SupRateLen, ExtRate, ExtRateLen, &EdcaParm);

				pAd->StaCfg.CkipFlag = CkipFlag;
				if (CkipFlag & 0x18)
				{
					NdisZeroMemory(pAd->StaCfg.TxSEQ, 4);
					NdisZeroMemory(pAd->StaCfg.RxSEQ, 4);
					NdisZeroMemory(pAd->StaCfg.CKIPMIC, 4);
					pAd->StaCfg.GIV[0] = RandomByte(pAd);
					pAd->StaCfg.GIV[1] = RandomByte(pAd);
					pAd->StaCfg.GIV[2] = RandomByte(pAd);
					pAd->StaCfg.bCkipCmicOn = TRUE;
					DBGPRINT(RT_DEBUG_TRACE, ("<CCX> pAd->StaCfg.CkipFlag = 0x%02x\n", pAd->StaCfg.CkipFlag));
				}
			}
			else
			{
				// Faile on Association, we need to check the status code
				// Is that a Rogue AP?
				if ((pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP) && (Status == MLME_ALG_NOT_SUPPORT))
				{ //Possibly Rogue AP
					RogueApTableSetEntry(pAd, &pAd->StaCfg.RogueApTab, pAd->MlmeAux.Bssid, LEAP_REASON_INVALID_AUTH);
				}

			}
			pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
			MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_ASSOC_CONF, 2, &Status);
		}
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - PeerAssocRspAction() sanity check fail\n"));
	}
}

/*
	==========================================================================
	Description:
		peer sends reassoc rsp
	Parametrs:
		Elem - MLME message cntaining the received frame

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID PeerReassocRspAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	USHORT      CapabilityInfo;
	USHORT      Status;
	USHORT      Aid;
	UCHAR       SupRate[MAX_LEN_OF_SUPPORTED_RATES], SupRateLen;
	UCHAR       ExtRate[MAX_LEN_OF_SUPPORTED_RATES], ExtRateLen;
	UCHAR       Addr2[MAC_ADDR_LEN];
	UCHAR       CkipFlag;
	BOOLEAN     TimerCancelled;
	EDCA_PARM   EdcaParm;

	if(PeerAssocRspSanity(pAd, Elem->Msg, Elem->MsgLen, Addr2, &CapabilityInfo, &Status, &Aid, SupRate, &SupRateLen, ExtRate, &ExtRateLen, &EdcaParm, &CkipFlag))
	{
		if(MAC_ADDR_EQUAL(Addr2, pAd->MlmeAux.Bssid)) // The frame is for me ?
		{
			DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - receive REASSOC_RSP to me (status=%d)\n", Status));
			RTMPCancelTimer(&pAd->MlmeAux.ReassocTimer, &TimerCancelled);

			if(Status == MLME_SUCCESS)
			{
				// go to procedure listed on page 376
				AssocPostProc(pAd, Addr2, CapabilityInfo, Aid, SupRate, SupRateLen, ExtRate, ExtRateLen, &EdcaParm);
			}

			//
			// Cisco Leap CCKM supported Re-association.
			//
			if (LEAP_CCKM_ON(pAd) && (pAd->StaCfg.CCKMLinkUpFlag == TRUE))
			{
				if (CCKMAssocRspSanity(pAd, Elem->Msg, Elem->MsgLen) == TRUE)
				{
					pAd->StaCfg.CkipFlag = CkipFlag;
					if (CkipFlag & 0x18)
					{
						NdisZeroMemory(pAd->StaCfg.TxSEQ, 4);
						NdisZeroMemory(pAd->StaCfg.RxSEQ, 4);
						NdisZeroMemory(pAd->StaCfg.CKIPMIC, 4);
						pAd->StaCfg.GIV[0] = RandomByte(pAd);
						pAd->StaCfg.GIV[1] = RandomByte(pAd);
						pAd->StaCfg.GIV[2] = RandomByte(pAd);
						pAd->StaCfg.bCkipCmicOn = TRUE;
						DBGPRINT(RT_DEBUG_TRACE, ("<CCX> pAd->StaCfg.CkipFlag = 0x%02x\n", pAd->StaCfg.bCkipCmicOn));
					}

					pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
					MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_REASSOC_CONF, 2, &Status);
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - CCKMAssocRspSanity() sanity check fail\n"));
				}
			}
			else
			{
				// CkipFlag is no use for reassociate
				pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
				MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_REASSOC_CONF, 2, &Status);
			}
		}
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - PeerReassocRspAction() sanity check fail\n"));
	}

}

/*
	==========================================================================
	Description:
		procedures on IEEE 802.11/1999 p.376
	Parametrs:

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID AssocPostProc(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR pAddr2,
	IN USHORT CapabilityInfo,
	IN USHORT Aid,
	IN UCHAR SupRate[],
	IN UCHAR SupRateLen,
	IN UCHAR ExtRate[],
	IN UCHAR ExtRateLen,
	IN PEDCA_PARM pEdcaParm)
{
	ULONG Idx;
	UCHAR VarIesOffset;

	pAd->MlmeAux.BssType = BSS_INFRA;
	COPY_MAC_ADDR(pAd->MlmeAux.Bssid, pAddr2);
	pAd->MlmeAux.Aid = Aid;
	pAd->MlmeAux.CapabilityInfo = CapabilityInfo & SUPPORTED_CAPABILITY_INFO;
	NdisMoveMemory(&pAd->MlmeAux.APEdcaParm, pEdcaParm, sizeof(EDCA_PARM));

	// filter out un-supported rates
	pAd->MlmeAux.SupRateLen = SupRateLen;
	NdisMoveMemory(pAd->MlmeAux.SupRate, SupRate, SupRateLen);
	RTMPCheckRates(pAd, pAd->MlmeAux.SupRate, &pAd->MlmeAux.SupRateLen);

	// filter out un-supported rates
	pAd->MlmeAux.ExtRateLen = ExtRateLen;
	NdisMoveMemory(pAd->MlmeAux.ExtRate, ExtRate, ExtRateLen);
	RTMPCheckRates(pAd, pAd->MlmeAux.ExtRate, &pAd->MlmeAux.ExtRateLen);

	// Set New WPA information
	Idx = BssTableSearch(&pAd->ScanTab, pAddr2, pAd->MlmeAux.Channel);
	if (Idx == BSS_NOT_FOUND)
	{
		DBGPRINT_ERR(("ASSOC - Can't find BSS after receiving Assoc response\n"));
	}
	else
	{
		// Mod by James to fix OID_802_11_ASSOCIATION_INFORMATION
		pAd->StaCfg.AssocInfo.Length = sizeof(NDIS_802_11_ASSOCIATION_INFORMATION); //+ sizeof(NDIS_802_11_FIXED_IEs); 	// Filled in assoc request
		pAd->StaCfg.AssocInfo.AvailableResponseFixedIEs =
			NDIS_802_11_AI_RESFI_CAPABILITIES | NDIS_802_11_AI_RESFI_STATUSCODE | NDIS_802_11_AI_RESFI_ASSOCIATIONID;
		pAd->StaCfg.AssocInfo.ResponseFixedIEs.Capabilities  = CapabilityInfo;
		pAd->StaCfg.AssocInfo.ResponseFixedIEs.StatusCode    = MLME_SUCCESS;		// Should be success, add failed later
		pAd->StaCfg.AssocInfo.ResponseFixedIEs.AssociationId = Aid;

		// Copy BSS VarIEs to StaCfg associnfo structure.
		// First add Supported rates
		VarIesOffset = 0;
		NdisMoveMemory(pAd->StaCfg.ResVarIEs + VarIesOffset, &SupRateIe, 1);
		VarIesOffset += 1;
		NdisMoveMemory(pAd->StaCfg.ResVarIEs + VarIesOffset, &SupRateLen, 1);
		VarIesOffset += 1;
		NdisMoveMemory(pAd->StaCfg.ResVarIEs + VarIesOffset, SupRate, SupRateLen);
		VarIesOffset += SupRateLen;
//		NdisMoveMemory(pAd->StaCfg.ResVarIEs + VarIesOffset, &ExtRateIe, 1);
//		VarIesOffset += 1;
//		NdisMoveMemory(pAd->StaCfg.ResVarIEs + VarIesOffset, &ExtRateLen, 1);
//		VarIesOffset += 1;
//		NdisMoveMemory(pAd->StaCfg.ResVarIEs + VarIesOffset, ExtRate, ExtRateLen);
//		VarIesOffset += ExtRateLen;

		// Second add RSN
		NdisMoveMemory(pAd->StaCfg.ResVarIEs + VarIesOffset, pAd->ScanTab.BssEntry[Idx].VarIEs, pAd->ScanTab.BssEntry[Idx].VarIELen);
		VarIesOffset += pAd->ScanTab.BssEntry[Idx].VarIELen;

		// Set Variable IEs Length
		pAd->StaCfg.ResVarIELen = VarIesOffset;
		pAd->StaCfg.AssocInfo.ResponseIELength = VarIesOffset;
	}
}

/*
	==========================================================================
	Description:
		left part of IEEE 802.11/1999 p.374
	Parameters:
		Elem - MLME message containing the received frame

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID PeerDisassocAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	UCHAR         Addr2[MAC_ADDR_LEN];
	USHORT        Reason;
	BOOLEAN       TimerCancelled;

	if(PeerDisassocSanity(pAd, Elem->Msg, Elem->MsgLen, Addr2, &Reason))
	{
		if (INFRA_ON(pAd) && MAC_ADDR_EQUAL(pAd->CommonCfg.Bssid, Addr2))
		{
			if (pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP)
			{
				// Cisco_LEAP has start a timer
				// We should cancel it if using LEAP
				RTMPCancelTimer(&pAd->StaCfg.LeapAuthTimer, &TimerCancelled);
				//Check is it mach the LEAP Authentication failed as possible a Rogue AP
				//on it's PortSecured not equal to WPA_802_1X_PORT_SECURED while process the Association.
				if ((pAd->Mlme.LeapMachine.CurrState != LEAP_IDLE) && (pAd->StaCfg.PortSecured != WPA_802_1X_PORT_SECURED))
				{
					RogueApTableSetEntry(pAd, &pAd->StaCfg.RogueApTab, Addr2, LEAP_REASON_AUTH_TIMEOUT);
				}
			}

			//
			// Get Current System time and Turn on AdjacentAPReport
			//
			NdisGetCurrentSystemTime(&pAd->StaCfg.CCXAdjacentAPLinkDownTime);
			pAd->StaCfg.CCXAdjacentAPReportFlag = TRUE;
			LinkDown(pAd, TRUE);
			pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
#if 0
			// 2004-09-11 john: can't remember why AP will DISASSOCIATE us.
			//   But since it says for 2430 only, we temporaily remove the patch.
			// 2002/11/21 -
			//   patch RT2430/RT2420 hangup issue. We suspect this AP DIS-ASSOCIATE frame
			//   is caused by PHY hangup, so we reset PHY, then auto recover the connection.
			//   if this attempt fails, then remains in LinkDown and leaves the problem
			//   to MlmePeriodicExec()
			// NICPatchRT2430Bug(pAd);
			pAd->RalinkCounters.BeenDisassociatedCount ++;
			// Remove auto recover effort when disassociate by AP, re-enable for patch 2430 only
			DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - Disassociated by AP, Auto Recovery attempt #%d\n", pAd->RalinkCounters.BeenDisassociatedCount));
			MlmeAutoReconnectLastSSID(pAd);
#endif
		}
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - PeerDisassocAction() sanity check fail\n"));
	}

}

/*
	==========================================================================
	Description:
		what the state machine will do after assoc timeout
	Parameters:
		Elme -

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID AssocTimeoutAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	USHORT  Status;

	DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - AssocTimeoutAction\n"));
	pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
	Status = MLME_REJ_TIMEOUT;
	MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_ASSOC_CONF, 2, &Status);
}

/*
	==========================================================================
	Description:
		what the state machine will do after reassoc timeout

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID ReassocTimeoutAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	USHORT  Status;

	DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - ReassocTimeoutAction\n"));
	pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
	Status = MLME_REJ_TIMEOUT;
	MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_REASSOC_CONF, 2, &Status);
}

/*
	==========================================================================
	Description:
		what the state machine will do after disassoc timeout

	IRQL = DISPATCH_LEVEL

	==========================================================================
	*/
VOID DisassocTimeoutAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	USHORT  Status;

	DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - DisassocTimeoutAction\n"));
	pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
	Status = MLME_SUCCESS;
	MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_DISASSOC_CONF, 2, &Status);
}

VOID InvalidStateWhenAssoc(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	USHORT  Status;

	DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - InvalidStateWhenAssoc(state=%d), reset ASSOC state machine\n",
			pAd->Mlme.AssocMachine.CurrState));
	pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
	Status = MLME_STATE_MACHINE_REJECT;
	MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_ASSOC_CONF, 2, &Status);
}

VOID InvalidStateWhenReassoc(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	USHORT Status;

	DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - InvalidStateWhenReassoc(state=%d), reset ASSOC state machine\n",
			pAd->Mlme.AssocMachine.CurrState));
	pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
	Status = MLME_STATE_MACHINE_REJECT;
	MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_REASSOC_CONF, 2, &Status);
}

VOID InvalidStateWhenDisassociate(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	USHORT Status;

	DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - InvalidStateWhenDisassoc(state=%d), reset ASSOC state machine\n",
			pAd->Mlme.AssocMachine.CurrState));
	pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
	Status = MLME_STATE_MACHINE_REJECT;
	MlmeEnqueue(pAd, MLME_CNTL_STATE_MACHINE, MT2_DISASSOC_CONF, 2, &Status);
}

/*
	==========================================================================
	Description:
		right part of IEEE 802.11/1999 page 374
	Note:
		This event should never cause ASSOC state machine perform state
		transition, and has no relationship with CNTL machine. So we separate
		this routine as a service outside of ASSOC state transition table.

	IRQL = DISPATCH_LEVEL

	==========================================================================
 */
VOID Cls3errAction(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR        pAddr)
{
	HEADER_802_11         DisassocHdr;
	PCHAR                 pOutBuffer = NULL;
	ULONG                 FrameLen = 0;
	NDIS_STATUS           NStatus;
	USHORT                Reason = REASON_CLS3ERR;

	NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  //Get an unused nonpaged memory
	if (NStatus != NDIS_STATUS_SUCCESS)
		return;

	DBGPRINT(RT_DEBUG_TRACE, ("ASSOC - Class 3 Error, Send DISASSOC frame\n"));
	MgtMacHeaderInit(pAd, &DisassocHdr, SUBTYPE_DISASSOC, 0, pAddr, pAd->CommonCfg.Bssid);
	MakeOutgoingFrame(pOutBuffer,           &FrameLen,
					sizeof(HEADER_802_11),&DisassocHdr,
					2,                    &Reason,
					END_OF_ARGS);
	MiniportMMRequest(pAd, pOutBuffer, FrameLen);

	pAd->StaCfg.DisassocReason = REASON_CLS3ERR;
	COPY_MAC_ADDR(pAd->StaCfg.DisassocSta, pAddr);
}

 /*
	==========================================================================
	Description:
		Switch between WEP and CKIP upon new association up.
	Parameters:

	IRQL = DISPATCH_LEVEL

	==========================================================================
  */
VOID SwitchBetweenWepAndCkip(
	IN PRTMP_ADAPTER pAd)
{
	int            i;
	SEC_CSR1_STRUC csr1;

	// if KP is required. change the CipherAlg in hardware shard key table from WEP
	// to CKIP. else remain as WEP
	if (CKIP_KP_ON(pAd))
	{
		// modify hardware key table so that MAC use correct algorithm to decrypt RX
		RTUSBReadMACRegister(pAd, SEC_CSR1, &csr1.word);
		if (csr1.field.Bss0Key0CipherAlg == CIPHER_WEP64)
			csr1.field.Bss0Key0CipherAlg = CIPHER_CKIP64;
		else if (csr1.field.Bss0Key0CipherAlg == CIPHER_WEP128)
			csr1.field.Bss0Key0CipherAlg = CIPHER_CKIP128;

		if (csr1.field.Bss0Key1CipherAlg == CIPHER_WEP64)
			csr1.field.Bss0Key1CipherAlg = CIPHER_CKIP64;
		else if (csr1.field.Bss0Key1CipherAlg == CIPHER_WEP128)
			csr1.field.Bss0Key1CipherAlg = CIPHER_CKIP128;

		if (csr1.field.Bss0Key2CipherAlg == CIPHER_WEP64)
			csr1.field.Bss0Key2CipherAlg = CIPHER_CKIP64;
		else if (csr1.field.Bss0Key2CipherAlg == CIPHER_WEP128)
			csr1.field.Bss0Key2CipherAlg = CIPHER_CKIP128;

		if (csr1.field.Bss0Key3CipherAlg == CIPHER_WEP64)
			csr1.field.Bss0Key3CipherAlg = CIPHER_CKIP64;
		else if (csr1.field.Bss0Key3CipherAlg == CIPHER_WEP128)
			csr1.field.Bss0Key3CipherAlg = CIPHER_CKIP128;
		RTUSBWriteMACRegister(pAd, SEC_CSR1, csr1.word);
		DBGPRINT(RT_DEBUG_TRACE, ("SwitchBetweenWepAndCkip: modify BSS0 cipher to %s\n", CipherName[csr1.field.Bss0Key0CipherAlg]));

		// modify software key table so that driver can specify correct algorithm in TXD upon TX
		for (i=0; i<SHARE_KEY_NUM; i++)
		{
			if (pAd->SharedKey[BSS0][i].CipherAlg == CIPHER_WEP64)
				pAd->SharedKey[BSS0][i].CipherAlg = CIPHER_CKIP64;
			else if (pAd->SharedKey[BSS0][i].CipherAlg == CIPHER_WEP128)
				pAd->SharedKey[BSS0][i].CipherAlg = CIPHER_CKIP128;
		}
	}

	// else if KP NOT inused. change the CipherAlg in hardware shard key table from CKIP
	// to WEP.
	else
	{
		// modify hardware key table so that MAC use correct algorithm to decrypt RX
		RTUSBReadMACRegister(pAd, SEC_CSR1, &csr1.word);
		if (csr1.field.Bss0Key0CipherAlg == CIPHER_CKIP64)
			csr1.field.Bss0Key0CipherAlg = CIPHER_WEP64;
		else if (csr1.field.Bss0Key0CipherAlg == CIPHER_CKIP128)
			csr1.field.Bss0Key0CipherAlg = CIPHER_WEP128;

		if (csr1.field.Bss0Key1CipherAlg == CIPHER_CKIP64)
			csr1.field.Bss0Key1CipherAlg = CIPHER_WEP64;
		else if (csr1.field.Bss0Key1CipherAlg == CIPHER_CKIP128)
			csr1.field.Bss0Key1CipherAlg = CIPHER_WEP128;

		if (csr1.field.Bss0Key2CipherAlg == CIPHER_CKIP64)
			csr1.field.Bss0Key2CipherAlg = CIPHER_WEP64;
		else if (csr1.field.Bss0Key2CipherAlg == CIPHER_CKIP128)
			csr1.field.Bss0Key2CipherAlg = CIPHER_WEP128;

		if (csr1.field.Bss0Key3CipherAlg == CIPHER_CKIP64)
			csr1.field.Bss0Key3CipherAlg = CIPHER_WEP64;
		else if (csr1.field.Bss0Key3CipherAlg == CIPHER_CKIP128)
			csr1.field.Bss0Key3CipherAlg = CIPHER_WEP128;
		RTUSBWriteMACRegister(pAd, SEC_CSR1, csr1.word);
		DBGPRINT(RT_DEBUG_TRACE, ("SwitchBetweenWepAndCkip: modify BSS0 cipher to %s\n", CipherName[csr1.field.Bss0Key0CipherAlg]));

		// modify software key table so that driver can specify correct algorithm in TXD upon TX
		for (i=0; i<SHARE_KEY_NUM; i++)
		{
			if (pAd->SharedKey[BSS0][i].CipherAlg == CIPHER_CKIP64)
				pAd->SharedKey[BSS0][i].CipherAlg = CIPHER_WEP64;
			else if (pAd->SharedKey[BSS0][i].CipherAlg == CIPHER_CKIP128)
				pAd->SharedKey[BSS0][i].CipherAlg = CIPHER_WEP128;
		}
	}
}

