/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

    Module Name:
    ap_data.c

    Abstract:
    Data path subroutines

    Revision History:
    Who         When            What
    --------    ----------      ----------------------------------------------
    Paul Lin    08-01-2002      created
    Paul Lin    07-01-2003      add encryption/decryption data flow
    John Chang  08-05-2003      modify 802.11 header for AP purpose
    John Chang  12-20-2004      modify for 2561/2661. merge into STA driver
*/
#include "rt_config.h"

/*
		========================================================================
		Routine Description:
			Process RxDone interrupt, running in DPC level

		Arguments:
			pAd    Pointer to our adapter

		Return Value:
			None

		Note:
			This routine has to maintain Rx ring read pointer.
	========================================================================
*/
#if 0
VOID    APHandleRxDoneInterrupt(
	IN  PRTMP_ADAPTER   pAd)
{
	PRXD_STRUC      pRxD;
	PHEADER_802_11  pHeader;
	PUCHAR          pData;
	USHORT          DataSize, Msdu2Size;
	PUCHAR          pDA, pSA;
	UCHAR           Header802_3[14];
	int             Count;

	MAC_TABLE_ENTRY *pEntry;
	NDIS_802_11_PRIVACY_FILTER   Privacy;
	AP_WPA_STATE    WpaState;
	ULONG           wdsidx = 0xFF;
	ULONG           i, j;
	PWDS_ENTRY      pWDSEntry = NULL;
	BOOLEAN         bWdsPacket;

	// Make sure Rx ring resource won't be used by other threads
	NdisAcquireSpinLock(&pAd->RxRingLock);

	for (Count=0; Count<MAX_RX_PROCESS; Count++)
	{
		// Point to Rx indexed rx ring descriptor
		pRxD = (PRXD_STRUC) pAd->RxRing.Cell[pAd->RxRing.CurRxIndex].AllocVa;

		// In case of false alarm or processed at last instance
		if (pRxD->Owner != DESC_OWN_HOST)
			break;

		// beak out this "do {...} while FALSE" loop whenever RX frame error without indicating
		// to upper layer
		do
		{
			pData   = (PUCHAR) (pAd->RxRing.Cell[pAd->RxRing.CurRxIndex].DmaBuf.AllocVa);
			pHeader = (PHEADER_802_11) pData;

			// Increase Total receive byte counter after real data received no mater any error or not
			pAd->RalinkCounters.ReceivedByteCount +=  pRxD->DataByteCnt;
			pAd->RalinkCounters.RxCount ++;

			// Check for all RxD errors
			if (APCheckRxError(pRxD) != NDIS_STATUS_SUCCESS)
			{
				if (pRxD->U2M && pRxD->CipherErr)
				{
					DBGPRINT(RT_DEBUG_TRACE, ("Rx u2me DATA Cipher Err(len=%d)\n", pRxD->DataByteCnt));
				}

				pAd->Counters8023.RxErrors++;
				break;  // give up this frame
			}

			INC_COUNTER64(pAd->WlanCounters.ReceivedFragmentCount);

			// All frames to AP are directed except probe_req. IEEE 802.11/1999 - p.463
			// Do this before checking "duplicate frame".
			// 2003-08-20 accept BEACON to decide if OLBC (Overlapping Legacy BSS Condition) happens
			// TODO: consider move this code to be inside "APCheckRxError()"
			if (pRxD->U2M)
			{
				if (pHeader->FC.Type == BTYPE_DATA)
				{
					CHAR RealRssi;
					RealRssi = ConvertToRssi(pAd, (UCHAR)pRxD->PlcpRssi, RSSI_NO_1);
					pAd->ApCfg.LastRssi  = RealRssi + pAd->BbpRssiToDbmDelta;
					pAd->ApCfg.AvgRssiX8  = (pAd->ApCfg.AvgRssiX8 - pAd->ApCfg.AvgRssi) + pAd->ApCfg.LastRssi;
					pAd->ApCfg.AvgRssi = pAd->ApCfg.AvgRssiX8 >> 3;
					pAd->ApCfg.NumOfAvgRssiSample ++;

					if (!pAd->Mlme.bTxRateReportPeriod)
					{
						RealRssi = ConvertToRssi(pAd, (UCHAR)pRxD->PlcpSignal, RSSI_NO_2);
						pAd->ApCfg.LastRssi2  = RealRssi + pAd->BbpRssiToDbmDelta;
					}

					// Gather PowerSave information from all valid DATA frames. IEEE 802.11/1999 p.461
					if (pHeader->FC.PwrMgmt)
						APPsIndicate(pAd, pHeader->Addr2, pAd->ApCfg.LastRssi, PWR_SAVE);
					else
						APPsIndicate(pAd, pHeader->Addr2, pAd->ApCfg.LastRssi, PWR_ACTIVE);
				}

				// ignore all CNTL frames except PS-POLL
				else if ((pHeader->FC.Type == BTYPE_CNTL) && (pHeader->FC.SubType != SUBTYPE_PS_POLL))
					break;
			}
			else
			{
				if ((pHeader->FC.Type == BTYPE_MGMT) &&
					((pHeader->FC.SubType == SUBTYPE_BEACON) || (pHeader->FC.SubType == SUBTYPE_PROBE_REQ)))
					;
				else
					break; // give up this frame
			}

			// DUPLICATE FRAME CHECK:
			//   Check retry bit. If this bit is on, search the cache with SA & sequence
			//   as index, if matched, discard this frame, otherwise, update cache
			//   This check only apply to unicast data & management frames
			if ((pRxD->U2M) &&
				(pHeader->FC.Retry) &&
				(RTMPSearchTupleCache(pAd, pHeader) == TRUE))
			{
				DBGPRINT(RT_DEBUG_INFO,("RxDone- drop DUPLICATE frame(len=%d)\n",pRxD->DataByteCnt));
				INC_COUNTER64(pAd->WlanCounters.FrameDuplicateCount);
				break; // give up this frame
			}
			else    // Update Tuple Cache
				RTMPUpdateTupleCache(pAd, pHeader);

			//
			// CASE I. receive a DATA frame
			//
			if (pHeader->FC.Type == BTYPE_DATA)
			{
				if (pHeader->FC.ToDs == 0)
					break; // give up this frame

				// check if Class2 or 3 error
				if ((pHeader->FC.FrDs == 0) && (APCheckClass2Class3Error(pAd, pHeader)))
					break; // give up this frame

				// Drop NULL, CF-ACK(no data), CF-POLL(no data), and CF-ACK+CF-POLL(no data) data frame
				if (pHeader->FC.SubType & 0x04) // bit 2 : no DATA
					break; // give up this frame

				if(pAd->ApCfg.BANClass3Data==TRUE)
					break; // give up this frame

				// 802.1x frame is sent to MLME instead of upper layer TCPIP
				if (RTMPCheckWPAframe(pAd, (PUCHAR)pHeader, pRxD->DataByteCnt))
				{
					REPORT_MGMT_FRAME_TO_MLME(pAd, pHeader, pRxD->DataByteCnt, pRxD->PlcpRssi, pRxD->PlcpSignal);
					break; // end of processing this frame
					}

					// pData : Pointer skip the first 24 bytes, 802.11 HEADER
					if ((pHeader->FC.FrDs == 1) && (pHeader->FC.ToDs == 1))
					{
						pData += LENGTH_802_11_WITH_ADDR4;
						DataSize = (USHORT)pRxD->DataByteCnt - LENGTH_802_11_WITH_ADDR4;
					}
					else
					{
						pData += LENGTH_802_11;
						DataSize = (USHORT)pRxD->DataByteCnt - LENGTH_802_11;
					}

					// remove the 2 extra QOS CNTL bytes
					if (pHeader->FC.SubType & 0x08)
					{
						pData += 2;
						DataSize -= 2;
					}

					// remove the 2 extra AGGREGATION bytes
				Msdu2Size = 0;
				if (pHeader->FC.Order)
				{
					Msdu2Size = *pData + (*(pData+1) << 8);
					if ((Msdu2Size <= 1536) && (Msdu2Size < DataSize))
					{
						pData += 2;
						DataSize -= 2;
					}
					else
						Msdu2Size = 0;
				}

				//
				// handle WDS
				//
				bWdsPacket = FALSE;
				if ((pHeader->FC.FrDs == 1) && (pHeader->FC.ToDs == 1))
				{
					bWdsPacket = TRUE;

					for (i = 0; i < pAd->WdsTab.Size; i++)
					{
						if (MAC_ADDR_EQUAL(pAd->WdsTab.MacTab[i].WdsAddr, pHeader->Addr2))
						{
							wdsidx = i;
							pWDSEntry = WdsTableLookup(pAd, ((PUCHAR)pHeader + sizeof(HEADER_802_11)), i);
							if (!pWDSEntry)
							{
								// check if other WDS include this entry, if yes, delete it and insert new entry
								for (j = 0; j < pAd->WdsTab.Size; j++)
								{
									if (j == i) continue;

									pWDSEntry = WdsTableLookup(pAd, ((PUCHAR)pHeader + sizeof(HEADER_802_11)), j);
									if (pWDSEntry)
									{
										DBGPRINT(RT_DEBUG_TRACE, ("WDS topology changed!!!\n"));
										WdsTableDeleteEntry(pAd, ((PUCHAR)pHeader + sizeof(HEADER_802_11)), j);
									}
								}
								pWDSEntry = WdsTableInsertEntry(pAd, ((PUCHAR)pHeader + sizeof(HEADER_802_11)), i);
							}
							break;
						}
					}

					if (i == pAd->WdsTab.Size)
					{
						DBGPRINT(RT_DEBUG_INFO, ("WDS Packet not from our WDS AP!!!\n"));
						break; // give up this frame
					}
				}

				// port access control
				pEntry = PACInquiry(pAd, pHeader->Addr2, &Privacy, &WpaState);

				// WDS packet's DA & SA is not the same
				if (bWdsPacket)
				{
					Privacy = Ndis802_11PrivFilterAcceptAll; // no 802.1x PAC for WDS frame
					pDA = pHeader->Addr3;
					pSA = (PUCHAR)pHeader + sizeof(HEADER_802_11);
				}
				else
				{
					pDA = pHeader->Addr3;
					pSA = pHeader->Addr2;
				}

				// drop all non-802.1x DATA frame before this client's Port-Access-Control is secured
				if (Privacy == Ndis802_11PrivFilter8021xWEP)
					break; // give up this frame

				// First or Only fragment
				if (pHeader->Frag == 0)
				{
					PUCHAR pRemovedLLCSNAP;

					CONVERT_TO_802_3(Header802_3, pDA, pSA, pData, DataSize, pRemovedLLCSNAP);
					pAd->FragFrame.Flags &= 0xFFFFFFFE;

					// Firt Fragment & LLC/SNAP been removed. Keep the removed LLC/SNAP for later on
					// TKIP MIC verification.
					if (pHeader->FC.MoreFrag && pRemovedLLCSNAP)
					{
						NdisMoveMemory(pAd->FragFrame.Header_LLC, pRemovedLLCSNAP, LENGTH_802_1_H);
						pAd->FragFrame.Flags |= 0x01;
					}

					// One & The only fragment
					if (pHeader->FC.MoreFrag == FALSE)
					{
						if ((pHeader->FC.Order == 1)  && (Msdu2Size > 0)) // this is an aggregation
						{
							USHORT Payload1Size, Payload2Size;
							PUCHAR pData2;

							pAd->RalinkCounters.OneSecRxAggregationCount ++;
							Payload1Size = DataSize - Msdu2Size;
							Payload2Size = Msdu2Size - LENGTH_802_3;

							// check if DA is another associted WSTA reachable via wireless bridging,
							// if it is, then no need to indicate to LLC
							if (APBridgeToWdsAndWirelessSta(pAd, Header802_3, LENGTH_802_3, pData, Payload1Size, wdsidx))
							{
								pData2 = pData + Payload1Size + LENGTH_802_3;
								APBridgeToWdsAndWirelessSta(pAd, Header802_3, LENGTH_802_3, pData2, Payload2Size, wdsidx);
							}
							else
							{
								REPORT_ETHERNET_FRAME_TO_LLC(pAd, Header802_3, pData, Payload1Size, pAd->net_dev);
								DBGPRINT_RAW(RT_DEBUG_INFO, ("!!! report segregated MSDU1 to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
									LENGTH_802_3+Payload1Size, Header802_3[12], Header802_3[13],
									*pData, *(pData+1),*(pData+2),*(pData+3),*(pData+4),*(pData+5),*(pData+6),*(pData+7)));

								pData2 = pData + Payload1Size + LENGTH_802_3;
								REPORT_ETHERNET_FRAME_TO_LLC(pAd, pData + Payload1Size, pData2, Payload2Size, pAd->net_dev);
								DBGPRINT_RAW(RT_DEBUG_INFO, ("!!! report segregated MSDU2 to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
									LENGTH_802_3+Payload2Size, *(pData2 -2), *(pData2 - 1),
									*pData2, *(pData2+1),*(pData2+2),*(pData2+3),*(pData2+4),*(pData2+5),*(pData2+6),*(pData2+7)));
							}
						}
						else
						{
							// check if DA is another associted WSTA reachable via wireless bridging,
							// if it is, then no need to indicate to LLC
							if (APBridgeToWdsAndWirelessSta(pAd, Header802_3, LENGTH_802_3, pData, DataSize, wdsidx))
								break;

							REPORT_ETHERNET_FRAME_TO_LLC(pAd, Header802_3, pData, DataSize, pAd->net_dev);
							DBGPRINT_RAW(RT_DEBUG_INFO, ("!!! report DATA (no frag) to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
								DataSize, Header802_3[12], Header802_3[13],
								*pData, *(pData+1),*(pData+2),*(pData+3),*(pData+4),*(pData+5),*(pData+6),*(pData+7)));
						}
					}

					// First fragment - record the 802.3 header and frame body
					else
					{
						NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3], pData, DataSize);
						NdisMoveMemory(pAd->FragFrame.Header802_3, Header802_3, LENGTH_802_3);
						pAd->FragFrame.RxSize   = DataSize;
						pAd->FragFrame.Sequence = pHeader->Sequence;
						pAd->FragFrame.LastFrag = pHeader->Frag;       // Should be 0
					}
				}


				// Middle & End of fragment burst
				else
				{
					// No LLC-SNAP header in except the first fragment frame

					if ((pHeader->Sequence != pAd->FragFrame.Sequence) ||
						(pHeader->Frag != (pAd->FragFrame.LastFrag + 1)))
					{
						// Fragment is not the same sequence or out of fragment number order
						// Clear Fragment frame contents
						NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
						break; // give up this frame
					}
					else if ((pAd->FragFrame.RxSize + DataSize) > MAX_FRAME_SIZE)
					{
						// Fragment frame is too large, it exeeds the maximum frame size.
						// Clear Fragment frame contents
						NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
						break; // give up this frame
					}

					// concatenate this fragment into the re-assembly buffer
					NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3 + pAd->FragFrame.RxSize], pData, DataSize);
					pAd->FragFrame.RxSize  += DataSize;
					pAd->FragFrame.LastFrag = pHeader->Frag;       // Update fragment number

					// Last fragment
					if (pHeader->FC.MoreFrag == FALSE)
					{
						// For TKIP frame, calculate the MIC value
						if (pRxD->CipherAlg == CIPHER_TKIP)
						{
							PCIPHER_KEY pWpaKey;

							if (!pEntry)
								break;
							pWpaKey = &pEntry->PairwiseKey;

							// Minus MIC length
							pAd->FragFrame.RxSize -= 8;

							if (pAd->FragFrame.Flags & 0x00000001)
							{
								// originally there's an LLC/SNAP field in the first fragment
								// but been removed in re-assembly buffer. here we have to include
								// this LLC/SNAP field upon calculating TKIP MIC
								// pData = pAd->FragFrame.Header_LLC;
								// Copy LLC data to the position in front of real data for MIC calculation
								NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3 - LENGTH_802_1_H],
									pAd->FragFrame.Header_LLC,
									LENGTH_802_1_H);
								pData = (PUCHAR) &pAd->FragFrame.Buffer[LENGTH_802_3 - LENGTH_802_1_H];
								DataSize = (USHORT)pAd->FragFrame.RxSize + LENGTH_802_1_H;
							}
							else
							{
								pData = (PUCHAR) &pAd->FragFrame.Buffer[LENGTH_802_3];
								DataSize = (USHORT)pAd->FragFrame.RxSize;
							}

							if (RTMPTkipCompareMICValue(pAd,
														pData,
														pDA,
														pSA,
														pWpaKey->RxMic,
														DataSize) == FALSE)
							{
								DBGPRINT_RAW(RT_DEBUG_ERROR,("Rx MIC Value error 2\n"));
								RTMPReportMicError(pAd, pWpaKey);
								break;  // give up this frame
							}

						}

						// check if DA is another associted WSTA reachable via wireless bridging,
						// if it is, then no need to indicate to LLC
						if (APBridgeToWdsAndWirelessSta(pAd, pAd->FragFrame.Header802_3, LENGTH_802_3, &pAd->FragFrame.Buffer[LENGTH_802_3], pAd->FragFrame.RxSize, wdsidx) == FALSE)
						{
							pData = &pAd->FragFrame.Buffer[LENGTH_802_3];
							REPORT_ETHERNET_FRAME_TO_LLC(pAd, pAd->FragFrame.Header802_3, pData, pAd->FragFrame.RxSize, pAd->net_dev);
//							DBGPRINT_RAW(RT_DEBUG_TRACE, ("!!! report DATA (fragmented) to LLC (len=%d) !!!\n", pAd->FragFrame.RxSize));
						}

						// Clear Fragment frame contents
						NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
					}
				}
				break;

			}

			//
			// CASE II. receive a MGMT frame
			//
			else if (pHeader->FC.Type == BTYPE_MGMT)
			{
				if (pAd->ApCfg.BANClass3Data==TRUE)
				{
					// disallow new association
					if ((pHeader->FC.SubType == SUBTYPE_ASSOC_REQ) || (pHeader->FC.SubType == SUBTYPE_AUTH))
					{
						DBGPRINT(RT_DEBUG_TRACE, ("   Disallow new Association \n "));
						break; // give up this frame
					}
				}

				REPORT_MGMT_FRAME_TO_MLME(pAd, pHeader, pRxD->DataByteCnt, pRxD->PlcpRssi, pRxD->PlcpSignal);
				break;  // end of processing this frame
			}

			//
			// CASE III. receive a CNTL frame
			//
			else if (pHeader->FC.Type == BTYPE_CNTL)
			{
				// handle PS-POLL here
				if ((pRxD->U2M) && (pHeader->FC.SubType == SUBTYPE_PS_POLL))
				{
					 USHORT Aid = pHeader->Duration & 0x3fff;
					 PUCHAR pAddr = pHeader->Addr2;

					 DBGPRINT(RT_DEBUG_TRACE,("rcv PS-POLL (AID=%d) from %02x:%02x:%02x:%02x:%02x:%02x\n",
						 Aid, pAddr[0], pAddr[1], pAddr[2], pAddr[3], pAddr[4], pAddr[5]));
					 APHandleRxPsPoll(pAd, pAddr, Aid, FALSE);
				}
				else
				{
					 DBGPRINT(RT_DEBUG_TRACE,("ignore CNTL (subtype=%d)\n", pHeader->FC.SubType));
				}
				break; // end of processing this frame
			}

			//
			// CASE IV. receive a frame of invalid type
			//
			else
				break; // give up this frame

		} while (FALSE);

		pRxD->Owner = DESC_OWN_NIC;
		INC_RING_INDEX(pAd->RxRing.CurRxIndex, RX_RING_SIZE);

	}

	// Make sure to release Rx ring resource
	NdisReleaseSpinLock(&pAd->RxRingLock);
}
#endif

// IRQL = DISPATCH_LEVEL
VOID	APSendPackets(
	IN	NDIS_HANDLE		MiniportAdapterContext,
	IN	PPNDIS_PACKET	ppPacketArray,
	IN	UINT			NumberOfPackets)
{
	UINT			Index;
//	NDIS_STATUS		Status = NDIS_STATUS_SUCCESS;
	PRTMP_ADAPTER	pAd = (PRTMP_ADAPTER) MiniportAdapterContext;
	PACKET_INFO     PacketInfo;
	PUCHAR          pSrcBufVA;
	UINT            SrcBufLen;
	PMAC_TABLE_ENTRY pEntry = NULL;
	SST             Sst;
	USHORT          Aid;
	UCHAR           PsMode, Rate;
//	UCHAR           i;
//	UCHAR QueIdx;
	PNDIS_PACKET	*pPacket;


	DBGPRINT(RT_DEBUG_WARN, ("!!!====> APSendPackets\n"));

	pPacket = ppPacketArray[0];
	for (Index = 0; Index < NumberOfPackets; Index++)
	{
#ifdef WIN_NDIS
		NdisQueryPacket(
			ppPacketArray[Index],				// Ndis packet
			&PacketInfo.PhysicalBufferCount,	// Physical buffer count
			&PacketInfo.BufferCount,			// Number of buffer descriptor
			&PacketInfo.pFirstBuffer,			// Pointer to first buffer descripotr
			&PacketInfo.TotalPacketLength);		// Ndis packet length

		// NdisQueryBufferSafe is a MUST for NDIS 5.1 and later version.
		// However, for early version, we should use it unless Ndis did not provides it.
		NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pSrcBufVA, &SrcBufLen);
#else
		RTMP_QueryPacketInfo(pPacket, &PacketInfo, &pSrcBufVA, &SrcBufLen);
#endif
		pEntry = APSsPsInquiry(pAd, pSrcBufVA, &Sst, &Aid, &PsMode, &Rate);

#if 0
#ifdef WDS
		//
		// case 1. M/BCAST or unknown unicast (DA not in local BSS), try WDS links
		//
		if (!(pEntry && (Sst == SST_ASSOC)) || ((*pSrcBufVA & 0x01) != 0))
		{
			PNDIS_PACKET    pPacket;
			UCHAR			wdsidx = 0xFF;
			ULONG			num = pAd->WdsTab.Size;
			WDS_ENTRY		*pWdsEntry = NULL;

			if ((*pSrcBufVA & 0x01) == 0) // unicast but not to my BSS, look up if DA in any WDS link
			{
				for (i = 0; i < pAd->WdsTab.Size; i++)
				{
					pWdsEntry = WdsTableLookup(pAd, pSrcBufVA, i);
					if(pWdsEntry) // known unicast. send to 1 WDS link
					{
						wdsidx = i;
						num = 1;
						DBGPRINT(RT_DEBUG_INFO, ("Packet unicast to WDS(%d)\n", i));
						break;
					}
				}
				// NOTE: unknown unicast frame will be sent to 'ALL' WDS links
			}

			for (i = 0; i < num; i++)
			{
				// 1. build a NDIS packet and call RTMPSendPacket();
				//    be careful about how/when to release this internal allocated NDIS PACKET buffer
				Status = RTMPCloneNdisPacket(pAd,  ppPacketArray[Index], &pPacket);
				if (Status != NDIS_STATUS_SUCCESS)
					break;

				// 3. send out the packet
				if (wdsidx == 0xff)
					RTMP_SET_PACKET_WDS(pPacket, 0x80 | i); // b7 as WDS bit, b0-6 as WDS index when b7==1
				else
					RTMP_SET_PACKET_WDS(pPacket, 0x80 | wdsidx); // b7 as WDS bit, b0-6 as WDS index when b7==1
				APSendPacket(pAd, pPacket);
			}
		}
#endif
#endif
		//
		// case 2. M/BCAST or unicast to STA belonging to my BSS
		//
		if ((pEntry && (Sst == SST_ASSOC)) || (*pSrcBufVA & 0x01))
		{
			// Record that orignal packet source is from NDIS layer,so that
			// later on driver knows how to release this NDIS PACKET
			RTMP_SET_PACKET_WDS(ppPacketArray[Index], (UCHAR)Aid);
			RTMP_SET_PACKET_SOURCE(ppPacketArray[Index], PKTSRC_NDIS);
			NDIS_SET_PACKET_STATUS(ppPacketArray[Index], NDIS_STATUS_PENDING);
			pAd->RalinkCounters.PendingNdisPacketCount ++;

                        APSendPacket(pAd, ppPacketArray[Index]);
		}
		else
		{
			NdisMSendComplete(pAd->AdapterHandle, ppPacketArray[Index], NDIS_STATUS_FAILURE);
		}
	}

	// Dequeue outgoing frames from TxSwQueue0..3 queue and process it

	RTMPDeQueuePacket(pAd,0);



	// Kick bulk out
	RTUSBKickBulkOut(pAd);
}

/*
	========================================================================
	Routine Description:
		This routine is used to en-queue outgoing packets when
		there is no enough shread memory

	Arguments:
		pAd    Pointer to our adapter
		pPacket     Pointer to send packet

	Return Value:
		None

	pre: Before calling this routine, caller should have filled the following fields

		pPacket->MiniportReserved[6] - contains packet source
		pPacket->MiniportReserved[5] - contains RA's WDS index (if RA on WDS link) or AID
									   (if RA directly associated to this AP)
	post:This routine should decide the remaining pPacket->MiniportReserved[] fields
		before calling APHardTransmit(), such as:

		pPacket->MiniportReserved[4] - Fragment # and User PRiority
		pPacket->MiniportReserved[7] - RTS/CTS-to-self protection method and TX rate
	========================================================================
*/
NDIS_STATUS APSendPacket(
	IN  PRTMP_ADAPTER   pAd,
	IN  PNDIS_PACKET    pPacket)
{
	PACKET_INFO     PacketInfo;
	PUCHAR          pSrcBufVA;
	ULONG           SrcBufLen;
	UINT            AllowFragSize;
	UCHAR           NumberOfFrag;
	UCHAR           RTSRequired;
	UCHAR           QueIdx, UserPriority;
	SST             Sst = SST_ASSOC;
	UCHAR           PsMode = PWR_ACTIVE, Rate;
	USHORT          WdsOrAid;
	MAC_TABLE_ENTRY *pMacEntry;
	PQUEUE_HEADER			pTxQueue;
	unsigned long   IrqFlags;

	DBGPRINT(RT_DEBUG_WARN, ("!!!====> APSendPacket\n"));
	DBGPRINT_RAW(RT_DEBUG_TRACE, ("APSendPacket entry bulkout idx=%d\n",pAd->NextBulkOutIndex[0]));

#ifdef WIN_NDIS
	// Prepare packet information structure for buffer descriptor
	// chained within a single NDIS packet.
	NdisQueryPacket(
		pPacket,                            // Ndis packet
		&PacketInfo.PhysicalBufferCount,    // Physical buffer count
		&PacketInfo.BufferCount,            // Number of buffer descriptor
		&PacketInfo.pFirstBuffer,           // Pointer to first buffer descripotr
		&PacketInfo.TotalPacketLength);     // Ndis packet length

	NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pSrcBufVA, &SrcBufLen);
#else
	RTMP_QueryPacketInfo(pPacket, &PacketInfo, &pSrcBufVA, &SrcBufLen);
#endif

	if (pSrcBufVA == NULL)
	{
		// Resourece is low, system did not allocate virtual address
		// return NDIS_STATUS_FAILURE directly to upper layer
		RELEASE_NDIS_PACKET(pAd, pPacket, NDIS_STATUS_FAILURE);
		return NDIS_STATUS_FAILURE;
	}
	DBGPRINT_RAW(RT_DEBUG_WARN, ("~~~sendpkt  down  %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x\n",
			*(pSrcBufVA + 0),	*(pSrcBufVA + 1),	*(pSrcBufVA + 2),	*(pSrcBufVA + 3),	*(pSrcBufVA + 4),	*(pSrcBufVA + 5),
			*(pSrcBufVA + 6),	*(pSrcBufVA + 7),	*(pSrcBufVA + 8),	*(pSrcBufVA + 9),	*(pSrcBufVA + 10),*(pSrcBufVA + 11),
			*(pSrcBufVA + 12), *(pSrcBufVA + 13)));
	WdsOrAid = RTMP_GET_PACKET_WDS(pPacket);

	// check if target STA is in power-saving mode. care only those associated STAs
	if (WdsOrAid & 0x80)
	{
		//b7 as WDS bit, b0-6 as WDS index when b7==1
		pMacEntry = NULL;
		Rate = pAd->WdsTab.MacTab[WdsOrAid & 0x7f].CurrTxRate;
	}
	else
	{
		USHORT Aid;
		pMacEntry = APSsPsInquiry(pAd, pSrcBufVA, &Sst, &Aid, &PsMode, &Rate);
	}

	// STEP 1. Decide number of fragments required to deliver this MSDU.
	//     The estimation here is not very accurate because difficult to
	//     take encryption overhead into consideration here. The result
	//     "NumberOfFrag" is then just used to pre-check if enough free
	//     TXD are available to hold this MSDU.

	if (*pSrcBufVA & 0x01)  // fragmentation not allowed on multicast & broadcast
		NumberOfFrag = 1;
	else if (pMacEntry && CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_AGGREGATION_CAPABLE))
		NumberOfFrag = 1;   // Aggregation overwhelms fragmentation
	else
	{
		// The calculated "NumberOfFrag" is a rough estimation because of various
		// encryption/encapsulation overhead not taken into consideration. This number is just
		// used to make sure enough free TXD are available before fragmentation takes place.
		// In case the actual required number of fragments of an NDIS packet
		// excceeds "NumberOfFrag"caculated here and not enough free TXD available, the
		// last fragment (i.e. last MPDU) will be dropped in RTMPHardTransmit() due to out of
		// resource, and the NDIS packet will be indicated NDIS_STATUS_FAILURE. This should
		// rarely happen and the penalty is just like a TX RETRY fail. Affordable.

		AllowFragSize = (pAd->CommonCfg.FragmentThreshold) - LENGTH_802_11 - LENGTH_CRC;
		NumberOfFrag = ((PacketInfo.TotalPacketLength - LENGTH_802_3 + LENGTH_802_1_H) / AllowFragSize) + 1;
	}
	// Save fragment number to Ndis packet reserved field
	RTMP_SET_PACKET_FRAGMENTS(pPacket, NumberOfFrag);

	// STEP 2. Check the requirement of RTS; decide packet TX rate
	//     If multiple fragment required, RTS is required only for the first fragment
	//     if the fragment size large than RTS threshold

	if (NumberOfFrag > 1)
		RTSRequired = (pAd->CommonCfg.FragmentThreshold > pAd->CommonCfg.RtsThreshold) ? 1 : 0;
	else
/* ~~sample, 2006/10/12, bug fix */
/* in spec.802-11-1999.pdf
   A STA shall use an RTS/CTS exchange for directed frames only when the length of the MPDU is greater
   than the length threshold indicated by the dot11RTSThreshold attribute. */
/* In 15.2.2, Figure 86, MPDU includes WLAN header & CRC, but dont include PLCP header */
//		RTSRequired = (PacketInfo.TotalPacketLength > pAd->CommonCfg.RtsThreshold) ? 1 : 0;
		RTSRequired = (PacketInfo.TotalPacketLength - LENGTH_802_3 + LENGTH_802_1_H + 28 > pAd->CommonCfg.RtsThreshold) ? 1 : 0;

	// RTS/CTS may also be required in order to protect OFDM frame
	if ((Rate >= RATE_FIRST_OFDM_RATE) && (pAd->CommonCfg.Channel <= 14) &&
		ERP_IS_USE_PROTECTION(pAd->ApCfg.ErpIeContent))
		RTSRequired = 1;

	// Save RTS requirement to Ndis packet reserved field
	RTMP_SET_PACKET_RTS(pPacket, RTSRequired);
	RTMP_SET_PACKET_TXRATE(pPacket, Rate);

	//
	// STEP 3. Traffic classification. outcome = <UserPriority, QueIdx>
	//
	UserPriority = 0;
	QueIdx       = QID_AC_BE;
#if 0
	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
	{
		USHORT Protocol;
		UCHAR  LlcSnapLen = 0, Byte0, Byte1;
		do
		{
			// get Ethernet protocol field
			Protocol = (USHORT)((pSrcBufVA[12] << 8) + pSrcBufVA[13]);
			if (Protocol <= 1500)
			{
				// get Ethernet protocol field from LLC/SNAP
				if (Sniff2BytesFromNdisBuffer(PacketInfo.pFirstBuffer, LENGTH_802_3 + 6, &Byte0, &Byte1) != NDIS_STATUS_SUCCESS)
					break;

				Protocol = (USHORT)((Byte0 << 8) + Byte1);
				LlcSnapLen = 8;
			}

			// always AC_BE for non-IP packet
			if (Protocol != 0x0800)
				break;

			// get IP header
			if (Sniff2BytesFromNdisBuffer(PacketInfo.pFirstBuffer, LENGTH_802_3 + LlcSnapLen, &Byte0, &Byte1) != NDIS_STATUS_SUCCESS)
				break;

			// return AC_BE if packet is not IPv4
			if ((Byte0 & 0xf0) != 0x40)
				break;

			UserPriority = (Byte1 & 0xe0) >> 5;
			QueIdx = MapUserPriorityToAccessCategory[UserPriority];

			// have to check ACM bit. downgrade UP & QueIdx before passing ACM
			// NOTE: AP doesn't have to negotiate TSPEC. ACM is controlled purely via user setup, not protocol handshaking
			if (pAd->CommonCfg.APEdcaParm.bACM[QueIdx])
			{
				UserPriority = 0;
				QueIdx       = QID_AC_BE;
			}
		} while (FALSE);
	}
#endif
	RTMP_SET_PACKET_UP(pPacket, UserPriority);
	DBGPRINT(RT_DEBUG_TRACE, ("set UserPriority\n"));
	//
	// 4. put to corrsponding TxSwQueue or Power-saving queue
	//

	// WDS link should never go into power-save mode; just send out the frame
	if (WdsOrAid & 0x80)
	{
		NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[QueIdx], IrqFlags);
		pTxQueue = &pAd->SendTxWaitQueue[QueIdx];
		InsertTailQueue(pTxQueue, RTMP_GET_PACKET_MR(pPacket));
		NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[QueIdx], IrqFlags);
	}
	// M/BCAST frames are put to PSQ as long as there's any associated STA in power-save mode
	else if ((*pSrcBufVA & 0x01) && pAd->MacTab.fAnyStationInPsm)
	{
		// we don't want too many MCAST/BCAST backlog frames to eat up all buffers. So in case number of backlog
		// MCAST/BCAST frames exceeds a pre-defined watermark within a DTIM period, simply drop coming new
		// MCAST/BCAST frames. This design is similiar to "BROADCAST throttling in most manageable Ethernet Switch chip.
		if (pAd->MacTab.McastPsQueue.Number >= MAX_SIZE_OF_MCAST_PSQ)
		{
			RELEASE_NDIS_PACKET(pAd, pPacket, NDIS_STATUS_FAILURE);
			DBGPRINT(RT_DEBUG_TRACE, ("too many frames (=%d) in M/BCAST PSQ, drop this one\n", pAd->MacTab.McastPsQueue.Number));
			return NDIS_STATUS_FAILURE;
		}
		else
		{
			DBGPRINT(RT_DEBUG_TRACE, ("insert into power save queue\n"));
			NdisAcquireSpinLock(&pAd->MacTabLock, IrqFlags);
			InsertTailQueue(&pAd->MacTab.McastPsQueue, RTMP_GET_PACKET_MR(pPacket));
			NdisReleaseSpinLock(&pAd->MacTabLock, IrqFlags);

			pAd->ApCfg.TimBitmap |= BIT32[0];  // mark MCAST/BCAST TIM bit
			// DBGPRINT(RT_DEBUG_TRACE, ("at least 1 STA in psm, move M/BCAST to PSQ, TIM bitmap=%08x\n", pAd->ApCfg.TimBitmap));
		}
	}
	// else if the associted STA in power-save mode, frame also goes to PSQ
	else if (pMacEntry && (Sst == SST_ASSOC) && (PsMode == PWR_SAVE))
	{
		NdisAcquireSpinLock(&pAd->MacTabLock, IrqFlags);
		InsertTailQueue(&pMacEntry->PsQueue, RTMP_GET_PACKET_MR(pPacket));
		NdisReleaseSpinLock(&pAd->MacTabLock, IrqFlags);

		// mark corresponding TIM bit in outgoing BEACON frame
		if (WdsOrAid >= 32)
			pAd->ApCfg.TimBitmap2 |= BIT32[WdsOrAid-32];
		else
			pAd->ApCfg.TimBitmap |= BIT32[WdsOrAid];
		DBGPRINT(RT_DEBUG_WARN, ("STA (AID=%d) in PSM, move to PSQ, TIM=%08x %08x\n", WdsOrAid, pAd->ApCfg.TimBitmap, pAd->ApCfg.TimBitmap2));
	}
	// 3. otherwise, transmit the frame
	else // (PsMode == PWR_ACTIVE) || (PsMode == PWR_UNKNOWN)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("insert into TxSwQueue\n"));
		NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[QueIdx], IrqFlags);
		pTxQueue = &pAd->SendTxWaitQueue[QueIdx];
		InsertTailQueue(pTxQueue, RTMP_GET_PACKET_MR(pPacket));
		NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[QueIdx], IrqFlags);
		DBGPRINT_RAW(RT_DEBUG_TRACE, ("APSendPacket current bulkout idx=%d\n",pAd->NextBulkOutIndex[0]));
	}

	pAd->RalinkCounters.OneSecOsTxCount[QueIdx]++; // TODO: for debug only. to be removed
	DBGPRINT(RT_DEBUG_TRACE, ("<====APSendPacket\n"));
	return NDIS_STATUS_SUCCESS;
}




/*
	========================================================================
	Routine Description:
		Copy frame from waiting queue into relative ring buffer and set
	appropriate ASIC register to kick hardware encryption before really
	sent out to air.

	Arguments:
		pAd        Pointer to our adapter
		PNDIS_PACKET    Pointer to outgoing Ndis frame
		NumberOfFrag    Number of fragment required

	Return Value:
		None
	========================================================================
*/
NDIS_STATUS APHardTransmit(
	IN	PRTMP_ADAPTER	pAd,
	IN	PNDIS_PACKET	pPacket,
	IN	UCHAR			NumberRequired,
	IN  UCHAR			QueIdx)
{
	UINT			LengthQosPAD =0;
	PACKET_INFO		PacketInfo;
//	UINT			NdisBufferLength;
	UINT			BytesCopied;
	UINT			TxSize; //, PLCPLength;
	UINT			FreeMpduSize;
	INT			SrcRemainingBytes;
	USHORT			Protocol;
	UCHAR			FrameGap;
	HEADER_802_11	Header_802_11;
	UCHAR			Header_802_3[LENGTH_802_3];
	PMAC_TABLE_ENTRY pMacEntry;
	PHEADER_802_11	pHeader80211;
	PUCHAR			pDest;
//	PUCHAR			pSrc;
	PTX_CONTEXT		pTxContext;
	PTXD_STRUC		pTxD;
//	PURB			pUrb;
	BOOLEAN			StartOfFrame;
	BOOLEAN			bEAPOLFrame;
//	BOOLEAN			Encapped;
	ULONG			Iv16;
	ULONG			Iv32;
	BOOLEAN			MICFrag;
//	PCIPHER_KEY		pWpaKey = NULL;
//	UCHAR			RetryLimit = 0;
	BOOLEAN			Cipher;
	ULONG			TransferBufferLength;
//	UINT			FinalPacketSize;
//	UINT			FragmentSize, LastFragmentSize;
//	BOOLEAN			MoreFragment;
//	UCHAR			AckRate = RATE_2;
	USHORT			AckDuration = 0;
	USHORT			EncryptionOverhead = 0;
	UCHAR			CipherAlg;
	BOOLEAN			bAckRequired;
	UCHAR			RetryMode = SHORT_RETRY;
//	UCHAR			PacketID;
	UCHAR			UserPriority;
	UCHAR			MpduRequired, RtsRequired;
	UCHAR			TxRate;
	UCHAR                  WdsOrAid;
	PCIPHER_KEY	pKey = NULL ;
	PUCHAR			pSrcBufVA = NULL;
	ULONG			SrcBufLen;
	PUCHAR			pExtraLlcSnapEncap = NULL; // NULL: no extra LLC/SNAP is required
	UCHAR			KeyIdx,KeyTable;
	PUCHAR			pWirelessPacket;
	BOOLEAN			bAggregatible = FALSE;
	ULONG			DataOffSet = 0;
	UCHAR			CKIP_PK[16];	 // ckip permuted key	ULONG
	ULONG 			NextMpduSize;
    BOOLEAN			bMoreData;
	BOOLEAN			bRTS_CTSFrame = FALSE;
//	BOOLEAN			bDUP_DHCPFrame = FALSE;
	unsigned long   IrqFlags;

	if ((pAd->CommonCfg.bIEEE80211H == 1) && (pAd->CommonCfg.RadarDetect.RDMode != RD_NORMAL_MODE))
	{
		DBGPRINT(RT_DEBUG_INFO,("RTUSBHardTransmit --> radar detect not in normal mode !!!\n"));
		return (NDIS_STATUS_FAILURE);
	}


	TxRate       = RTMP_GET_PACKET_TXRATE(pPacket);
	MpduRequired = RTMP_GET_PACKET_FRAGMENTS(pPacket);
	RtsRequired = RTMP_GET_PACKET_RTS(pPacket);
	UserPriority = RTMP_GET_PACKET_UP(pPacket);
	WdsOrAid     = RTMP_GET_PACKET_WDS(pPacket);
	bMoreData    = RTMP_GET_PACKET_MOREDATA(pPacket);
	DBGPRINT(RT_DEBUG_WARN,("!!!APHardTransmit(RTS=%d, Frag=%d)\n",RtsRequired,MpduRequired));
	if ((WdsOrAid & 0x80) || (WdsOrAid == 0))
		pMacEntry = NULL;
	else
		pMacEntry = &pAd->MacTab.Content[WdsOrAid];
	//
	// Prepare packet information structure which will be query for buffer descriptor
	//
#ifdef WIN_NDIS
	NdisQueryPacket(
		pPacket,							// Ndis packet
		&PacketInfo.PhysicalBufferCount,	// Physical buffer count
		&PacketInfo.BufferCount,			// Number of buffer descriptor
		&PacketInfo.pFirstBuffer,			// Pointer to first buffer descripotr
		&PacketInfo.TotalPacketLength);		// Ndis packet length
	DBGPRINT_RAW(RT_DEBUG_TRACE, ("packetsize:%d\n", PacketInfo.TotalPacketLength));

	NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pSrcBufVA, &SrcBufLen);
#else
	RTMP_QueryPacketInfo(pPacket, &PacketInfo, &pSrcBufVA, &SrcBufLen);
#endif

 	// Check for virtual address allocation, it might fail !!!
	if (pSrcBufVA == NULL)
	{
		DBGPRINT_RAW(RT_DEBUG_TRACE, ("pVirtualAddress == NULL\n"));
		return(NDIS_STATUS_RESOURCES);
	}
	if (SrcBufLen < 14)
	{
		DBGPRINT_RAW(RT_DEBUG_ERROR, ("RTUSBHardTransmit --> Ndis Packet buffer error !!!\n"));
		return (NDIS_STATUS_FAILURE);
	}
	else
	{
		//
		// Backup Header_802_3
		//
		NdisMoveMemory(Header_802_3, pSrcBufVA, LENGTH_802_3);
	}

      	DBGPRINT_RAW(RT_DEBUG_WARN, ("~~~send DATA (no frag) down  %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x\n",
			*(pSrcBufVA + 0),	*(pSrcBufVA + 1),	*(pSrcBufVA + 2),	*(pSrcBufVA + 3),	*(pSrcBufVA + 4),	*(pSrcBufVA + 5),
			*(pSrcBufVA + 6),	*(pSrcBufVA + 7),	*(pSrcBufVA + 8),	*(pSrcBufVA + 9),	*(pSrcBufVA + 10),*(pSrcBufVA + 11),
			*(pSrcBufVA + 12), *(pSrcBufVA + 13)));
	//
	// If DHCP datagram or ARP datagram , we need to send it as Low rates.
	//

	if (pAd->CommonCfg.Channel <= 14)
	{
		//
		// Case 802.11 b/g
		// basic channel means that we can use CCKM's low rate as RATE_1.
		//
		if ((TxRate != RATE_1) && RTMPCheckDHCPFrame(pAd, pPacket))
			TxRate = RATE_1;
	}
	else
	{
		//
		// Case 802.11a
		// We must used OFDM's low rate as RATE_6, note RATE_1 is not allow
		// Only OFDM support on Channel > 14
		//
		if ((TxRate != RATE_6) && RTMPCheckDHCPFrame(pAd, pPacket))
			TxRate = RATE_6;
	}

	if (pAd->CommonCfg.bAggregationCapable 	&&
		pMacEntry &&
		CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_AGGREGATION_CAPABLE) &&
		(TxRate >= RATE_6)					&&
		(pAd->StaCfg.bCkipCmicOn == FALSE)	&&
		TxFrameIsAggregatible(pAd, NULL, pSrcBufVA))
	{
		DBGPRINT_RAW(RT_DEBUG_WARN, ("aggregatible\n"));
		bAggregatible = TRUE;//to be check
	}

	// ------------------------------------------
	// STEP 0.1 Add 802.1x protocol check.
	// ------------------------------------------
	// For non-WPA network, 802.1x message should not encrypt even privacy is on.
	if (NdisEqualMemory(EAPOL, pSrcBufVA + 12, 2))
	{
		bEAPOLFrame = TRUE;
	}
	else
		bEAPOLFrame = FALSE;

	//
	// WPA 802.1x secured port control - drop all non-802.1x frame before port secured
	//

	//if (((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA) ||
	//	 (pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPAPSK) ||
	//	 (pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP)) &&
	//	((pAd->StaCfg.PortSecured == WPA_802_1X_PORT_NOT_SECURED) || (pAd->StaCfg.MicErrCnt >= 2)) &&
	//	(bEAPOLFrame == FALSE))
	//{
	//	DBGPRINT_RAW(RT_DEBUG_TRACE, ("RTMPHardEncrypt --> Drop packet before port secured !!!\n"));
	//	return (NDIS_STATUS_FAILURE);
	//}

	if (*pSrcBufVA & 0x01) // Multicast or Broadcast
	{
		bAckRequired = FALSE;
		INC_COUNTER64(pAd->WlanCounters.MulticastTransmittedFrameCount);
		Cipher = pAd->CommonCfg.GroupCipher; // Cipher for Multicast or Broadcast
	}
	else
	{
		bAckRequired = TRUE;
		Cipher = pAd->CommonCfg.PairCipher; // Cipher for Unicast
	}

	// 1. traditional TX burst
	if (pAd->CommonCfg.bEnableTxBurst && (pAd->Sequence & 0x7))
		FrameGap = IFS_SIFS;
	// 2. frame belonging to AC that has non-zero TXOP
	else if (pAd->CommonCfg.APEdcaParm.bValid && pAd->CommonCfg.APEdcaParm.Txop[QueIdx])
		FrameGap = IFS_SIFS;
	// 3. otherwise, always BACKOFF before transmission
	else
		FrameGap = IFS_BACKOFF;		// Default frame gap mode

	Protocol = *(pSrcBufVA + 12) * 256 + *(pSrcBufVA + 13);
	// if orginal Ethernet frame contains no LLC/SNAP, then an extra LLC/SNAP encap is required
	if (Protocol > 1500)
	{
		pExtraLlcSnapEncap = SNAP_802_1H;
		if (NdisEqualMemory(IPX, pSrcBufVA + 12, 2) ||
			NdisEqualMemory(APPLE_TALK, pSrcBufVA + 12, 2))
		{
			pExtraLlcSnapEncap = SNAP_BRIDGE_TUNNEL;
		}
	}
	else
	    pExtraLlcSnapEncap = NULL;


	// -----------------------------------------------------------------
	// STEP 2. MAKE A COMMON 802.11 HEADER SHARED BY ENTIRE FRAGMENT BURST.
	// -----------------------------------------------------------------
	NdisZeroMemory(&Header_802_11, sizeof(HEADER_802_11));
	pAd->Sequence = ((pAd->Sequence) + 1) & (MAX_SEQ_NUMBER);
	Header_802_11.FC.FrDs = 1;
	Header_802_11.FC.Type = BTYPE_DATA;
	Header_802_11.FC.SubType = SUBTYPE_DATA;
	Header_802_11.Sequence   = pAd->Sequence;
    // Inform STA not fail in sleep state when STA in power saving mode
    if (bMoreData == TRUE)
    {
    	Header_802_11.FC.MoreData = 1;
    }

	if (WdsOrAid & 0x80)
	{
		Header_802_11.FC.ToDs = 1;
		COPY_MAC_ADDR(Header_802_11.Addr1, pAd->WdsTab.MacTab[WdsOrAid & 0x7f].WdsAddr);    // to AP2
		COPY_MAC_ADDR(Header_802_11.Addr2, pAd->CurrentAddress);                            // from AP1
		COPY_MAC_ADDR(Header_802_11.Addr3, pSrcBufVA);                                      // DA

		// NOTE: ADDR4(=SA) will be appended later directly into pTxD->TxBuf0
	}
	else
	{
		// TODO: how about "MoreData" bit? AP need to set this bit especially for PS-POLL response
		COPY_MAC_ADDR(Header_802_11.Addr1, pSrcBufVA);                // DA
		COPY_MAC_ADDR(Header_802_11.Addr2, pAd->CommonCfg.Bssid);  // BSSID
		COPY_MAC_ADDR(Header_802_11.Addr3, pSrcBufVA + MAC_ADDR_LEN); // SA
	}

	//  AP's WMM-inused or not should depends on MAC table. It's per-client not per-system
	//if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED) && pMacEntry && CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_WMM_CAPABLE))
	//	Header_802_11.FC.SubType = SUBTYPE_QDATA;

	// --------------------------------------------------------
	// STEP 3. FIND ENCRYPT KEY AND DECIDE CIPHER ALGORITHM
	//      Find the WPA key, either Group or Pairwise Key
	//      LEAP + TKIP also use WPA key.
	// --------------------------------------------------------
	// Decide WEP bit and cipher suite to be used. Same cipher suite should be used for whole fragment burst
	// In Cisco CCX 2.0 Leap Authentication
	//         WepStatus is Ndis802_11Encryption1Enabled but the key will use PairwiseKey
	//         Instead of the SharedKey, SharedKey Length may be Zero.


	if ((bEAPOLFrame)                                               ||
		(pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)  ||
		(pAd->CommonCfg.WepStatus == Ndis802_11Encryption3Enabled)  ||
		(pAd->CommonCfg.WepStatus == Ndis802_11Encryption4Enabled))
	{
		if (WdsOrAid & 0x80)        // to WDS link
		{
			KeyIdx     = WDS_PAIRWISE_KEY_OFFSET + (WdsOrAid & 0x7f);
			KeyTable   = 1;
			CipherAlg  = pAd->WdsTab.Wpa_key.CipherAlg;
			if (CipherAlg)
				pKey = &pAd->WdsTab.Wpa_key;
		}
		else if (Header_802_11.Addr1[0] & 0x01)        // M/BCAST to local BSS, use default key in shared key table
		{
			KeyIdx     = pAd->CommonCfg.DefaultKeyId;
			KeyTable   = 0;
			CipherAlg  = pAd->SharedKey[BSS0][KeyIdx].CipherAlg;
			if (CipherAlg)
				pKey = &pAd->SharedKey[BSS0][KeyIdx];
		}
		else                        // unicast to local BSS
		{
			KeyIdx     = WdsOrAid;
			KeyTable   = 1;
			CipherAlg  = pAd->MacTab.Content[KeyIdx].PairwiseKey.CipherAlg;
			if (CipherAlg)
				pKey = &pAd->MacTab.Content[KeyIdx].PairwiseKey;
		}
	}
	else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled) // WEP or CKIP, always use shared key table
	{
		// TODO: need special treatment for CKIP case. please refer to STA code
		KeyIdx     = pAd->CommonCfg.DefaultKeyId;
		KeyTable   = 0;    // shared key table
		CipherAlg  = pAd->SharedKey[BSS0][KeyIdx].CipherAlg;
		if (CipherAlg)
			pKey = &pAd->SharedKey[BSS0][KeyIdx];
	}
	else
	{
		CipherAlg = CIPHER_NONE;
		KeyTable  = 0;
		KeyIdx    = 0;
		pKey      = NULL;
	}

	DBGPRINT(RT_DEBUG_TRACE,("APHardTransmit(EAPOL=%d, Mcast=%d) to AID#%d, Alg=%s, Ktab=%d, key#=%d\n",
		bEAPOLFrame, Header_802_11.Addr1[0] & 0x01, WdsOrAid, CipherName[CipherAlg], KeyTable, KeyIdx));

	if (CipherAlg != CIPHER_NONE)
		Header_802_11.FC.Wep = 1;

	// STEP 3.1 if TKIP is used and fragmentation is required. Driver has to
	//          append TKIP MIC at tail of the scatter buffer (This must be the
	//          ONLY scatter buffer in the NDIS PACKET).
	//          MAC ASIC will only perform IV/EIV/ICV insertion but no TKIP MIC
	if ((MpduRequired > 1) && (CipherAlg == CIPHER_TKIP))
	{

		RTMPCalculateMICValue(pAd, pPacket, pExtraLlcSnapEncap, pKey);
		NdisMoveMemory(pSrcBufVA + SrcBufLen, pAd->PrivateInfo.Tx.MIC, 8);
		SrcBufLen += 8;
		PacketInfo.TotalPacketLength += 8;
		CipherAlg = CIPHER_TKIP_NO_MIC;
	}

	if (CipherAlg == CIPHER_TKIP_NO_MIC)
	{
		//
		// On this case, we don't support Aggregation, it's diffcult to implement.
		//
		bAggregatible = FALSE;
	}

	// ----------------------------------------------------------------
	// STEP 4. Make RTS frame or CTS-to-self frame if required
	// ----------------------------------------------------------------

	//
	// calcuate the overhead bytes that encryption algorithm may add. This
	// affects the calculate of "duration" field
	//
	if ((CipherAlg == CIPHER_WEP64) || (CipherAlg == CIPHER_WEP128))
		EncryptionOverhead = 8; //WEP: IV[4] + ICV[4];
	else if (CipherAlg == CIPHER_TKIP_NO_MIC)
		EncryptionOverhead = 12;//TKIP: IV[4] + EIV[4] + ICV[4], MIC will be added to TotalPacketLength
	else if (CipherAlg == CIPHER_TKIP)
		EncryptionOverhead = 20;//TKIP: IV[4] + EIV[4] + ICV[4] + MIC[8]
	else if (CipherAlg == CIPHER_AES)
		EncryptionOverhead = 16;    // AES: IV[4] + EIV[4] + MIC[8]
	else
		EncryptionOverhead = 0;

	if (CKIP_CMIC_ON(pAd))
	{
		if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
		{
			//
			// LEAP + TKIP,
			// Type[2] + CKIP_MIC[4] + CKIP_SEQ[4] + IV[4] + EIV[4] + ICV[4] + MIC[8]
			//
			// 802_1H :    AA AA 03 00 00 00
			// Cisco SNAP: AA AA 03 00 40 96 00 02
			//                               ^^^^^ Type[2]
			//
			EncryptionOverhead = 30;
		}
		if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled)
		{
			//
			// LEAP + WEP
			// Type[2] + CKIP_MIC[4] + CKIP_SEQ[4] + IV[4] + ICV[4]
			//
			EncryptionOverhead = 18;
		}
	}

	// decide how much time an ACK/CTS frame will consume in the air
	AckDuration = RTMPCalcDuration(pAd, pAd->CommonCfg.ExpectedACKRate[TxRate], 14);

	// If fragment required, MPDU size is maximum fragment size
	// Else, MPDU size should be frame with 802.11 header & CRC
	if (MpduRequired > 1)
		NextMpduSize = pAd->CommonCfg.FragmentThreshold;
	else
	{
		NextMpduSize = PacketInfo.TotalPacketLength + LENGTH_802_11 + LENGTH_CRC - LENGTH_802_3;
		if (pExtraLlcSnapEncap)
			NextMpduSize += LENGTH_802_1_H;
	}


	if (RtsRequired  && ERP_IS_USE_PROTECTION(pAd->ApCfg.ErpIeContent) && (pAd->CommonCfg.Channel <= 14))
	{
		RTMPSendRTSCTSFrame(pAd,
						 	Header_802_11.Addr1,
						 	NextMpduSize + EncryptionOverhead,
						 	TxRate,
						 	pAd->CommonCfg.RtsRate,
						 	AckDuration,
						 	QueIdx,
						 	FrameGap,
						 	SUBTYPE_CTS);

		// RTS/CTS-protected frame should use LONG_RETRY (=4) and SIFS
		RetryMode = LONG_RETRY;
		FrameGap = IFS_SIFS;
		NumberRequired--;
		bRTS_CTSFrame = TRUE;
	}
	else if (RtsRequired || OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_RTS_PROTECTION_ENABLE))
	{
		RTMPSendRTSCTSFrame(pAd,
						 	Header_802_11.Addr1,
						 	NextMpduSize + EncryptionOverhead,
						 	TxRate,
						 	pAd->CommonCfg.RtsRate,
						 	AckDuration,
						 	QueIdx,
						 	FrameGap,
						 	SUBTYPE_RTS);

		// RTS/CTS-protected frame should use LONG_RETRY (=4) and SIFS
		RetryMode = LONG_RETRY;
		FrameGap = IFS_SIFS;
		if (RtsRequired)
			NumberRequired--;
		bRTS_CTSFrame = TRUE;
	}


	// --------------------------------------------------------
	// STEP 5. START MAKING MPDU(s)
	//      Start Copy Ndis Packet into Ring buffer.
	//      For frame required more than one ring buffer (fragment), all ring buffers
	//      have to be filled before kicking start tx bit.
	//      Make sure TX ring resource won't be used by other threads
	// --------------------------------------------------------
	SrcRemainingBytes = PacketInfo.TotalPacketLength - LENGTH_802_3;
	SrcBufLen        -= LENGTH_802_3;  // skip 802.3 header


	StartOfFrame = TRUE;
	MICFrag = FALSE;	// Flag to indicate MIC shall spread into two MPDUs

	// Start Copy Ndis Packet into Ring buffer.
	// For frame required more than one ring buffer (fragment), all ring buffers
	// have to be filled before kicking start tx bit.
	NdisAcquireSpinLock(&pAd->DataQLock[0], IrqFlags);
	do
	{
		//
		// STEP 5.1 Get the Tx Ring descriptor & Dma Buffer address
		//
		if(pAd->TxRingTotalNumber[QueIdx] >= TX_RING_SIZE)
		{
			DBGPRINT(RT_DEBUG_ERROR, ("------ERROR TX RING FULL %d !!\n", QueIdx));
			DBGPRINT(RT_DEBUG_ERROR,("--TxringtotalNumber = %lx !!--\n", pAd->TxRingTotalNumber[QueIdx]));
		}

		pTxContext  = &pAd->TxContext[QueIdx][pAd->NextTxIndex[QueIdx]];
		if ((pTxContext->bWaitingBulkOut == TRUE) || (pTxContext->InUse == TRUE))
		{
			DBGPRINT_ERR(("RTUSBHardTransmit: TX RING full\n"));
			pAd->RalinkCounters.TxRingErrCount++;
			NdisReleaseSpinLock(&pAd->DataQLock[0], IrqFlags);
			return (NDIS_STATUS_RESOURCES);
		}
		pTxContext->InUse   = TRUE;
		pAd->TxRingTotalNumber[QueIdx]++;
        pAd->ApCfg.REKEYCOUNTER++; /* ~~sample, 2006/10/4, add for group rekey */


		// Increase & maintain Tx Ring Index
		pAd->NextTxIndex[QueIdx]++;
		if (pAd->NextTxIndex[QueIdx] >= TX_RING_SIZE)
		{
			pAd->NextTxIndex[QueIdx] = 0;
		}

		pTxD  = &(pTxContext->TransferBuffer->TxDesc);
		NdisZeroMemory(pTxD, sizeof(TXD_STRUC));
		pWirelessPacket = pTxContext->TransferBuffer->u.WirelessPacket;
		//
		// STEP 5.2 COPY 802.11 HEADER INTO 1ST DMA BUFFER
		//
		pDest = pWirelessPacket;
		NdisMoveMemory(pDest, &Header_802_11, sizeof(Header_802_11));
		pDest       += sizeof(Header_802_11);
		DataOffSet  += sizeof(Header_802_11);

		//
		// STEP 5.3 PUT IVOFFSET, IV, EIV INTO TXD
		//
//		pTxD->IvOffset  = LENGTH_802_11;
		if (WdsOrAid & 0x80)    // NOTE: no QOS DATA format on WDS link so far
			pTxD->IvOffset = LENGTH_802_11_WITH_ADDR4;
		else
		{
			pTxD->IvOffset  = LENGTH_802_11;

			//if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED) && pMacEntry && CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_WMM_CAPABLE))
			//	pTxD->IvOffset += 2;  // add QOS CONTROL bytes
		}


//		if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
//			pTxD->IvOffset += 2;  // add QOS CONTROL bytes

		if ((CipherAlg == CIPHER_WEP64) || (CipherAlg == CIPHER_WEP128))
		{
			PUCHAR pTmp;
			pTmp = (PUCHAR) &pTxD->Iv;
			*pTmp       = RandomByte(pAd);
			*(pTmp + 1) = RandomByte(pAd);
			*(pTmp + 2) = RandomByte(pAd);
			*(pTmp + 3) = (KeyIdx << 6);
		}
		else if ((CipherAlg == CIPHER_CKIP64) || (CipherAlg == CIPHER_CKIP128) ||
			((CipherAlg == CIPHER_NONE) && (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled) && LEAP_CCKM_ON(pAd)))
		{
			if (CKIP_KP_ON(pAd))  // Cisco CKIP KP is on
			{
				PUCHAR	pTmp;
				int i;

				i = 2;
				while (++pAd->StaCfg.GIV[i] == 0x0)
				{
					i--;
					if (i < 0)  break;
				}

				// when KP is required. IV++
				pTmp = (PUCHAR) &pTxD->Iv;
				*pTmp       = pAd->StaCfg.GIV[0];
				*(pTmp + 1) = pAd->StaCfg.GIV[1];
				*(pTmp + 2) = pAd->StaCfg.GIV[2];
				*(pTmp + 3) = (KeyIdx << 6); // | 0x20;

				//
				// Use software Entrypt CKIP frame.
				//
				if (CipherAlg == CIPHER_NONE)
				{
					RTMGetPCkipPK(pAd, (PUCHAR) &Header_802_11, KeyIdx, pAd->StaCfg.GIV, CKIP_PK);

					RTMPInitWepEngine(
						pAd,
						CKIP_PK,
						KeyIdx,
						13,
						(PUCHAR) &pTxD->Iv);
					NdisMoveMemory(pDest, &pTxD->Iv, 4);
					pDest += 4;
				}
			}
			else
			{
				// when KP not required. IV is randomly generated
				PUCHAR pTmp;
				pTmp = (PUCHAR) &pTxD->Iv;
				*pTmp       = RandomByte(pAd);
				*(pTmp + 1) = RandomByte(pAd);
				*(pTmp + 2) = RandomByte(pAd);
				*(pTmp + 3) = (KeyIdx << 6);
			}
		}
		else if ((CipherAlg == CIPHER_TKIP) || (CipherAlg == CIPHER_TKIP_NO_MIC))
		{
			UCHAR	kidx;

			if (Header_802_11.Addr1[0] & 0x01)
				kidx = 1;
			else
				kidx = 0;
			RTMPInitTkipEngine(
				pAd,
				pKey->Key,
				kidx,		// This might cause problem when using peer key
				Header_802_11.Addr2,
				pKey->TxMic,
				pKey->TxTsc,
				&Iv16,
				&Iv32);

			NdisMoveMemory(&pTxD->Iv, &Iv16, 4);   // Copy IV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4);  // Copy EIV
			INC_TX_TSC(pKey->TxTsc);               // Increase TxTsc for next transmission
		}
		else if (CipherAlg == CIPHER_AES)
		{
			PUCHAR	pTmp;
			UCHAR	kidx;

			if (Header_802_11.Addr1[0] & 0x01)
				kidx = 1;
			else
				kidx = 0;

			pTmp = (PUCHAR) &Iv16;
			*pTmp       = pKey->TxTsc[0];
			*(pTmp + 1) = pKey->TxTsc[1];
			*(pTmp + 2) = 0;
			*(pTmp + 3) = (kidx << 6) | 0x20;
			Iv32 = *(PULONG)(&pKey->TxTsc[2]);

			NdisMoveMemory(&pTxD->Iv, &Iv16, 4);    // Copy IV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4);   // Copy EIV
			INC_TX_TSC(pKey->TxTsc);                // Increase TxTsc for next transmission
		}

		//
		// Fragmentation is not allowed on multicast & broadcast
		// So, we need to used the MAX_FRAG_THRESHOLD instead of pAd->CommonCfg.FragmentThreshold
		// otherwise if PacketInfo.TotalPacketLength > pAd->CommonCfg.FragmentThreshold then
		// packet will be fragment on multicast & broadcast.
		//
		// MpduRequired equals to 1 means this could be Aggretaion case.
		//
		if ((Header_802_11.Addr1[0] & 0x01) || MpduRequired == 1)
		{
			FreeMpduSize = MAX_FRAG_THRESHOLD - sizeof(Header_802_11) - LENGTH_CRC;
		}
		else
		{
			FreeMpduSize = pAd->CommonCfg.FragmentThreshold - sizeof(Header_802_11) - LENGTH_CRC;
		}

		/*if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
		{
			// copy QOS CONTROL bytes
			*pDest        =  (UserPriority & 0x0f) | pAd->CommonCfg.AckPolicy[QueIdx];
			*(pDest+1)    =  0;
			pDest         += 2;
			FreeMpduSize  -= 2;
			if (pAd->CommonCfg.AckPolicy[QueIdx] != NORMAL_ACK)
			{
				bAckRequired = FALSE;
			}
			LengthQosPAD = 2;
		}*/

		//
		// STEP 5.4 COPY LLC/SNAP, CKIP MIC INTO 1ST DMA BUFFER ONLY WHEN THIS
		//          MPDU IS THE 1ST OR ONLY FRAGMENT
		//
		if (Header_802_11.Frag == 0)
		{
			if (pExtraLlcSnapEncap)
			{
				if ((CipherAlg == CIPHER_TKIP_NO_MIC) && (pKey != NULL))
				{
					// Calculate MSDU MIC Value
					RTMPCalculateMICValue(pAd, pPacket, pExtraLlcSnapEncap, pKey);
				}

				if (CKIP_CMIC_ON(pAd) && (bEAPOLFrame == FALSE))
				{
					// CKIP_LLC_SNAP is inused. The frame format must be -
					//     802.11 header + CKIP_LLCSNAP(8) + MIC(4) + TxSEQ(4) + Proto(2) + Payload
					NdisMoveMemory(pDest, CKIP_LLC_SNAP, sizeof(CKIP_LLC_SNAP));

					pDest += sizeof(CKIP_LLC_SNAP);
					DataOffSet += sizeof(CKIP_LLC_SNAP);
					//
					// 1.) Insert MIC [4]
					//
					RTMPCkipInsertCMIC(pAd, pDest, (PUCHAR)&Header_802_11, pPacket, pKey, CKIP_LLC_SNAP);
					pDest += 4 ;
					DataOffSet += 4;
					//
					// 2.) Insert TX Sequence.
					//
					NdisMoveMemory(pDest, pAd->StaCfg.TxSEQ, 4);
					pDest += 4;
					DataOffSet += 4;
					NdisMoveMemory(pDest, pSrcBufVA + 12, 2);
					pDest += 2;
					DataOffSet += 2;

					//
					// Cisco LLC-SNAP add 2 bytes than LLC
					// AA:AA:03:00:40:96:00:02
					//
					FreeMpduSize -= 10;  //2+MIC[4]+SEQ[4]

					// Update TxSEQ for next TX
					{
						int i = 3;
						pAd->StaCfg.TxSEQ[i] = pAd->StaCfg.TxSEQ[i] + 2;
						while (pAd->StaCfg.TxSEQ[i] == 0x00)
						{
							i--;
							if (i < 0) break;
							pAd->StaCfg.TxSEQ[i] ++;
						}
					}

				}
				else
				{
					// Insert LLC-SNAP encapsulation
					NdisMoveMemory(pDest, pExtraLlcSnapEncap, 6);
					pDest += 6;
					DataOffSet += 6;
					NdisMoveMemory(pDest, pSrcBufVA + 12, 2);
					pDest += 2;
					DataOffSet += 2;
				}
				pSrcBufVA += LENGTH_802_3;
				FreeMpduSize -= LENGTH_802_1_H;
			}
			else
			{
				if ((CipherAlg == CIPHER_TKIP_NO_MIC) && (pKey != NULL))
				{
					// Calculate MSDU MIC Value
					RTMPCalculateMICValue(pAd, pPacket, pExtraLlcSnapEncap, pKey);
				}
				pSrcBufVA += LENGTH_802_3;
			}
		}

		// Start copying payload
		BytesCopied = 0;
		do
		{
			if (SrcBufLen >= FreeMpduSize)
			{
				// Copy only the free fragment size, and save the pointer
				// of current buffer descriptor for next fragment buffer.
				NdisMoveMemory(pDest, pSrcBufVA, FreeMpduSize);
				BytesCopied += FreeMpduSize;
				pSrcBufVA   += FreeMpduSize;
				pDest       += FreeMpduSize;
				SrcBufLen   -= FreeMpduSize;
				break;
			}
			else
			{
				// Copy the rest of this buffer descriptor pointed data
				// into ring buffer.
				NdisMoveMemory(pDest, pSrcBufVA, SrcBufLen);
				BytesCopied  += SrcBufLen;
				pDest        += SrcBufLen;
				FreeMpduSize -= SrcBufLen;
			}
#ifdef WIN_NDIS // Dennis Lee TBD
			// Next descriptor
			if (PacketInfo.pFirstBuffer)
				NdisGetNextBuffer(PacketInfo.pFirstBuffer, &PacketInfo.pFirstBuffer);

			// Start scan through the rest buffer descriptors
			if (PacketInfo.pFirstBuffer)
			{
				NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pSrcBufVA, &SrcBufLen);
			}
			else
#endif //
			{
				// No more buffer descriptor
				// Add MIC value if needed

				//if ((pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled) &&
				//	(MICFrag == FALSE) &&
				//	(pKey != NULL))

				if((CipherAlg == CIPHER_TKIP_NO_MIC) &&
					(MICFrag == FALSE) &&
					(pKey != NULL))
				{
				// Fregment and TKIP//
					INT i;

					SrcBufLen = 8;		// Set length to MIC length
					DBGPRINT_RAW(RT_DEBUG_INFO, ("Calculated TX MIC value ="));
					for (i = 0; i < 8; i++)
					{
						DBGPRINT_RAW(RT_DEBUG_INFO, ("%02x:", pAd->PrivateInfo.Tx.MIC[i]));
					}
					DBGPRINT_RAW(RT_DEBUG_INFO, ("\n"));

					if (FreeMpduSize >= SrcBufLen)
					{
						NdisMoveMemory(pDest, pAd->PrivateInfo.Tx.MIC, SrcBufLen);
						BytesCopied  += SrcBufLen;
						pDest		 += SrcBufLen;
						FreeMpduSize -= SrcBufLen;
						SrcBufLen = 0;
					}
					else
					{
						NdisMoveMemory(pDest, pAd->PrivateInfo.Tx.MIC, FreeMpduSize);
						BytesCopied  += FreeMpduSize;
						pSrcBufVA     = pAd->PrivateInfo.Tx.MIC + FreeMpduSize;
						pDest		 += FreeMpduSize;
						SrcBufLen		 -= FreeMpduSize;
						MICFrag 	  = TRUE;
					}
				}
				break;
			}
		}	while (TRUE);		// End of copying payload

		// Real packet size, No 802.1H header for fragments except the first one.
		if ((StartOfFrame == TRUE) && (pExtraLlcSnapEncap != NULL))
		{
			if ( CKIP_KP_ON(pAd) && (bEAPOLFrame == FALSE) && CipherAlg == CIPHER_NONE)
			{
				if (CKIP_CMIC_ON(pAd))
				{
					TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H + LengthQosPAD + 10; //Type[2] + CKIP_MIC[4] + CKIP_SEQ[4]
				}
				else
				{
					TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H + LengthQosPAD;
				}

				//
				// Since CKIP Key Permutation per packet, Hardware encryption can't achieve.
				// We have to used software encryption instead.
				//
				// RTMPInitWepEngine has been done before, directly call RTMPEncryptData to encrypt data.
				RTMPEncryptData(pAd,
								pTxContext->TransferBuffer->u.WirelessPacket + LENGTH_802_11 + LENGTH_WEP_IV,
								pTxContext->TransferBuffer->u.WirelessPacket + LENGTH_802_11 + LENGTH_WEP_IV,
								TxSize - LENGTH_802_11);

				RTMPSetICV(pAd, pDest);
				TxSize += LENGTH_WEP_ICV + LENGTH_WEP_IV;
			}
			else
			{
				if (CKIP_CMIC_ON(pAd) && (bEAPOLFrame == FALSE))
					TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H + LengthQosPAD + 10; //Type[2] + CKIP_MIC[4] + CKIP_SEQ[4]
				else
			TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H + LengthQosPAD;
			}
		}
		else
		{
			TxSize = BytesCopied + LENGTH_802_11 + LengthQosPAD;
		}

		SrcRemainingBytes -=  BytesCopied;

		//
		// STEP 5.6 MODIFY MORE_FRAGMENT BIT & DURATION FIELD. WRITE TXD
		//
		pHeader80211 = (PHEADER_802_11)pWirelessPacket;
		if (SrcRemainingBytes > 0) // more fragment is required
		{
			 ULONG NextFragMpduSize;

			 pHeader80211->FC.MoreFrag = 1;
			 NextFragMpduSize = min(SrcRemainingBytes, (INT)pAd->CommonCfg.FragmentThreshold);

			 if (NextFragMpduSize < pAd->CommonCfg.FragmentThreshold)
			 {
				// In this case, we need to include LENGTH_802_11 and LENGTH_CRC for calculating Duration.
				pHeader80211->Duration = (3 * pAd->CommonCfg.Dsifs) +
									(2 * AckDuration) +
									RTMPCalcDuration(pAd, TxRate, NextFragMpduSize + EncryptionOverhead + LENGTH_802_11 + LENGTH_CRC);
			 }
			 else
			 {
				pHeader80211->Duration = (3 * pAd->CommonCfg.Dsifs) +
								(2 * AckDuration) +
								RTMPCalcDuration(pAd, TxRate, NextFragMpduSize + EncryptionOverhead);
			 }

			RTUSBWriteTxDescriptor(pAd, pTxD, CipherAlg, KeyTable, KeyIdx, bAckRequired, TRUE, FALSE,
					RetryMode, FrameGap, TxRate, TxSize, QueIdx, 0,bRTS_CTSFrame);

			FrameGap = IFS_SIFS;     // use SIFS for all subsequent fragments
			Header_802_11.Frag ++;   // increase Frag #
		}
		else
		{
			pHeader80211->FC.MoreFrag = 0;
			if (pHeader80211->Addr1[0] & 0x01) // multicast/broadcast
				pHeader80211->Duration = 0;
			else
				pHeader80211->Duration = pAd->CommonCfg.Dsifs + AckDuration;

			if ((bEAPOLFrame) && (TxRate > RATE_6))
				TxRate = RATE_6;

			RTUSBWriteTxDescriptor(pAd, pTxD, CipherAlg, KeyTable, KeyIdx, bAckRequired, FALSE, FALSE,
					RetryMode, FrameGap, TxRate, TxSize, QueIdx, 0,bRTS_CTSFrame );


		}

		TransferBufferLength = TxSize + sizeof(TXD_STRUC);

		if ((TransferBufferLength % 4) == 1)
			TransferBufferLength  += 3;
		else if ((TransferBufferLength % 4) == 2)
			TransferBufferLength  += 2;
		else if ((TransferBufferLength % 4) == 3)
			TransferBufferLength  += 1;


		if ((TransferBufferLength % pAd->BulkOutMaxPacketSize) == 0)
			TransferBufferLength += 4;

		NdisZeroMemory(pTxContext->TransferBuffer->Aggregation, 4);
		NdisMoveMemory(pTxContext->Header_802_3, Header_802_3, LENGTH_802_3);
		pTxContext->pAd = pAd;
		pTxContext->TxRate = TxRate;
		pTxContext->DataOffset = DataOffSet;
		pTxContext->BulkOutSize = TransferBufferLength;
		pTxContext->bAggregatible = bAggregatible;
		pTxContext->bWaitingBulkOut = TRUE;

		RTUSB_SET_BULK_FLAG(pAd, (fRTUSB_BULK_OUT_DATA_NORMAL << QueIdx));

		// Set frame gap for the rest of fragment burst.
		// It won't matter if there is only one fragment (single fragment frame).
		StartOfFrame = FALSE;
		NumberRequired--;
		if (NumberRequired == 0)
		{
			pTxContext->LastOne = TRUE;
		}
		else
		{
			pTxContext->LastOne = FALSE;
		}

		NdisInterlockedIncrement(&pAd->TxCount);
	}	while (NumberRequired > 0); //while (SrcRemainingBytes > 0); //while (NumberRequired > 0);
	NdisReleaseSpinLock(&pAd->DataQLock[0], IrqFlags);
	// Acknowledge protocol send complete of pending packet.
#if defined(ME_98) && (ME_98 == 1)
	IndicateEnqueue(pAd, INDICATE_SEND_COMPLETE, NULL, 0, NULL, 0, 0,
					pPacket, NDIS_STATUS_SUCCESS);
	RTUSBIndicateDone(pAd);
#else
	DBGPRINT_RAW(RT_DEBUG_WARN, ("release ndis packet\n"));
	RELEASE_NDIS_PACKET(pAd, pPacket, NDIS_STATUS_SUCCESS);
#endif
	return (NDIS_STATUS_SUCCESS);
}







/*
	========================================================================
	Routine Description:
		Copy frame from waiting queue into relative ring buffer and set
	appropriate ASIC register to kick hardware encryption before really
	sent out to air.

	Arguments:
		pAd        Pointer to our adapter
		PNDIS_PACKET    Pointer to outgoing Ndis frame
		NumberOfFrag    Number of fragment required

	Return Value:
		None
	========================================================================
*/
#if 0
NDIS_STATUS APHardTransmit(
	IN  PRTMP_ADAPTER   pAd,
	IN  PNDIS_PACKET    pPacket,
	IN  UCHAR			NumberRequired,
       IN  UCHAR               QueIdx)

{
	PACKET_INFO     PacketInfo, NextPacketInfo;
	PUCHAR          pSrcBufVA, pNextPacketBufVA;
	ULONG           SrcBufLen, NextPacketBufLen;
	UCHAR           SrcBufIdx;
	ULONG           SrcBufPA;
	INT             SrcRemainingBytes;
	UCHAR           FrameGap;
	HEADER_802_11   Header_802_11;
	PHEADER_802_11  pHeader80211;
	PUCHAR          pExtraLlcSnapEncap; // NULL: no extra LLC/SNAP is required
	UCHAR           CipherAlg;
	PTXD_STRUC      pTxD;
	BOOLEAN         bEAPOLFrame;
	BOOLEAN         bAckRequired;
	ULONG           Iv16, Iv32;
	UCHAR           RetryMode = SHORT_RETRY;
	USHORT          AckDuration = 0;
	USHORT          EncryptionOverhead = 0;
	UCHAR           KeyIdx, KeyTable;
	PCIPHER_KEY     pKey = NULL;
	UCHAR           PID;
	//PRTMP_TX_RING   pTxRing = &pAd->TxRing[QueIdx];
	PTX_CONTEXT pTxContext;
	PRTMP_SCATTER_GATHER_LIST   pScatterGatherList;
	RTMP_SCATTER_GATHER_LIST    LocalScatterGatherList;
	PNDIS_PACKET    pNextPacket;
	UCHAR           MpduRequired, RtsRequired, UserPriority;
	UCHAR           TxRate;
	UCHAR           WdsOrAid;
	PMAC_TABLE_ENTRY pMacEntry;
	BOOLEAN         bRTS_CTSFrame = FALSE;
	BOOLEAN			bPiggyBack = FALSE;
	BOOLEAN			bAggregatible = FALSE;
	PUCHAR			pWirelessPacket;
	ULONG			TransferBufferLength;
	UCHAR			Header_802_3[LENGTH_802_3];

	if (pAd->CommonCfg.RadarDetect.RDMode != RD_NORMAL_MODE)
	{
		DBGPRINT(RT_DEBUG_INFO,("RTMPHardTransmit --> radar detect not in normal mode !!!\n"));
		RELEASE_NDIS_PACKET(pAd, pPacket, NDIS_STATUS_FAILURE);
		return (NDIS_STATUS_FAILURE);
	}

	MpduRequired = RTMP_GET_PACKET_FRAGMENTS(pPacket);
	RtsRequired  = RTMP_GET_PACKET_RTS(pPacket);
	UserPriority = RTMP_GET_PACKET_UP(pPacket);
	TxRate       = RTMP_GET_PACKET_TXRATE(pPacket);
	WdsOrAid     = RTMP_GET_PACKET_WDS(pPacket);

	DBGPRINT(RT_DEBUG_INFO,("APHardTransmit(RTS=%d, Frag=%d)\n",RtsRequired,MpduRequired));

	if ((WdsOrAid & 0x80) || (WdsOrAid == 0))
		pMacEntry = NULL;
	else
		pMacEntry = &pAd->MacTab.Content[WdsOrAid];

	// ---------------------------------------------
	// STEP 0. PARSING THE NDIS PACKET
	// ---------------------------------------------
	//
	// Prepare packet information structure which will be query for buffer descriptor
	//
#ifdef WIN_NDIS
	NdisQueryPacket(
		pPacket,                            // Ndis packet
		&PacketInfo.PhysicalBufferCount,    // Physical buffer count
		&PacketInfo.BufferCount,            // Number of buffer descriptor
		&PacketInfo.pFirstBuffer,           // Pointer to first buffer descripotr
		&PacketInfo.TotalPacketLength);     // Ndis packet length

	NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pSrcBufVA, &SrcBufLen);
#else
	RTMP_QueryPacketInfo(pPacket, &PacketInfo, &pSrcBufVA, &SrcBufLen);
#endif

	if (SrcBufLen < 14)
	{
		DBGPRINT(RT_DEBUG_ERROR,("RTMPHardTransmit --> Ndis Packet buffer error !!!\n"));
		RELEASE_NDIS_PACKET(pAd, pPacket, NDIS_STATUS_FAILURE);
		return (NDIS_STATUS_FAILURE);
	}
	else
	{
		//
		// Backup Header_802_3
		//
		NdisMoveMemory(Header_802_3, pSrcBufVA, LENGTH_802_3);
	}

	pNextPacket  = NULL;   // no aggregation is required

	// check if aggregation applicable on this MSDU and the next one. If applicable
	// make sure both MSDUs use internally created NDIS PACKET structure so that both has
	// only one scatter-gather buffer
	// NOTE: aggregation not applicable when CKIP inused. because it's difficult for driver
	//       to calculate CMIC on the aggregated MSDU
	if (pAd->CommonCfg.bAggregationCapable                                &&
		pMacEntry                                                         &&
		CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_AGGREGATION_CAPABLE) &&
		(TxRate >= RATE_6)                                                &&
		(pAd->ApCfg.bCkipCmicOn == FALSE)                                     && // ?????? CKIP ??????
		TxFrameIsAggregatible(pAd, NULL, pSrcBufVA))
	{
		bAggregatible = TRUE;
	}

	// ----------------------------------------
	// STEP 0.1 Add 802.1x protocol check.
	// ----------------------------------------

	// For non-WPA network, 802.1x message should not encrypt even privacy is on.
	if (NdisEqualMemory(EAPOL, pSrcBufVA + 12, 2))
		bEAPOLFrame = TRUE;
	else
		bEAPOLFrame = FALSE;

	//
	// WPA 802.1x secured port control - drop all non-802.1x frame before port secured
	//

	// TODO: 2004-12-27 lookup MAC table, check if 802.1x port secured or not
	// NOTE: no 802.1x check for WDS link

	// -------------------------------------------
	// STEP 0.2. some early parsing
	// -------------------------------------------

	// 1. traditional TX burst
	if (pAd->CommonCfg.bEnableTxBurst && (pAd->Sequence & 0x7))
		FrameGap = IFS_SIFS;
	// 2. frame belonging to AC that has non-zero TXOP
	else if (pAd->CommonCfg.APEdcaParm.bValid && pAd->CommonCfg.APEdcaParm.Txop[QueIdx])
		FrameGap = IFS_SIFS;
	// 3. otherwise, always BACKOFF before transmission
	else
		FrameGap = IFS_BACKOFF;     // Default frame gap mode

	// if orginal Ethernet frame contains no LLC/SNAP, then an extra LLC/SNAP encap is required
	if (((*(pSrcBufVA + 12) << 8) + *(pSrcBufVA + 13)) > 1500)
	{
		pExtraLlcSnapEncap = SNAP_802_1H;
		if (NdisEqualMemory(IPX, pSrcBufVA + 12, 2) ||
			NdisEqualMemory(APPLE_TALK, pSrcBufVA + 12, 2))
		{
			pExtraLlcSnapEncap = SNAP_BRIDGE_TUNNEL;
		}
	}
	else
		pExtraLlcSnapEncap = NULL;

	// -----------------------------------------------------------------
	// STEP 2. MAKE A COMMON 802.11 HEADER SHARED BY ENTIRE FRAGMENT BURST.
	// -----------------------------------------------------------------

	pAd->Sequence ++;

	NdisZeroMemory(&Header_802_11, sizeof(HEADER_802_11));
	Header_802_11.FC.FrDs = 1;
	Header_802_11.FC.Type = BTYPE_DATA;
	Header_802_11.FC.SubType = SUBTYPE_DATA;
	Header_802_11.Sequence   = pAd->Sequence;
	if (WdsOrAid & 0x80)
	{
		Header_802_11.FC.ToDs = 1;
		COPY_MAC_ADDR(Header_802_11.Addr1, pAd->WdsTab.MacTab[WdsOrAid & 0x7f].WdsAddr);    // to AP2
		COPY_MAC_ADDR(Header_802_11.Addr2, pAd->CurrentAddress);                            // from AP1
		COPY_MAC_ADDR(Header_802_11.Addr3, pSrcBufVA);                                      // DA

		// NOTE: ADDR4(=SA) will be appended later directly into pTxD->TxBuf0
	}
	else
	{
		// TODO: how about "MoreData" bit? AP need to set this bit especially for PS-POLL response
		COPY_MAC_ADDR(Header_802_11.Addr1, pSrcBufVA);                // DA
		COPY_MAC_ADDR(Header_802_11.Addr2, pAd->CommonCfg.Bssid);  // BSSID
		COPY_MAC_ADDR(Header_802_11.Addr3, pSrcBufVA + MAC_ADDR_LEN); // SA
	}

	//  AP's WMM-inused or not should depends on MAC table. It's per-client not per-system
	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED) && pMacEntry && CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_WMM_CAPABLE))
		Header_802_11.FC.SubType = SUBTYPE_QDATA;

	if (Header_802_11.Addr1[0] & 0x01) // Multicast or Broadcast
	{
		bAckRequired = FALSE;
		PID = PTYPE_SPECIAL|PSUBTYPE_DATA_NO_ACK;
		INC_COUNTER64(pAd->WlanCounters.MulticastTransmittedFrameCount);
	}
	else
	{
		bAckRequired = TRUE;
		// PID is used in TxDoneIsr to calculate per-client/WDS TX statistics
		// b6-7 marks this frame requires an ACK; b0-5: 0-59 client AID, 60-63 WDS link 0-3
		PID = PTYPE_DATA_REQUIRE_ACK;
		if (WdsOrAid & 0x80)
			PID += (WdsOrAid & 0x3f) + WDS_PAIRWISE_KEY_OFFSET;
		else
			PID += (WdsOrAid & 0x3f);
	}

	// --------------------------------------------------------
	// STEP 3. FIND ENCRYPT KEY AND DECIDE CIPHER ALGORITHM
	//      Find the WPA key, either Group or Pairwise Key
	//      LEAP + TKIP also use WPA key.
	// --------------------------------------------------------
	// Decide WEP bit and cipher suite to be used. Same cipher suite should be used for whole fragment burst
	// In Cisco CCX 2.0 Leap Authentication
	//         WepStatus is Ndis802_11Encryption1Enabled but the key will use PairwiseKey
	//         Instead of the SharedKey, SharedKey Length may be Zero.
	// APFindEncryptKey(pAd, WdsOrAid, bEAPOLFrame, Header_802_11.Addr1[0] & 0x01, &CipherAlg, &KeyTable, &KeyIdx, &pKey);
	pKey = NULL;

	if ((bEAPOLFrame)                                               ||
		(pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)  ||
		(pAd->CommonCfg.WepStatus == Ndis802_11Encryption3Enabled)  ||
		(pAd->CommonCfg.WepStatus == Ndis802_11Encryption4Enabled))
	{
		if (WdsOrAid & 0x80)        // to WDS link
		{
			KeyIdx     = WDS_PAIRWISE_KEY_OFFSET + (WdsOrAid & 0x7f);
			KeyTable   = 1;
			CipherAlg  = pAd->WdsTab.Wpa_key.CipherAlg;
			if (CipherAlg)
				pKey = &pAd->WdsTab.Wpa_key;
		}
		else if (Header_802_11.Addr1[0] & 0x01)        // M/BCAST to local BSS, use default key in shared key table
		{
			KeyIdx     = pAd->CommonCfg.DefaultKeyId;
			KeyTable   = 0;
			CipherAlg  = pAd->SharedKey[BSS0][KeyIdx].CipherAlg;
			if (CipherAlg)
				pKey = &pAd->SharedKey[BSS0][KeyIdx];
		}
		else                        // unicast to local BSS
		{
			KeyIdx     = WdsOrAid;
			KeyTable   = 1;
			CipherAlg  = pAd->MacTab.Content[KeyIdx].PairwiseKey.CipherAlg;
			if (CipherAlg)
				pKey = &pAd->MacTab.Content[KeyIdx].PairwiseKey;
		}
	}
	else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled) // WEP or CKIP, always use shared key table
	{
		// TODO: need special treatment for CKIP case. please refer to STA code
		KeyIdx     = pAd->CommonCfg.DefaultKeyId;
		KeyTable   = 0;    // shared key table
		CipherAlg  = pAd->SharedKey[BSS0][KeyIdx].CipherAlg;
		if (CipherAlg)
			pKey = &pAd->SharedKey[BSS0][KeyIdx];
	}
	else
	{
		CipherAlg = CIPHER_NONE;
		KeyTable  = 0;
		KeyIdx    = 0;
		pKey      = NULL;
	}

	DBGPRINT(RT_DEBUG_INFO,("APHardTransmit(EAPOL=%d, Mcast=%d) to AID#%d, Alg=%s, Ktab=%d, key#=%d\n",
		bEAPOLFrame, Header_802_11.Addr1[0] & 0x01, WdsOrAid, CipherName[CipherAlg], KeyTable, KeyIdx));

	if (CipherAlg != CIPHER_NONE)
		Header_802_11.FC.Wep = 1;

	// STEP 3.1 if TKIP is used and fragmentation is required. Driver has to
	//          append TKIP MIC at tail of the scatter buffer (This must be the
	//          ONLY scatter buffer in the NDIS PACKET).
	//          MAC ASIC will only perform IV/EIV/ICV insertion but no TKIP MIC
	if ((MpduRequired > 1) && (CipherAlg == CIPHER_TKIP))
	{
		ASSERT(pScatterGatherList->NumberOfElements == 1);
		RTMPCalculateMICValue(pAd, pPacket, pExtraLlcSnapEncap, pKey);
		NdisMoveMemory(pSrcBufVA + SrcBufLen, pAd->PrivateInfo.Tx.MIC, 8);
		SrcBufLen += 8;
		PacketInfo.TotalPacketLength += 8;
		CipherAlg = CIPHER_TKIP_NO_MIC;
	}
	else
	{
		//
		// Snice the ScatterGather may allocate on the contiguous range of the base physical address
		// In that case, the pScatterGatherList->Elements[0].Length will equal to PacketInfo.TotalPacketLength
		// And the pScatterGatherList->NumberOfElements will be reduce one snice the contiguous range of the data.
		// So we need to reset the SrcBufLen as pScatterGatherList->Elements[0].Length as our first Packet length.
		// Otherwise will not get the next pScatterGatherList Elements's length and cause TxRing Full.
		// This is ok on PKTSRC_NDIS case or not the PKTSRC_NDIS case.
		//
		SrcBufLen         = pScatterGatherList->Elements[0].Length;
	}

	//
	// calcuate the overhead bytes that encryption algorithm may add. This
	// affects the calculate of "duration" field
	//
	if ((CipherAlg == CIPHER_WEP64) || (CipherAlg == CIPHER_WEP128))
		EncryptionOverhead = 8; //WEP: IV[4] + ICV[4];
	else if (CipherAlg == CIPHER_TKIP_NO_MIC)
		EncryptionOverhead = 12;//TKIP: IV[4] + EIV[4] + ICV[4], MIC will be added to TotalPacketLength
	else if (CipherAlg == CIPHER_TKIP)
		EncryptionOverhead = 20;//TKIP: IV[4] + EIV[4] + ICV[4] + MIC[8]
	else if (CipherAlg == CIPHER_AES)
		EncryptionOverhead = 16;    // AES: IV[4] + EIV[4] + MIC[8]
	else
		EncryptionOverhead = 0;


	// ----------------------------------------------------------------
	// STEP 4. Make RTS frame or CTS-to-self frame if required
	// ----------------------------------------------------------------

	// decide how much time an ACK/CTS frame will consume in the air
	AckDuration = RTMPCalcDuration(pAd, pAd->CommonCfg.ExpectedACKRate[TxRate], 14);

	if (RtsRequired)
	{
		unsigned int NextMpduSize;

		// If fragment required, MPDU size is maximum fragment size
		// Else, MPDU size should be frame with 802.11 header & CRC
		if (MpduRequired > 1)
			NextMpduSize = pAd->CommonCfg.FragmentThreshold;
		else
		{
			NextMpduSize = PacketInfo.TotalPacketLength + LENGTH_802_11 + LENGTH_CRC - LENGTH_802_3;
			if (pExtraLlcSnapEncap)
				NextMpduSize += LENGTH_802_1_H;
		}

		RTMPSendRTSCTSFrame(pAd,
						 Header_802_11.Addr1,
						 NextMpduSize + EncryptionOverhead,
						 TxRate,
						 pAd->CommonCfg.RtsRate,
						 AckDuration,
						 QueIdx,
						 FrameGap,
						 SUBTYPE_RTS);

		// RTS/CTS-protected frame should use LONG_RETRY (=4) and SIFS
		RetryMode = LONG_RETRY;
		FrameGap = IFS_SIFS;
		bRTS_CTSFrame = TRUE;
	}

	// decide is the need of piggy-back
	if (pMacEntry && CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_PIGGYBACK_CAPABLE))
	{
		bPiggyBack = TRUE;
	}
	else
	{
		bPiggyBack = FALSE;
	}

	// --------------------------------------------------------
	// STEP 5. START MAKING MPDU(s)
	//      Start Copy Ndis Packet into Ring buffer.
	//      For frame required more than one ring buffer (fragment), all ring buffers
	//      have to be filled before kicking start tx bit.
	//      Make sure TX ring resource won't be used by other threads
	// --------------------------------------------------------

	SrcBufIdx         = 0;
	SrcBufPA          = NdisGetPhysicalAddressLow(pScatterGatherList->Elements[0].Address);
	SrcBufPA         += LENGTH_802_3;  // skip 802.3 header
	SrcBufLen        -= LENGTH_802_3;  // skip 802.3 header
	SrcRemainingBytes = PacketInfo.TotalPacketLength - LENGTH_802_3;

	NdisAcquireSpinLock(&pAd->TxRingLock);
	do
	{
		PUCHAR pDestBufVA, pDest;
		UINT   SrcBytesCopied;
		UINT   FreeMpduSize, MpduSize = 0;

		//
		// STEP 5.1 ACQUIRE TXD
		//
		//pDestBufVA = (PUCHAR) pTxRing->Cell[pTxRing->CurTxIndex].DmaBuf.AllocVa;
		//pTxD  = (PTXD_STRUC) pTxRing->Cell[pTxRing->CurTxIndex].AllocVa;
		if(pAd->TxRingTotalNumber[QueIdx] >= TX_RING_SIZE)
		{
			DBGPRINT(RT_DEBUG_ERROR, ("------ERROR TX RING FULL %d !!\n", QueIdx));
			DBGPRINT(RT_DEBUG_ERROR,("--TxringtotalNumber = %lx !!--\n", pAd->TxRingTotalNumber[QueIdx]));
		}

		pTxContext  = &pAd->TxContext[QueIdx][pAd->NextTxIndex[QueIdx]];
		if ((pTxContext->bWaitingBulkOut == TRUE) || (pTxContext->InUse == TRUE))
		{
			DBGPRINT_ERR(("RTUSBHardTransmit: TX RING full\n"));
			pAd->RalinkCounters.TxRingErrCount++;
			return (NDIS_STATUS_RESOURCES);
		}
		pTxContext->InUse   = TRUE;
		pAd->TxRingTotalNumber[QueIdx]++;

		// Increase & maintain Tx Ring Index
		pAd->NextTxIndex[QueIdx]++;
		if (pAd->NextTxIndex[QueIdx] >= TX_RING_SIZE)
		{
			pAd->NextTxIndex[QueIdx] = 0;
		}

		pTxD  = &(pTxContext->TransferBuffer->TxDesc);
		NdisZeroMemory(pTxD, sizeof(TXD_STRUC));
		pWirelessPacket = pTxContext->TransferBuffer->u.WirelessPacket;


		//
		// STEP 5.2 PUT IVOFFSET, IV, EIV INTO TXD
		//
		if (WdsOrAid & 0x80)    // NOTE: no QOS DATA format on WDS link so far
			pTxD->IvOffset = LENGTH_802_11_WITH_ADDR4;
		else
		{
			pTxD->IvOffset  = LENGTH_802_11;

			if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED) && pMacEntry && CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_WMM_CAPABLE))
				pTxD->IvOffset += 2;  // add QOS CONTROL bytes
		}

		if ((CipherAlg == CIPHER_WEP64) || (CipherAlg == CIPHER_WEP128))
		{
			PUCHAR pTmp;
			pTmp = (PUCHAR) &pTxD->Iv;
			*pTmp       = RandomByte(pAd);
			*(pTmp + 1) = RandomByte(pAd);
			*(pTmp + 2) = RandomByte(pAd);
			*(pTmp + 3) = (KeyIdx << 6);
		}
		else if ((CipherAlg == CIPHER_CKIP64) || (CipherAlg == CIPHER_CKIP128))
		{
			if (pAd->ApCfg.CkipFlag & 0x10)  // Cisco CKIP KP is on
			{
				PUCHAR  pTmp;
				int i;

				i = 2;
				while (++pAd->ApCfg.GIV[i] == 0x0)
				{
					i--;
					if (i < 0)  break;
				}

				// when KP is required. IV++
				pTmp = (PUCHAR) &pTxD->Iv;
				*pTmp       = pAd->ApCfg.GIV[0];
				*(pTmp + 1) = pAd->ApCfg.GIV[1];
				*(pTmp + 2) = pAd->ApCfg.GIV[2];
				*(pTmp + 3) = (KeyIdx << 6); // | 0x20;
			}
			else
			{
				// when KP not required. IV is randomly generated
				PUCHAR pTmp;
				pTmp = (PUCHAR) &pTxD->Iv;
				*pTmp       = RandomByte(pAd);
				*(pTmp + 1) = RandomByte(pAd);
				*(pTmp + 2) = RandomByte(pAd);
				*(pTmp + 3) = (KeyIdx << 6);
			}
		}
		else if ((CipherAlg == CIPHER_TKIP) || (CipherAlg == CIPHER_TKIP_NO_MIC))
		{
			UCHAR	kidx;

			if (Header_802_11.Addr1[0] & 0x01)
				kidx = 1;
			else
				kidx = 0;

			RTMPInitTkipEngine(
				pAd,
				pKey->Key,
				kidx,     // This might cause problem when using peer key
				Header_802_11.Addr2,
				pKey->TxMic,
				pKey->TxTsc,
				&Iv16,
				&Iv32);

			NdisMoveMemory(&pTxD->Iv, &Iv16, 4);   // Copy IV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4);  // Copy EIV
			INC_TX_TSC(pKey->TxTsc);               // Increase TxTsc for next transmission
		}
		else if (CipherAlg == CIPHER_AES)
		{
			PUCHAR  pTmp;
			UCHAR	kidx;

			if (Header_802_11.Addr1[0] & 0x01)
				kidx = 1;
			else
				kidx = 0;

			pTmp = (PUCHAR) &Iv16;
			*pTmp       = pKey->TxTsc[0];
			*(pTmp + 1) = pKey->TxTsc[1];
			*(pTmp + 2) = 0;
			*(pTmp + 3) = (kidx << 6) | 0x20;
			Iv32 = *(PULONG)(&pKey->TxTsc[2]);

			NdisMoveMemory(&pTxD->Iv, &Iv16, 4);    // Copy IV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4);   // Copy EIV
			INC_TX_TSC(pKey->TxTsc);                // Increase TxTsc for next transmission
		}

		//
		// STEP 5.3 COPY 802.11 HEADER INTO 1ST DMA BUFFER
		//
		//pDest = pDestBufVA;
		pDest = pWirelessPacket;
		NdisMoveMemory(pDest, &Header_802_11, sizeof(Header_802_11));
		pDest       += sizeof(Header_802_11);

		//
		// Fragmentation is not allowed on multicast & broadcast
		// So, we need to used the MAX_FRAG_THRESHOLD instead of pAd->CommonCfg.FragmentThreshold
		// otherwise if PacketInfo.TotalPacketLength > pAd->CommonCfg.FragmentThreshold then
		// packet will be fragment on multicast & broadcast.
		//
		if (*pSrcBufVA & 0x01)
		{
			FreeMpduSize = MAX_FRAG_THRESHOLD - sizeof(Header_802_11) - LENGTH_CRC;
		}
		else
		{
			FreeMpduSize = pAd->CommonCfg.FragmentThreshold - sizeof(Header_802_11) - LENGTH_CRC;
		}

		// TODO: 2004-12-27 add ADDR4 field if WDS frame
		if (WdsOrAid & 0x80)
		{
			COPY_MAC_ADDR(pDest, pSrcBufVA + MAC_ADDR_LEN); // ADDR4 = SA
			pDest        += MAC_ADDR_LEN;
			FreeMpduSize -= MAC_ADDR_LEN;
		}
		else
		{
			// TODO: 2005-02-10 also check if the STA is WMM capable
			// NOTE: no QOS DATA format on WDS link so far
			if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED) && pMacEntry && CLIENT_STATUS_TEST_FLAG(pMacEntry, fCLIENT_STATUS_WMM_CAPABLE))
			{
				// copy QOS CONTROL bytes
				*pDest        =  (UserPriority & 0x0f) | pAd->CommonCfg.AckPolicy[QueIdx];
				*(pDest+1)    =  0;
				pDest         += 2;
				FreeMpduSize  -= 2;
				if (pAd->CommonCfg.AckPolicy[QueIdx] != NORMAL_ACK) // ?????
				{
					bAckRequired = FALSE;
					PID = PTYPE_SPECIAL|PSUBTYPE_DATA_NO_ACK;
				}
			}
		}

		// if aggregation, put the 2nd MSDU length(extra 2-byte field) after QOS_CONTROL. little endian
		if (pNextPacket)
		{
			*pDest        =  (UCHAR)NextPacketBufLen & 0xff;
			*(pDest+1)    =  (UCHAR)(NextPacketBufLen >> 8);
			pDest         += 2;
			FreeMpduSize  = MAX_AGGREGATION_SIZE;
			((PHEADER_802_11)pDestBufVA)->FC.Order = 1; // steal "order" bit to mark "aggregation"
		}

		//
		// STEP 5.4 COPY LLC/SNAP, CKIP MIC INTO 1ST DMA BUFFER ONLY WHEN THIS
		//          MPDU IS THE 1ST OR ONLY FRAGMENT
		//
		if (Header_802_11.Frag == 0)
		{
			if (pExtraLlcSnapEncap)
			{
				if ((pAd->ApCfg.CkipFlag & 0x08) && (bEAPOLFrame == FALSE))
				{
					// CKIP_LLC_SNAP is inused. The frame format must be -
					//     802.11 header + CKIP_LLCSNAP(8) + MIC(4) + TxSEQ(4) + Proto(2) + Payload
					NdisMoveMemory(pDest, CKIP_LLC_SNAP, sizeof(CKIP_LLC_SNAP));
					pDest += sizeof(CKIP_LLC_SNAP);
					//
					// 1.) Insert MIC [4]
					//
					RTMPCkipInsertCMIC(pAd, pDest, (PUCHAR)&Header_802_11, pPacket, pKey, CKIP_LLC_SNAP);
					pDest += 4 ;
					//
					// 2.) Insert TX Sequence.
					//
					NdisMoveMemory(pDest, pAd->StaCfg.TxSEQ, 4);
					pDest += 4;
					NdisMoveMemory(pDest, pSrcBufVA + 12, 2);
					pDest += 2;
					FreeMpduSize -= (sizeof(CKIP_LLC_SNAP) + 10);

					// Update TxSEQ for next TX
					{
						int i = 3;
						pAd->ApCfg.TxSEQ[i] = pAd->ApCfg.TxSEQ[i] + 2;
						while (pAd->ApCfg.TxSEQ[i] == 0x00)
						{
							i--;
							if (i < 0) break;
							pAd->ApCfg.TxSEQ[i] ++;
						}
					}

				}
				else
				{
					// Insert LLC-SNAP encapsulation
					NdisMoveMemory(pDest, pExtraLlcSnapEncap, 6);
					pDest += 6;
					NdisMoveMemory(pDest, pSrcBufVA + 12, 2);
					pDest += 2;
					FreeMpduSize -= LENGTH_802_1_H;
				}
			}
		}

		// TX buf0 size fixed here
		pTxD->BufLen0    = (ULONG)(pDest - pDestBufVA);
		pTxD->BufCount   = 1;

		//
		// STEP 5.5 TRAVERSE NDIS PACKET TO BUILD THE MPDU PAYLOAD
		//
		MpduSize         = pTxD->BufLen0;
		SrcBytesCopied   = 0;
		do
		{
			if (SrcBufLen == 0)
			{
				// do nothing. skip to next scatter-gather buffer
			}
			else if (SrcBufLen <= FreeMpduSize)
			{
				// scatter-gather buffer still fit into current MPDU
				switch (pTxD->BufCount) {
					case 1: pTxD->BufPhyAddr1 = SrcBufPA;
							pTxD->BufLen1     = SrcBufLen;
							pTxD->BufCount ++;
							break;
					case 2: pTxD->BufPhyAddr2 = SrcBufPA;
							pTxD->BufLen2     = SrcBufLen;
							pTxD->BufCount ++;
							break;
					case 3: pTxD->BufPhyAddr3 = SrcBufPA;
							pTxD->BufLen3     = SrcBufLen;
							pTxD->BufCount ++;
							break;
					case 4: pTxD->BufPhyAddr4 = SrcBufPA;
							pTxD->BufLen4     = SrcBufLen;
							pTxD->BufCount ++;
							break;
					default:    // should never happen
							break;
				}
				SrcBytesCopied  += SrcBufLen;
				pDest           += SrcBufLen;
				FreeMpduSize    -= SrcBufLen;
				MpduSize        += SrcBufLen;
				SrcBufPA        += SrcBufLen;
				SrcBufLen        = 0;
			}
			else
			{
				// scatter-gather buffer exceed current MPDU. leave some of the buffer to next MPDU
				switch (pTxD->BufCount) {
					case 1: pTxD->BufPhyAddr1 = SrcBufPA;
							pTxD->BufLen1     = FreeMpduSize;
							pTxD->BufCount ++;
							break;
					case 2: pTxD->BufPhyAddr2 = SrcBufPA;
							pTxD->BufLen2     = FreeMpduSize;
							pTxD->BufCount ++;
							break;
					case 3: pTxD->BufPhyAddr3 = SrcBufPA;
							pTxD->BufLen3     = FreeMpduSize;
							pTxD->BufCount ++;
							break;
					case 4: pTxD->BufPhyAddr4 = SrcBufPA;
							pTxD->BufLen4     = FreeMpduSize;
							pTxD->BufCount ++;
							break;
					default:    // should never happen
							break;
				}
				SrcBytesCopied += FreeMpduSize;
				pDest          += FreeMpduSize;
				MpduSize       += FreeMpduSize;
				SrcBufPA       += FreeMpduSize;
				SrcBufLen      -= FreeMpduSize;

				// a complete MPDU is built. break out to write TXD of this MPDU
				break;
			}

			// advance to next scatter-gather BUFFER
			SrcBufIdx++;
			if (SrcBufIdx < pScatterGatherList->NumberOfElements)
			{
				SrcBufPA = NdisGetPhysicalAddressLow(pScatterGatherList->Elements[SrcBufIdx].Address);
				SrcBufLen = pScatterGatherList->Elements[SrcBufIdx].Length;
			}
			else
				SrcBufLen = 0;

			if (SrcBufLen == 0)
				break;

		}   while (TRUE);       // End of copying payload

		// remaining size of the NDIS packet payload
		SrcRemainingBytes -= SrcBytesCopied;

		//
		// STEP 5.6 MODIFY MORE_FRAGMENT BIT & DURATION FIELD. WRITE TXD
		//
		pHeader80211 = (PHEADER_802_11)pDestBufVA;
		if (SrcRemainingBytes > 0) // more fragment is required
		{
			UINT NextMpduSize;
			NextMpduSize = min(SrcRemainingBytes, pAd->CommonCfg.FragmentThreshold);
			pHeader80211->FC.MoreFrag = 1;
			pHeader80211->Duration = (3 * pAd->CommonCfg.Dsifs) + (2 * AckDuration) + RTMPCalcDuration(pAd, TxRate, NextMpduSize + EncryptionOverhead);

			RTUSBWriteTxDescriptor(pAd, pTxD, CipherAlg, KeyTable, KeyIdx, bAckRequired, TRUE, FALSE,
								  RetryMode, FrameGap, TxRate, MpduSize, QueIdx, PID);

			FrameGap = IFS_SIFS;     // use SIFS for all subsequent fragments
			Header_802_11.Frag ++;   // increase Frag #
		}
		else // this is the last or only fragment
		{
			pHeader80211->FC.MoreFrag = 0;
			if (pHeader80211->Addr1[0] & 0x01) // multicast/broadcast
				pHeader80211->Duration = 0;
			else
				pHeader80211->Duration = pAd->CommonCfg.Dsifs + AckDuration;

			if ((bEAPOLFrame) && (TxRate > RATE_6))
				TxRate = RATE_6;

			RTUSBWriteTxDescriptor(pAd, pTxD, CipherAlg, KeyTable, KeyIdx, bAckRequired, FALSE, FALSE,
								  RetryMode, FrameGap, TxRate, MpduSize, QueIdx, PID);
		}

		//INC_RING_INDEX(pTxRing->CurTxIndex, TX_RING_SIZE);
		//pAd->RalinkCounters.KickTxCount++;
		TransferBufferLength = TxSize + sizeof(TXD_STRUC);

		if ((TransferBufferLength % 4) == 1)
			TransferBufferLength  += 3;
		else if ((TransferBufferLength % 4) == 2)
			TransferBufferLength  += 2;
		else if ((TransferBufferLength % 4) == 3)
			TransferBufferLength  += 1;


		if ((TransferBufferLength % pAd->BulkOutMaxPacketSize) == 0)
			TransferBufferLength += 4;

		NdisZeroMemory(pTxContext->TransferBuffer->Aggregation, 4);
		NdisMoveMemory(pTxContext->Header_802_3, Header_802_3, LENGTH_802_3);
		pTxContext->TxRate = TxRate;
		pTxContext->DataOffset = DataOffSet;
		pTxContext->BulkOutSize = TransferBufferLength;
		pTxContext->bAggregatible = bAggregatible;
		pTxContext->bWaitingBulkOut = TRUE;

		RTUSB_SET_BULK_FLAG(pAd, (fRTUSB_BULK_OUT_DATA_NORMAL << QueIdx));

		// Set frame gap for the rest of fragment burst.
		// It won't matter if there is only one fragment (single fragment frame).
		StartOfFrame = FALSE;
		NumberRequired--;
		if (NumberRequired == 0)
		{
			pTxContext->LastOne = TRUE;
		}
		else
		{
			pTxContext->LastOne = FALSE;
		}

		NdisInterlockedIncrement(&pAd->TxCount);

	} while (NumberRequired > 0);

	// Make sure to release Tx ring resource
	NdisReleaseSpinLock(&pAd->TxRingLock);

	// -------------------------------------------------
	// STEP 6. KICK TX AND EXIT
	// -------------------------------------------------

	/*if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
	{
		//
		// Kick all TX rings, QID_AC_VO, QID_AC_VI, QID_AC_BE, QID_AC_VK.
		//
		RTUSBWriteMACRegister(pAd, TX_CNTL_CSR, 0x0000000f);
	}
	else
	{
		if (QueIdx <= QID_AC_VO)
		{
			RTUSBWriteMACRegister(pAd, TX_CNTL_CSR, BIT8[QueIdx]);
		}
	}*/

	// the NDIS PACKET "pPacket" will be released at DMA done interrupt service routine
	return (NDIS_STATUS_SUCCESS);
}

#endif

VOID APFindEncryptKey(
	IN PRTMP_ADAPTER pAd,
	IN UCHAR         WdsOrAid,
	IN BOOLEAN       bEAPOLFrame,
	IN BOOLEAN       bMulticast,
	OUT PUCHAR       pCipherAlg,
	OUT PUCHAR       pKeyTable,
	OUT PUCHAR       pKeyIdx,
	OUT PCIPHER_KEY  *ppCipherKey)
{
	*ppCipherKey = NULL;

	if ((bEAPOLFrame)                                               ||
		(pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)  ||
		(pAd->CommonCfg.WepStatus == Ndis802_11Encryption3Enabled))
	{
		if (WdsOrAid & 0x80)        // to WDS link
		{
			*pKeyIdx     = WDS_PAIRWISE_KEY_OFFSET + (WdsOrAid & 0x7f);
			*pKeyTable   = 1;
			*pCipherAlg  = pAd->MacTab.Content[*pKeyIdx].PairwiseKey.CipherAlg;
			if (*pCipherAlg)
				*ppCipherKey = &pAd->MacTab.Content[*pKeyIdx].PairwiseKey;
		}
		else if (bMulticast)        // M/BCAST to local BSS, use default key in shared key table
		{
			*pKeyIdx     = pAd->CommonCfg.DefaultKeyId;
			*pKeyTable   = 0;
			*pCipherAlg  = pAd->SharedKey[BSS0][*pKeyIdx].CipherAlg;
			if (*pCipherAlg)
				*ppCipherKey = &pAd->SharedKey[BSS0][*pKeyIdx];
		}
		else                        // unicast to local BSS
		{
			*pKeyIdx     = WdsOrAid;
			*pKeyTable   = 1;
			*pCipherAlg  = pAd->MacTab.Content[*pKeyIdx].PairwiseKey.CipherAlg;
			if (*pCipherAlg)
				*ppCipherKey = &pAd->MacTab.Content[*pKeyIdx].PairwiseKey;
		}
	}
	else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled) // WEP or CKIP, always use shared key table
	{
#if 0
		if (pAd->StaCfg.CkipFlag & 0x10) // Cisco CKIP KP is on
		{
			if (LEAP_CCKM_ON(pAd))
			{
				if (bMulticast)
					*pKeyIdx = 1;
				else
					*pKeyIdx = 0;
			}
			else
				*pKeyIdx = pAd->CommonCfg.DefaultKeyId;
		}
		else if (pAd->StaCfg.CkipFlag & 0x08) // only CKIP CMIC
			*pKeyIdx = pAd->CommonCfg.DefaultKeyId;
		else if (LEAP_CCKM_ON(pAd))
		{
			if (bMulticast)
				*pKeyIdx = 1;
			else
				*pKeyIdx = 0;
		}
		else    // standard WEP64 or WEP128
#endif
			*pKeyIdx = pAd->CommonCfg.DefaultKeyId;

		*pKeyTable   = 0;    // shared key table
		*pCipherAlg  = pAd->SharedKey[BSS0][*pKeyIdx].CipherAlg;
		if (*pCipherAlg)
			*ppCipherKey = &pAd->SharedKey[BSS0][*pKeyIdx];
	}
	else
	{
		*pCipherAlg = CIPHER_NONE;
		*pKeyTable  = 0;
		*pKeyIdx    = 0;
		*ppCipherKey = NULL;
	}

	DBGPRINT(RT_DEBUG_TRACE,("APFindEncryptKey(EAPOL=%d, Mcast=%d) to AID#%d, Alg=%s, KeyTab=%d, key#=%d\n",
		bEAPOLFrame, bMulticast, WdsOrAid, CipherName[*pCipherAlg], *pKeyTable,*pKeyIdx));

}

/*
	========================================================================
	Routine Description:
		Check Rx descriptor, return NDIS_STATUS_FAILURE if any error found
	========================================================================
*/
NDIS_STATUS APCheckRxError(
	IN  PRXD_STRUC  pRxD)
{
	if (pRxD->Crc || pRxD->CipherErr)
		return NDIS_STATUS_FAILURE;
	else
		return NDIS_STATUS_SUCCESS;
}

/*
  ========================================================================
  Description:
	This routine checks if a received frame causes class 2 or class 3
	error, and perform error action (DEAUTH or DISASSOC) accordingly
  ========================================================================
*/
BOOLEAN APCheckClass2Class3Error(
	IN  PRTMP_ADAPTER   pAd,
	IN  PHEADER_802_11  pHeader)
{
	SST Sst;
	UCHAR PsMode, Rate;
	USHORT Aid;

	APSsPsInquiry(pAd, pHeader->Addr2, &Sst, &Aid, &PsMode, &Rate);
	if (Sst == SST_ASSOC)
		; // okay to receive this DATA frame
	else if (Sst == SST_AUTH)
	{
		APCls3errAction(pAd, pHeader->Addr2);
		return TRUE;
	}
	else
	{
		APCls2errAction(pAd, pHeader->Addr2);
		return TRUE;
	}
	return FALSE;
}

/*
  ========================================================================
  Description:
	This routine frees all packets in PSQ that's destined to a specific DA.
	BCAST/MCAST in DTIMCount=0 case is also handled here, just like a PS-POLL
	is received from a WSTA which has MAC address FF:FF:FF:FF:FF:FF
  ========================================================================
*/
VOID APHandleRxPsPoll(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pAddr,
	IN  USHORT          Aid,
    IN  BOOLEAN			isActive)
{
#if 1
	PQUEUE_ENTRY	pEntry;
	PMAC_TABLE_ENTRY  pMacEntry;
	unsigned long   IrqFlags;
	unsigned long   IrqFlags2;


	pMacEntry = MacTableLookup(pAd, pAddr);

	if (!pMacEntry)
		return;

    DBGPRINT(RT_DEBUG_TRACE,("(%d):rcv PS-POLL(%d) from %02x:%02x:%02x:%02x:%02x:%02x\n",
		isActive, pMacEntry->PsQueue.Number,
        pAddr[0], pAddr[1], pAddr[2], pAddr[3], pAddr[4], pAddr[5]));

    if (pMacEntry)
    {
        Aid = pMacEntry->Aid;
		NdisAcquireSpinLock(&pAd->MacTabLock, IrqFlags);
		NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[QID_AC_BE], IrqFlags2);

        // cleanup all backlogged frames in PSQ

        if (isActive == FALSE)
		{
			if (pMacEntry->PsQueue.Head)
			{
				if (pAd->SendTxWaitQueue[QID_AC_BE].Number <= (MAX_PACKETS_IN_QUEUE + (MAX_PACKETS_IN_PS_QUEUE>>1))) {
					pEntry = RemoveHeadQueue(&pMacEntry->PsQueue);

                    if (pMacEntry->PsQueue.Number)
    					RTMP_SET_PACKET_MOREDATA((struct sk_buff *) pEntry, TRUE);

					InsertTailQueue(&pAd->SendTxWaitQueue[QID_AC_BE], pEntry);
				}
			}
		}
		else
		{
			while (pMacEntry->PsQueue.Head)
			{
				if (pAd->SendTxWaitQueue[QID_AC_BE].Number <= (MAX_PACKETS_IN_QUEUE + (MAX_PACKETS_IN_PS_QUEUE>>1))) {
					pEntry = RemoveHeadQueue(&pMacEntry->PsQueue);
					InsertTailQueue(&pAd->SendTxWaitQueue[QID_AC_BE], pEntry);
				} else {
					break;
				}
			}
		}

		NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[QID_AC_BE], IrqFlags2);
		NdisReleaseSpinLock(&pAd->MacTabLock, IrqFlags);

        if ((Aid > 0) && (Aid < MAX_LEN_OF_MAC_TABLE) && (pMacEntry->PsQueue.Number == 0))
        {
            // clear corresponding TIM bit
			if (Aid >= 32)
				pAd->ApCfg.TimBitmap2 &= (~BIT32[Aid-32]);
			else
				pAd->ApCfg.TimBitmap &= (~BIT32[Aid]);

            /* ~~sample, bug fix for TIM update, 2006/10/04 */
            if ((pAd->ApCfg.TimBitmap == 0) && (pAd->ApCfg.TimBitmap2 == 0))
                pAd->ApCfg.bTimUpdate = 1;

            pMacEntry->PsQIdleCount = 0;
        }

        // Dequeue outgoing frames from TxSwQueue0..3 queue and process it
        // TODO: 2004-12-27 it's not a good idea to handle "More Data" bit here. because the
        // RTMPDeQueue process doesn't guarantee to de-queue the desired MSDU from the corresponding
        // TxSwQueue/PsQueue when QOS in-used. We should consider "HardTransmt" this MPDU
        // using MGMT queue or things like that.
		RTMPDeQueuePacket(pAd,QID_AC_BE);
		RTUSBKickBulkOut(pAd);
    }

#else
	PQUEUE_ENTRY      pEntry;
	PMAC_TABLE_ENTRY  pMacEntry;
	BOOLEAN     MoreData  = FALSE;
	unsigned long   IrqFlags;
	unsigned long   IrqFlags2;

	//DBGPRINT(RT_DEBUG_TRACE,("rcv PS-POLL (AID=%d) from %02x:%02x:%02x:%02x:%02x:%02x\n",
	//    Aid, pAddr[0], pAddr[1], pAddr[2], pAddr[3], pAddr[4], pAddr[5]));

	pMacEntry = MacTableLookup(pAd, pAddr);
	if (pMacEntry)
	{
		Aid = pMacEntry->Aid;
		NdisAcquireSpinLock(&pAd->MacTabLock, IrqFlags);
		NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[QID_AC_BE], IrqFlags2);
		// cleanup all backlogged frames in PSQ
		if(pMacEntry->PsQueue.Number >1)
		{
			MoreData = TRUE;
		}
		if (pMacEntry->PsQueue.Head)
		{
			pEntry = RemoveHeadQueue(&pMacEntry->PsQueue);
			InsertTailQueue(&pAd->SendTxWaitQueue[QID_AC_BE], pEntry);
		}

		NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[QID_AC_BE], IrqFlags2);
		NdisReleaseSpinLock(&pAd->MacTabLock, IrqFlags);
		if ((Aid > 0) && (Aid < MAX_LEN_OF_MAC_TABLE) && (pMacEntry->PsQueue.Number == 0))
		{
			// clear corresponding TIM bit
			if (Aid >= 32)
				pAd->ApCfg.TimBitmap2 &= (~BIT32[Aid-32]);
			else
				pAd->ApCfg.TimBitmap &= (~BIT32[Aid]);

            /* ~~sample, bug fix for TIM update, 2006/10/04 */
            if ((pAd->ApCfg.TimBitmap == 0) && (pAd->ApCfg.TimBitmap2 == 0))
                pAd->ApCfg.bTimUpdate = 1;

			pMacEntry->PsQIdleCount = 0;
		}

		// Dequeue outgoing frames from TxSwQueue0..3 queue and process it
		// TODO: 2004-12-27 it's not a good idea to handle "More Data" bit here. because the
		// RTMPDeQueue process doesn't guarantee to de-queue the desired MSDU from the corresponding
		// TxSwQueue/PsQueue when QOS in-used. We should consider "HardTransmt" this MPDU
		// using MGMT queue or things like that.
		RTMPDeQueuePacket(pAd,QID_AC_BE);
		RTUSBKickBulkOut(pAd);
	}
#endif
}

/*
	========================================================================
	Routine Description:
		This function checks if the received frames should be sent out to the
		wireless media based on DA look-up in the wirelss MAC table.

	Arguments:
		pRxD        Pointer to the Rx descriptor

	Return Value:
		TRUE -  the input frame is destined to a known wireless STA
				and had been sent out to the wireless media. It's not
				necessary to make another copy up to LLC nor Portal function.
		FALSE - the input frame still need to deliver to the upper LLC
	========================================================================
*/
BOOLEAN APBridgeToWdsAndWirelessSta(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pHeader802_3,
	IN  UINT            HdrLen,
	IN  PUCHAR          pData,
	IN  UINT            DataLen,
	IN  ULONG           fromwdsidx)
{
	SST             Sst;
	USHORT          Aid;
	UCHAR           PsMode, Rate;
	MAC_TABLE_ENTRY *pEntry;
	BOOLEAN         result = FALSE;
	PNDIS_PACKET    pPacket;
    struct sk_buff  *skb_p; /* ~~sample, add, 2006/09/28 */
//       PNDIS_BUFFER    pBuffer;
//	NDIS_STATUS     Status;
//	UCHAR           *pVirtualAddress;
//	UCHAR           wdsidx, i;
//	ULONG           num;
//	WDS_ENTRY       *pWdsEntry;

	// If DA is our AP, call NdisMEthIndicateReceive directly. No more bridging is required
	if (MAC_ADDR_EQUAL(pAd->CurrentAddress, pHeader802_3))
		return FALSE;
	DBGPRINT_RAW(RT_DEBUG_TRACE, ("APBridgeToWdsAndWirelessSta current bulkout idx=%d\n",pAd->NextBulkOutIndex[0]));
	// decide the return value. TRUE if no need to indicate to LLC, FALSE otherwise
	pEntry = APSsPsInquiry(pAd, pHeader802_3, &Sst, &Aid, &PsMode, &Rate);
	if (pHeader802_3[0] & 0x01)
		result = FALSE;
	else if (pEntry && (Sst == SST_ASSOC))
		result = TRUE;
	else
		result = FALSE;

	//
	// case 1. if either a M/BCAST or a known unicast within the local BSS, then send to BSS
	//
	if ((! pAd->ApCfg.bIsolateInterStaTraffic) && ((*pHeader802_3 & 0x01) || (pEntry && (Sst == SST_ASSOC))))
	{
		do {
			// build an NDIS packet
#if 0 /* ~~sample, modification, 2006/09/28 */
            NdisAllocatePacket(&Status,&pPacket, pAd->FreeNdisPacketPoolHandle);
	            if (Status != NDIS_STATUS_SUCCESS)
	                break;

            Status = NdisAllocateMemoryWithTag(&pVirtualAddress, HdrLen+DataLen, NIC_TAG);
            if (Status != NDIS_STATUS_SUCCESS)
            {
        	         DBGPRINT(RT_DEBUG_WARN,("alloc ndis packet fail\n"));
                NdisFreePacket(pPacket);
                break;
            }

            NdisAllocateBuffer(&Status, &pBuffer, pAd->FreeNdisBufferPoolHandle, pVirtualAddress, HdrLen+DataLen);
            if (Status != NDIS_STATUS_SUCCESS)
            {
            	   DBGPRINT(RT_DEBUG_WARN,("alloc ndis buffer  fail\n"));
                NdisFreeMemory(pVirtualAddress, HdrLen+DataLen, 0);
                NdisFreePacket(pPacket);
                break;
            }

            NdisChainBufferAtFront(pPacket, pBuffer);

            // 2. clone the Ethernet frame, and Send down frame like normal NDIS
            //    transmission request
            NdisMoveMemory(pVirtualAddress, pHeader802_3, HdrLen);
            NdisMoveMemory(pVirtualAddress + HdrLen, pData, DataLen);


			DBGPRINT(RT_DEBUG_WARN,("WBRG - len=%d, from WDS #%d, to AID #%d, DA=%02x:%02x:%02x:%02x:%02x:%02x\n",
				HdrLen+DataLen, fromwdsidx, Aid, pHeader802_3[0], pHeader802_3[1],pHeader802_3[2],pHeader802_3[3],pHeader802_3[4],pHeader802_3[5]));
#else

            skb_p = __dev_alloc_skb(HdrLen + DataLen + 2, MEM_ALLOC_FLAG);

            if (skb_p != NULL)
            {
                skb_p->len = HdrLen + DataLen;
                memcpy((skb_p->data), pHeader802_3, HdrLen);
                memcpy((skb_p->data + HdrLen), pData, DataLen);
                pPacket = (PNDIS_PACKET)skb_p;
                RTMP_SET_PACKET_SOURCE(skb_p, PKTSRC_DRIVER);
            }
            else
                break;
            /* End of if */
#endif /* #if 0 */

			// send out the packet
			RTMP_SET_PACKET_WDS(pPacket, (UCHAR)Aid);
			APSendPacket(pAd, pPacket); // send to one of TX queue

			RTMPDeQueuePacket(pAd,0);     // Dequeue outgoing frames from TxSwQueue0..3 queue and process it
			// RTUSBEnqueueInternalCmd(pAd, RT_OID_KICK_BULKOUT, NULL, 0);
			// Kick bulk out
			RTUSBKickBulkOut(pAd);
		} while (FALSE);
	}

#ifdef  WDS
	//
	// case 2. M/BCAST or unknown unicast (not found in local BSS), then try WDS links
	//
	if (!(pEntry && (Sst == SST_ASSOC)) || ((*pHeader802_3 & 0x01) != 0))
	{
		wdsidx = 0xFF;
		num = pAd->WdsTab.Size;

		if ((*pHeader802_3 & 0x01) == 0)    // unknown unicast (DA not in local BSS)
		{
			for (i = 0; i < pAd->WdsTab.Size; i++)
			{
				pWdsEntry = WdsTableLookup(pAd, pHeader802_3, i);
				if(pWdsEntry)
				{
					wdsidx = i;
					num = 1;
					result = TRUE;  // unicast to a known client, so no need to forward to upper layer
					DBGPRINT(RT_DEBUG_INFO, ("WBRG to WDS - Packet unicast to WDS(%d)\n", i));
					break;
				}
			}
		}

		for (i = 0; i < num; i++)
		{
			// To avoid WDS loop (AP-AP)
			if (((wdsidx == 0xff) && (i == fromwdsidx)) || (wdsidx == fromwdsidx))
				continue;

			// build an NDIS packet

        	            NdisAllocatePacket(&Status,&pPacket, pAd->FreeNdisPacketPoolHandle);
		            if (Status != NDIS_STATUS_SUCCESS)
			                break;

		            Status = NdisAllocateMemoryWithTag(&pVirtualAddress, HdrLen+DataLen, NIC_TAG);
		            if (Status != NDIS_STATUS_SUCCESS)
		            {
		                NdisFreePacket(pPacket);
		                break;
		            }

		            NdisAllocateBuffer(&Status, &pBuffer, pAd->FreeNdisBufferPoolHandle, pVirtualAddress, HdrLen+DataLen);
		            if (Status != NDIS_STATUS_SUCCESS)
		            {
		                NdisFreeMemory(pVirtualAddress, HdrLen+DataLen, 0);
		                NdisFreePacket(pPacket);
		                break;
		            }

		            NdisChainBufferAtFront(pPacket, pBuffer);

		            // 2. clone the Ethernet frame, and Send down frame like normal NDIS
		            //    transmission request
		            NdisMoveMemory(pVirtualAddress, pHeader802_3, HdrLen);
		            NdisMoveMemory(pVirtualAddress + HdrLen, pData, DataLen);

			if (wdsidx == 0xff)
				RTMP_SET_PACKET_WDS(pPacket, 0x80 | i); // b7 as WDS bit, b0-6 as WDS indes when b7==1
			else
				RTMP_SET_PACKET_WDS(pPacket, 0x80 | wdsidx); // b7 as WDS bit, b0-6 as WDS indes when b7==1

			DBGPRINT(RT_DEBUG_INFO,("WBRG- len=%d, from WDS #%d to WDS #%d, DA=%02x:%02x:%02x:%02x:%02x:%02x\n",
				HdrLen+DataLen, fromwdsidx, RTMP_GET_PACKET_WDS(pPacket) & 0x7f,
				pHeader802_3[0],pHeader802_3[1],pHeader802_3[2],pHeader802_3[3],pHeader802_3[4],pHeader802_3[5]));

			// send out the packet
			APSendPacket(pAd, pPacket); // send to one of TX queue
			for (i =0;i < 4;i++)
				RTMPDeQueuePacket(pAd,i);     // Dequeue outgoing frames from TxSwQueue0..3 queue and process it
			// Kick bulk out
			RTUSBKickBulkOut(pAd);

		}
	}
#endif

	return result;
}

#if 0 // Dennis Lee
VOID RTMPFreeNdisPacket(
	IN PRTMP_ADAPTER pAd,
	IN PNDIS_PACKET  pPacket)
{
       UINT  Length;
	PNDIS_BUFFER pBuffer;
       UCHAR *pVirtualAddress;

	NdisUnchainBufferAtFront(pPacket, &pBuffer);
	#if _WIN32_WINNT >= 0x0501
	    NdisQueryBufferSafe(
            pBuffer,
            &pVirtualAddress,
            &Length,
            NormalPagePriority);
	#else
    	    NdisQueryBuffer(pBuffer, &pVirtualAddress, &Length);
       #endif
       NdisFreeMemory(pVirtualAddress, Length, 0);


	NdisFreeBuffer(pBuffer);
	NdisFreePacket(pPacket);
       DBGPRINT(RT_DEBUG_TRACE, ("RELASE NDIS PACKET \n"));
}
#endif

#ifdef BIG_ENDIAN
/*
	========================================================================

	Routine Description:
		Endian conversion of Tx/Rx descriptor .

	Arguments:
		pAd     Pointer to our adapter
		pData           Pointer to Tx/Rx descriptor
		DescriptorType  Direction of the frame

	Return Value:
		None

	Note:
		Call this function when read or update descriptor
	========================================================================
*/
VOID    RTMPDescriptorEndianChange(
	IN  PUCHAR          pData,
	IN  ULONG           DescriptorType)
{
	*((ULONG *)(pData + 40)) = SWAP32(*((ULONG *)(pData + 40)));        // Byte 10
	if(DescriptorType == TYPE_TXD)
		*((ULONG *)(pData + 8)) = SWAP32(*((ULONG *)(pData + 8)));      // Byte 2
	*(ULONG *)pData = SWAP32(*(ULONG *)pData);                          // Byte 0; this must be swapped last
}

/*
	========================================================================

	Routine Description:
		Endian conversion of all kinds of 802.11 frames .

	Arguments:
		pAd     Pointer to our adapter
		pData           Pointer to the 802.11 frame structure
		Dir             Direction of the frame
		FromRxDoneInt   Caller is from RxDone interrupt

	Return Value:
		None

	Note:
		Call this function when read or update buffer data
	========================================================================
*/
VOID    RTMPFrameEndianChange(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pData,
	IN  ULONG           Dir,
	IN  BOOLEAN         FromRxDoneInt)
{
	PHEADER_802_11 pFrame;
	PUCHAR  pMacHdr;

	// swab 16 bit fields - Frame Control field
	if(Dir == DIR_READ)
	{
		*(USHORT *)pData = SWAP16(*(USHORT *)pData);
	}

	pFrame = (PHEADER_802_11) pData;
	pMacHdr = (PUCHAR) pFrame;

	// swab 16 bit fields - Duration/ID field
	*(USHORT *)(pMacHdr + 2) = SWAP16(*(USHORT *)(pMacHdr + 2));

	// swab 16 bit fields - Sequence Control field
	*(USHORT *)(pMacHdr + 22) = SWAP16(*(USHORT *)(pMacHdr + 22));

	if(pFrame->FC.Type == BTYPE_MGMT)
	{
		switch(pFrame->FC.SubType)
		{
			case SUBTYPE_ASSOC_REQ:
			case SUBTYPE_REASSOC_REQ:
				// swab 16 bit fields - CapabilityInfo field
				pMacHdr += sizeof(HEADER_802_11);
				*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);

				// swab 16 bit fields - Listen Interval field
				pMacHdr += 2;
				*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);
				break;

			case SUBTYPE_ASSOC_RSP:
			case SUBTYPE_REASSOC_RSP:
				// swab 16 bit fields - CapabilityInfo field
				pMacHdr += sizeof(HEADER_802_11);
				*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);

				// swab 16 bit fields - Status Code field
				pMacHdr += 2;
				*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);

				// swab 16 bit fields - AID field
				pMacHdr += 2;
				*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);
				break;

			case SUBTYPE_AUTH:
				// If from APHandleRxDoneInterrupt routine, it is still a encrypt format.
				// The convertion is delayed to RTMPHandleDecryptionDoneInterrupt.
				if(!FromRxDoneInt)
				{
					// swab 16 bit fields - Auth Alg No. field
					pMacHdr += sizeof(HEADER_802_11);
					*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);

					// swab 16 bit fields - Auth Seq No. field
					pMacHdr += 2;
					*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);

					// swab 16 bit fields - Status Code field
					pMacHdr += 2;
					*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);
				}
				break;

			case SUBTYPE_BEACON:
			case SUBTYPE_PROBE_RSP:
				// swab 16 bit fields - BeaconInterval field
				pMacHdr += (sizeof(HEADER_802_11) + TIMESTAMP_LEN);
				*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);

				// swab 16 bit fields - CapabilityInfo field
				pMacHdr += sizeof(USHORT);
				*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);
				break;

			case SUBTYPE_DEAUTH:
			case SUBTYPE_DISASSOC:
				// swab 16 bit fields - Reason code field
				pMacHdr += sizeof(HEADER_802_11);
				*(USHORT *)pMacHdr = SWAP16(*(USHORT *)pMacHdr);
				break;
		}
	}
	else if( pFrame->Type == BTYPE_DATA )
	{
	}
	else if(pFrame->Type == BTYPE_CNTL)
	{
	}
	else
	{
		DBGPRINT(RT_DEBUG_ERROR,"Invalid Frame Type!!!\n");
	}

	// swab 16 bit fields - Frame Control
	if(Dir == DIR_WRITE)
	{
		*(USHORT *)pData = SWAP16(*(USHORT *)pData);
	}
}
#endif


